/************************************************************************
 ** Copyright (c) 1994, Aaron Jackson
 ** All rights reserved
 **
 ** Permission to use, copy, modify, and distribute this software and
 ** its documentation for any purpose and without fee is hereby granted,
 ** provided that the above copyright notice appear in all copies and
 ** that both that copyright notice and this permission notice appear in
 ** supporting documentation.
 **
 ** In no event shall the author(s) be liable to any party for direct,
 ** indirect, special, incidental, or consequential damages arising out
 ** of the use of this software and its documentation, even if the
 ** authors(s) have been advised of the possibility of such damage.
 **
 ** The authors(s) specifically disclaim any warranties, including but
 ** not limited to, the implied warranties of merchantability and
 ** fitness for a particular purpose.  The software provided hereunder
 ** is on an "as is" basis, and the author(s) have no obligation to
 ** provide maintenance, support, updates, enhancements, or modifications
 ************************************************************************/


static char rcsid[] = "$Header: /home/edsdev/cvstree/tcldev/vwtable/vwHash.c,v 1.2 1994/11/11 21:36:30 aajackso Exp $" ;

/**
 ** $Log: vwHash.c,v $
 * Revision 1.2  1994/11/11  21:36:30  aajackso
 * *** empty log message ***
 *
 * Revision 1.1.1.1  1994/10/21  13:35:20  aajackso
 * Table Widget
 *
 * Revision 1.1  1994/08/24  00:55:59  aaron
 * Initial revision
 *
 **/

#include <stddef.h>
#include <malloc.h>
#include <memory.h>
#include <vwHash.h>

/************************************************************************
 ** void
 ** VWHashTable_Free( VWHashTable*  vwhash )
 **
 ** Free all entries in the hash table
 ************************************************************************/

#ifdef __STDC__
void
VWHashTable_Free( VWHashTable*    vwhash )
#else /** __STDC__ **/
void
VWHashTable_Free( vwhash )
    VWHashTable*    vwhash ;
#endif /** __STDC__ **/
{
  register unsigned long i ;

  if (( vwhash == NULL ) || ( vwhash->nodes == NULL ))
    return ;

  for ( i = 0 ; i < vwhash->size ; i++ )
    if ( vwhash->nodes[i] != NULL )
      {
	VWHashNode* node ;

	for ( node  = vwhash->nodes[i] ;
	      node != NULL ; 
	      node  = vwhash->nodes[i] )
	  {
	    vwhash->nodes[i] = vwhash->nodes[i]->next ;
	    if (vwhash->free)
	      vwhash->free(node->key, node->keysize, node->addr, node->addrsize) ;
	    free((char *) node) ;
	  }

	free((char *) vwhash->nodes[i]) ;
      }
}

/************************************************************************
 ** void
 ** VWHashTable_Alloc( VWHashTable*     vwhash,
 **                    unsigned long    n_entries )
 **
 ** Allocate the hash table with n_entries buckets
 ************************************************************************/

#ifdef __STDC__
void
VWHashTable_Alloc( VWHashTable*       vwhash,
                   unsigned long      n_entries )
#else /** __STDC__ **/
void
VWHashTable_Alloc( vwhash, n_entries )
    VWHashTable*       vwhash ;
    unsigned long      n_entries ;
#endif /** __STDC__ **/
{
  /**
   ** If it becomes a nice feature we will add hash rebalancing
   **/

  if ( vwhash->nodes != NULL )
    return ;

  vwhash->size = n_entries ;
  vwhash->nodes = (VWHashNode **) malloc(n_entries * sizeof(VWHashNode*)) ;
  memset((char *) vwhash->nodes, 0x0, n_entries * sizeof(VWHashNode*)) ;
}

/************************************************************************
 ** int
 ** VWHashTable_Find( VWHashTable*                vwhash,
 **                   void*                       key,
 **                   unsigned long               keysize,
 **                   void**                      truekey,
 **                   void**                      addr,
 **                   unsigned long*              addrsize )
 ** 
 ** Find an entry within the hash table, return the true key and
 ** address of data if requested
 ************************************************************************/

#ifdef __STDC__
int
VWHashTable_Find( VWHashTable*                   vwhash,
                  void*                          key,
                  unsigned long                  keysize,
                  void**                         truekey,
                  void**                         addr,
                  unsigned long*                 addrsize )
#else /** __STDC__ **/
int
VWHashTable_Find( vwhash, key, keysize, truekey, addr, addrsize )
    VWHashTable*                   vwhash ;
    void*                          key ;
    unsigned long                  keysize ;
    void**                         truekey ;
    void**                         addr ;
    unsigned long*                 addrsize ;
#endif /** __STDC__ **/
{
  unsigned long hash = vwhash->hash(key, keysize) % vwhash->size ;
  VWHashNode* node ;

  for ( node  = vwhash->nodes[hash] ;
        node != NULL ; 
        node  = node->next )
    {
      if (( node->key == key ) ||
	  (( node->keysize == keysize ) &&
	   ( vwhash->comp(key, node->key, node->keysize) == 0 )))
	{
	  if ( addr )     addr[0] = node->addr ;
	  if ( addrsize ) addrsize[0] = node->addrsize ;
	  if ( truekey )  truekey[0] = node->key ;

	  return 1 ;
	}
    }

  return 0 ;
}

#ifdef __STDC__
int
VWHashTable_Insert( VWHashTable*                vwhash,
                    void*                       key,
                    unsigned long               keysize,
                    void*                       addr,
                    unsigned long               addrsize )
#else /** __STDC__ **/
int
VWHashTable_Insert( vwhash, key, keysize, addr, addrsize )
    VWHashTable*                vwhash ;
    void*                       key ;
    unsigned long               keysize ;
    void*                       addr ;
    unsigned long               addrsize ;
#endif /** __STDC__ **/
{
  unsigned long hash = vwhash->hash(key, keysize) % vwhash->size ;
  VWHashNode* node ;

  for ( node  = vwhash->nodes[hash] ;
        node != NULL ; 
        node  = node->next )
    {
      if (( node->key == key ) ||
	  (( node->keysize == keysize ) &&
	   ( vwhash->comp(key, node->key, node->keysize) == 0 )))
	{
	  return 0 ;
	}
    }

  node = (VWHashNode *) malloc(sizeof(VWHashNode)) ;
  node->key = key ;
  node->keysize = keysize ;
  node->addr = addr ;
  node->addrsize = addrsize ;
  node->next = vwhash->nodes[hash] ;
  
  vwhash->nodes[hash] = node ;
  return 0 ;
}

#ifdef __STDC__
int
VWHashTable_Remove( VWHashTable*                   vwhash,
                    void*                          key,
                    unsigned long                  keysize,
                    void**                         truekey,
                    void**                         addr,
                    unsigned long*                 addrsize )
#else /** __STDC__ **/
int
VWHashTable_Remove( vwhash, key, keysize, truekey, addr, addrsize )
    VWHashTable*                   vwhash ;
    void*                          key ;
    unsigned long                  keysize ;
    void**                         truekey ;
    void**                         addr ;
    unsigned long*                 addrsize ;
#endif /** __STDC__ **/
{
  unsigned long hash = vwhash->hash(key, keysize) % vwhash->size ;
  VWHashNode* parent = NULL ;
  VWHashNode* node ;

  for ( node  = vwhash->nodes[hash] ;
        node != NULL ; 
        node  = node->next )
    {
      if (( node->key == key ) ||
	  (( node->keysize == keysize ) &&
	   ( vwhash->comp(key, node->key, node->keysize) == 0 )))
	{
	  if ( addr )     addr[0] = node->addr ;
	  if ( addrsize ) addrsize[0] = node->addrsize ;
	  if ( truekey )  truekey[0] = node->key ;

	  /** Reassociate the node links **/

	  if ( parent == NULL )
	    vwhash->nodes[hash] = NULL ;
	  else
	    parent->next = node->next ;

	  /** Free up any last memory **/

	  if (vwhash->free)
	    vwhash->free(node->key, node->keysize, node->addr, node->addrsize) ;
	  free((char *) node);

	  return 1 ;
	}

      parent = node ;
    }

  return 0 ;
}




