/*
 * $Id: xessfns.h,v 1.1 1994/08/26 14:37:13 johnsonm Exp $
 *
 * Copyright (c) 1992 General Electric.  All rights reserved.
 *
 *   Permission to use, copy, modify, and distribute this
 *   software and its documentation for any purpose and without
 *   fee is hereby granted, provided that the above copyright
 *   notice appear in all copies and that both that copyright
 *   notice and this permission notice appear in supporting
 *   documentation, and that the name of General Electric not be used in
 *   advertising or publicity pertaining to distribution of the
 *   software without specific, written prior permission.
 *   General Electric makes no representations about the suitability of
 *   this software for any purpose.  It is provided "as is"
 *   without express or implied warranty.
 *
 *   This work was supported by the DARPA Initiative in Concurrent
 *   Engineering (DICE) through DARPA Contract MDA972-88-C-0047.
 *
 * $Log: xessfns.h,v $
 * Revision 1.1  1994/08/26  14:37:13  johnsonm
 * Initial revision
 *
 *
 * Old log:
 * Revision 1.2  1994/02/28  21:00:14  kennykb
 * Added declaration for the xess_display function, which was previously
 * unused.
 *
 * Revision 1.1  1992/10/09  18:56:28  kennykb
 * Initial revision
 *
 *
 * xessfns.h
 *
 *	Declarations of the functions in the Xess Connection Library
 *	for older versions of xess.h that don't have them.
 *
 */

extern int xess_new_display _ANSI_ARGS_((Display *));
extern int xess_set_display _ANSI_ARGS_((int));
extern int xess_establish_connection _ANSI_ARGS_((char *, int));
extern void xess_close_connection _ANSI_ARGS_((int));
extern int xess_test_connection _ANSI_ARGS_((int));
extern char * xess_version _ANSI_ARGS_((int));

extern int xess_get_value _ANSI_ARGS_((int, int, int, double *, char * *));
extern int xess_get_string _ANSI_ARGS_((int, int, int, char * *));
extern int xess_get_number _ANSI_ARGS_((int, int, int, double *));
extern int xess_get_formula _ANSI_ARGS_((int, int, int, char * *));

extern void xess_store_number _ANSI_ARGS_((int, int, int, double));
extern void xess_store_formatted_number _ANSI_ARGS_((int, int, int, double,
						     int, int, int));
extern void xess_store_tagged_number _ANSI_ARGS_((int, int, int, double));
extern void xess_store_label _ANSI_ARGS_((int, int, int, char *));
extern void xess_store_formula _ANSI_ARGS_((int, int, int, char *));

extern int xess_get_location _ANSI_ARGS_((int, int *, int *));
extern int xess_goto _ANSI_ARGS_((int, int, int));
extern int xess_moveto _ANSI_ARGS_((int, int, int));

extern long xess_create_menu _ANSI_ARGS_((int, char *));
extern long xess_create_button _ANSI_ARGS_((int, long, char *, void (*)(void),
					    int));
extern long xess_delete_menu _ANSI_ARGS_((int, long));
extern long xess_delete_button _ANSI_ARGS_((int, long, long));
extern void xess_dialog _ANSI_ARGS_((int, char *, char *,
				     void (*)(int, char *)));
/* xess_get_input not supported in tcl */
extern void xess_display_message _ANSI_ARGS_((int, char *));
extern void xess_recalc _ANSI_ARGS_((int, int, int, Range[]));
extern int xess_evaluate_cell _ANSI_ARGS_((int, int, int,
					   double *, char * *));
extern int xess_evaluate_expr _ANSI_ARGS_((int, char *, double *, char * *));
extern int xess_get_range _ANSI_ARGS_((int, int *, int *, int *, int *));
extern int xess_get_selected _ANSI_ARGS_((int, int *, int *, int *, int *));
extern int xess_get_extent _ANSI_ARGS_((int, int *, int *, int *, int *));
extern void xess_scroll_range _ANSI_ARGS_((int, int, int, int, int, int));
extern int xess_copy_range _ANSI_ARGS_((int, int, Range, Range));
extern int xess_erase_range _ANSI_ARGS_((int, Range));
extern int xess_move_range _ANSI_ARGS_((int, Range, int, int));
extern int xess_insert_rows _ANSI_ARGS_((int, int, int));
extern int xess_insert_cols _ANSI_ARGS_((int, int, int));
extern int xess_delete_rows _ANSI_ARGS_((int, int, int));
extern int xess_delete_cols _ANSI_ARGS_((int, int, int));
extern int xess_clear_sheet _ANSI_ARGS_((int));
extern int xess_define_name _ANSI_ARGS_((int, Range *, char *));
extern int xess_resolve_name _ANSI_ARGS_((int, Range *, char *));
extern void xess_delete_name _ANSI_ARGS_((int, char *));
extern void xess_install_function _ANSI_ARGS_((int, char *,
					       Operand (*)(Operand *), int));
extern int xess_find_label _ANSI_ARGS_((int, char *, int *, int *));
extern int xess_find_label_in_range _ANSI_ARGS_((int, char *,
						 int, int, int, int,
						 int *, int *));
extern int xess_evaluate_constraint _ANSI_ARGS_((int, int, int));
extern int xess_recalc_constraints _ANSI_ARGS_((int));
extern int xess_read_file _ANSI_ARGS_((int, char *));
extern int xess_write_file _ANSI_ARGS_((int, char *));
extern int xess_print _ANSI_ARGS_((int, int, Range, char *));
extern int xess_import _ANSI_ARGS_((int, int, char *, int, int));
extern int xess_export _ANSI_ARGS_((int, int, char *, Range));

extern int xess_set_close_notify _ANSI_ARGS_((void (*)(int)));
extern int xess_message_handler _ANSI_ARGS_((XEvent *));

extern void xess_user_lock _ANSI_ARGS_((int, int));
extern void xess_flush_port _ANSI_ARGS_((int));

extern Window xess_window _ANSI_ARGS_((int));

extern int xess_set_receiver _ANSI_ARGS_((void (*)(int, char [15])));
extern Display * xess_display _ANSI_ARGS_((int));

extern int mgr_connect _ANSI_ARGS_((int, Window, char *));
