static char copyright []
= "$Id: xessRecvCallback.c,v 1.1 1994/08/26 14:14:19 johnsonm Exp $\n\
   Copyright (c) 1992 General Electric.  All rights reserved.";

/*
 *   Permission to use, copy, modify, and distribute this
 *   software and its documentation for any purpose and without
 *   fee is hereby granted, provided that the above copyright
 *   notice appear in all copies and that both that copyright
 *   notice and this permission notice appear in supporting
 *   documentation, and that the name of General Electric not be used in
 *   advertising or publicity pertaining to distribution of the
 *   software without specific, written prior permission.
 *   General Electric makes no representations about the suitability of
 *   this software for any purpose.  It is provided "as is"
 *   without express or implied warranty.
 *
 *   This work was supported by the DARPA Initiative in Concurrent
 *   Engineering (DICE) through DARPA Contract MDA972-88-C-0047.
 *
 * $Log: xessRecvCallback.c,v $
 * Revision 1.1  1994/08/26  14:14:19  johnsonm
 * Initial revision
 *
 *
 * Old log:
 * Revision 1.2  1994/02/28  20:59:58  kennykb
 * Removed #includes that are now obtained from tclXessInt.h
 *
 * Revision 1.1  1992/10/09  19:09:43  kennykb
 * Initial revision
 *
 *
 * xessReceiveCallback.c --
 *
 * 	This file contains the code needed to handle a callback from the
 * Xess interface that reports a message from another client, and report it
 * back to the Tcl environment for further processing.
 *
 */

#include "tclXessInt.h"

/*
 * xessReceiveCallback --
 *
 *	This function is called from the Xess connection library when a
 * message is received from another Xess client. It locates the connection 
 * object, executes the Tcl procedure responsible for reporting the message,
 * and returns.
 */

void
XessReceiveCallback (port, message)
     int port;
     char message [15];
{
  char msg [16];
  XessConnection * connection;
  int status;

  /* Find the connection entry in the connection table */

  connection = XessConnTable [port];

  /* Execute the user-specified callback to process the message */

  if (connection != NULL) {
    strncmp (msg, message, 15);
    msg [15] = '\0';
    XessCallbackMessage = msg;

    Tcl_ResetResult (connection -> interp);
    status = XessEvalCallback (connection,
			       connection -> interp,
			       connection -> messageCmd,
			       "CDNPWm");

    if (status != TCL_OK) {
      xess_display_message (connection -> port,
			    connection -> interp -> result);
    }
    Tcl_ResetResult (connection -> interp);
    XessCallbackMessage = "";
  }
}
