static char copyright []
= "$Id: xessOptionFlag.c,v 1.1 1994/08/26 14:10:44 johnsonm Exp $\n\
   Copyright (c) 1992 General Electric.  All rights reserved.";

/*
 *   Permission to use, copy, modify, and distribute this
 *   software and its documentation for any purpose and without
 *   fee is hereby granted, provided that the above copyright
 *   notice appear in all copies and that both that copyright
 *   notice and this permission notice appear in supporting
 *   documentation, and that the name of General Electric not be used in
 *   advertising or publicity pertaining to distribution of the
 *   software without specific, written prior permission.
 *   General Electric makes no representations about the suitability of
 *   this software for any purpose.  It is provided "as is"
 *   without express or implied warranty.
 *
 *   This work was supported by the DARPA Initiative in Concurrent
 *   Engineering (DICE) through DARPA Contract MDA972-88-C-0047.
 *
 * $Log: xessOptionFlag.c,v $
 * Revision 1.1  1994/08/26  14:10:44  johnsonm
 * Initial revision
 *
 *
 * Old log:
 * Revision 1.2  1994/02/28  20:59:10  kennykb
 * Removed #includes that are now obtained from tclXessInt.h
 *
 * Revision 1.1  1992/10/09  19:08:26  kennykb
 * Initial revision
 *
 *
 * xessOptionFlag.c --
 *
 *	Several of the Xess connection library calls accept a bit mask
 *	indicating which options are to be set/changed.  This file contains
 *	procedures that allow Tk_ConfigureWidget to set bits in this mask
 *	according to the options specified on a command line.
 */

#include "tclXessInt.h"

/*
 * xessOptionFlagParseProc --
 *	Called as a custom parse procedure from Tk_ConfigureWidget.  The
 *      clientData is the bit to set, and the `widgrec' and `offset' fields
 *	identify the mask word.
 */

/* ARGSUSED */
int
xessOptionFlagParseProc (clientData, interp, tkwin, value, widgrec, offset)
     ClientData clientData;
     Tcl_Interp * interp;
     Tk_Window tkwin;
     char * value;
     char * widgrec;
     int offset;
{
  int bit = (int) clientData;
  int * place = (int *) (widgrec + offset);
  *place |= bit;
  return TCL_OK;
}

/*
 * xessOptionFlagPrintProc --
 *	Each custom option has to have a print procedure.  Since the flag
 * 	options are always grouped, the print procedure is meaningless; this
 *	one is at least harmless.
 */

/* ARGSUSED */
char *
xessOptionFlagPrintProc (clientData, tkwin, widgrec, offset, freeProcPtr)
     ClientData clientData;
     Tk_Window tkwin;
     char * widgrec;
     int offset;
     Tcl_FreeProc * * freeProcPtr;
{
  return ""; 
}
