static char copyright []
= "$Id: xessNamedRange.c,v 1.1 1994/08/26 14:08:06 johnsonm Exp $\n\
   Copyright (c) 1992 General Electric.  All rights reserved.";

/*
 *   Permission to use, copy, modify, and distribute this
 *   software and its documentation for any purpose and without
 *   fee is hereby granted, provided that the above copyright
 *   notice appear in all copies and that both that copyright
 *   notice and this permission notice appear in supporting
 *   documentation, and that the name of General Electric not be used in
 *   advertising or publicity pertaining to distribution of the
 *   software without specific, written prior permission.
 *   General Electric makes no representations about the suitability of
 *   this software for any purpose.  It is provided "as is"
 *   without express or implied warranty.
 *
 *   This work was supported by the DARPA Initiative in Concurrent
 *   Engineering (DICE) through DARPA Contract MDA972-88-C-0047.
 *
 * $Log: xessNamedRange.c,v $
 * Revision 1.1  1994/08/26  14:08:06  johnsonm
 * Initial revision
 *
 *
 * Old log:
 * Revision 1.2  1994/02/28  20:58:57  kennykb
 * Removed #includes that are now obtained from tclXessInt.h
 *
 * Revision 1.1  1992/10/09  19:08:12  kennykb
 * Initial revision
 *
 *
 * xessNamedRange.c --
 *
 *	Tcl bindings for Xess connection library routines dealing with
 *	named ranges on spreadsheets
 */

#include "tclXessInt.h"

/*
 * XessConnObj_define_name_cmd --
 *
 *	Tcl command on an Xess connection object to define a named range
 *	in a spreadsheet
 *
 * Syntax:
 *	connection define_name name range
 *
 * Where:
 *	connection is the name of an Xess connection object
 *	name is the name of a range
 *	range is the names new definition.
 *
 * Notes:
 *	If a range is previously defined, its old definition will be lost and
 *	the new definition will replace it.
 *
 * Result:
 *	Returns a standard Tcl result, usually empty.
 */

int
XessConnObj_define_name_cmd (clientData, interp, argc, argv)
     ClientData clientData;
     Tcl_Interp * interp;
     int argc;
     char * * argv;
{
  XessConnection * conn = (XessConnection *) clientData;
  Range range;
  int status;

  /* Check syntax */

  if (argc != 3) {
    Tcl_AppendResult (interp, "wrong # args, should be \"", argv [-1], " ",
		      argv [0], " name range\"", (char *) NULL);
    return TCL_ERROR;
  }
  status = xessGetRange (interp, argv [2], &range);
  if (status != 0) return status;

  /* Name the range */

  status = xess_define_name (conn -> port, &range, argv [1]);
  switch (status)
    {
    case 0:
      Tcl_SetResult (interp, "range not defined", TCL_STATIC);
      return TCL_ERROR;
    case 1:
      return TCL_OK;
    default:
      sprintf (interp -> result,
	       "xess_define_name returned unexpected status %d",
	       status);
      return TCL_ERROR;
    }
}

/*
 * XessConnObj_resolve_name_cmd --
 *
 *	Tcl command on an Xess connection object to resolve a named range
 *	in a spreadsheet
 *
 * Syntax:
 *	connection resolve_name name
 *
 * Where:
 *	connection is the name of an Xess connection object
 *	name is the name of a range
 *
 * Result:
 *	Returns a standard Tcl result, which will contain a specification of
 *	the range if the operation is successful.
 */

int
XessConnObj_resolve_name_cmd (clientData, interp, argc, argv)
     ClientData clientData;
     Tcl_Interp * interp;
     int argc;
     char * * argv;
{
  XessConnection * conn = (XessConnection *) clientData;
  Range range;
  int status;

  /* Check syntax */

  if (argc != 2) {
    Tcl_AppendResult (interp, "wrong # args, should be \"", argv [-1], " ",
		      argv [0], " name\"", (char *) NULL);
    return TCL_ERROR;
  }

  /* Resolve the range */

  status = xess_resolve_name (conn -> port, &range, argv [1]);
  switch (status)
    {
    case 0:
      Tcl_SetResult (interp, "range not resolved", TCL_STATIC);
      return TCL_ERROR;
    case 1:
      break;
    default:
      sprintf (interp -> result,
	       "xess_resolve_name returned unexpected status %d",
	       status);
      return TCL_ERROR;
    }

  /* Translate the resulting range */

  status = xessStoreRange (interp, &range, interp -> result, (char * *) NULL);
  return status;
}

/*
 * XessConnObj_delete_name_cmd --
 *
 *	Tcl command on an Xess connection object to delete a named range
 *	in a spreadsheet
 *
 * Syntax:
 *	connection delete_name name
 *
 * Where:
 *	connection is the name of an Xess connection object
 *	name is the name of a range
 *
 * Result:
 *	Returns a standard Tcl result, normally empty.
 */

int
XessConnObj_delete_name_cmd (clientData, interp, argc, argv)
     ClientData clientData;
     Tcl_Interp * interp;
     int argc;
     char * * argv;
{
  XessConnection * conn = (XessConnection *) clientData;

  /* Check syntax */

  if (argc != 2) {
    Tcl_AppendResult (interp, "wrong # args, should be \"", argv [-1], " ",
		      argv [0], " name\"", (char *) NULL);
    return TCL_ERROR;
  }

  /* Delete the range */

  xess_delete_name (conn -> port, argv [1]);
  return TCL_OK;
}
