char RCSid_xessLabel_c []
= "$Id: xessLabel.c,v 1.1 1994/08/26 14:06:33 johnsonm Exp $";
/*
 *   Permission to use, copy, modify, and distribute this
 *   software and its documentation for any purpose and without
 *   fee is hereby granted, provided that the above copyright
 *   notice appear in all copies and that both that copyright
 *   notice and this permission notice appear in supporting
 *   documentation, and that the name of General Electric not be used in
 *   advertising or publicity pertaining to distribution of the
 *   software without specific, written prior permission.
 *   General Electric makes no representations about the suitability of
 *   this software for any purpose.  It is provided "as is"
 *   without express or implied warranty.
 *
 *   This work was supported by the DARPA Initiative in Concurrent
 *   Engineering (DICE) through DARPA Contract MDA972-88-C-0047.
 *
 * $Log: xessLabel.c,v $
 * Revision 1.1  1994/08/26  14:06:33  johnsonm
 * Initial revision
 *
 *
 * Old log:
 * Revision 1.4  1994/03/02  23:00:09  kennykb
 * Further cleanup of RCS identification.
 *
 * Revision 1.3  1994/03/02  22:55:28  kennykb
 * Fixed typo in RCS identification
 *
 * Revision 1.2  1994/02/28  20:57:41  kennykb
 * Removed #includes that are now obtained from tclXessInt.h
 * Changed call to Tk_ParseArgv to obtain application main window in a
 * standard way.
 *
 * Revision 1.1  1992/10/09  19:07:59  kennykb
 * Initial revision
 *
 *
 * xessLabel.c --
 *
 *	This file contains the functions providing a Tcl interface to the
 * `Searching for Labels' functions in the Xess connection library.
 */

#include "tclXessInt.h"

/*
 * XessConnObj_find_label_cmd --
 *
 *	Command on an Xess connection object to find a label in a sheet, or
 *	in a specified range.
 *
 * Syntax:
 *	connection find_label text ?-in range?
 *
 * Where:
 *	connection is an Xess connection ID.
 *	text is the text of the label to be found.
 *
 * Options:
 *	-in range
 *		Specifies a range of the sheet to which the search is to
 *		be limited.  Default is the sheet's entire extent.
 *
 * Result:
 *	Returns a standard Tcl result, normally expected to be the cell
 *	number of the first place where the specified label was found.
 */

static Range range;
static Tk_ArgvInfo findLabelOpts [] = {
  {"-in", TK_ARGV_GENFUNC, (char *) xessGetRangeArgv, (char *) &range,
     "Range of the sheet to search (default is entire sheet)."},
  {(char *) NULL, TK_ARGV_END, (char *) NULL, (char *) NULL, (char *) NULL}
};

int
XessConnObj_find_label_cmd (clientData, interp, argc, argv)
     ClientData clientData;
     Tcl_Interp * interp;
     int argc;
     char * * argv;
{
  XessConnection * conn = (XessConnection *) clientData;
  int status;
  XessCell cell;

  /* Parse the command line */

  range.r0 = 0;
  status = Tk_ParseArgv (interp, Tk_MainWindow (interp),
			 &argc, argv, findLabelOpts, 0);
  if (status != TCL_OK)
    return status;
  if (argc != 2) {
    Tcl_AppendResult (interp, "wrong # args, should be \"", argv [-1], " ",
		      argv [0], " text ?-in range?\"", (char *) NULL);
    return TCL_ERROR;
  }

  /* Find the label */

  if (range.r0 == 0)
    status = xess_find_label (conn -> port, argv [1],
			      &(cell.row), &(cell.col));
  else
    status = xess_find_label_in_range (conn -> port, argv [1],
				       range.r0, range.c0, range.r1, range.c1,
				       &(cell.row), &(cell.col));

  /* Decode status return */

  switch (status)
    {
    case 0:
      Tcl_SetResult (interp, "label not found", TCL_STATIC);
      return TCL_ERROR;
    case 1:
      break;
    default:
      sprintf (interp -> result,
	       "xess_find_label returned unexpected status %d",
	       status);
      return TCL_ERROR;
    }

  /* Convert cell address to alphanumeric */

  status = xessStoreCell (interp, cell.row, cell.col, 0, interp -> result,
			  (char * *) NULL);
  return status;
}
