static char copyright []
= "$Id: xessGetPrinttype.c,v 1.1 1994/08/26 14:03:59 johnsonm Exp $\n\
   Copyright (c) 1992 General Electric.  All rights reserved.";

/*
 *   Permission to use, copy, modify, and distribute this
 *   software and its documentation for any purpose and without
 *   fee is hereby granted, provided that the above copyright
 *   notice appear in all copies and that both that copyright
 *   notice and this permission notice appear in supporting
 *   documentation, and that the name of General Electric not be used in
 *   advertising or publicity pertaining to distribution of the
 *   software without specific, written prior permission.
 *   General Electric makes no representations about the suitability of
 *   this software for any purpose.  It is provided "as is"
 *   without express or implied warranty.
 *
 *   This work was supported by the DARPA Initiative in Concurrent
 *   Engineering (DICE) through DARPA Contract MDA972-88-C-0047.
 *
 * $Log: xessGetPrinttype.c,v $
 * Revision 1.1  1994/08/26  14:03:59  johnsonm
 * Initial revision
 *
 *
 * Old log:
 * Revision 1.2  1994/02/28  20:57:27  kennykb
 * Removed #includes that are now obtained from tclXessInt.h
 *
 * Revision 1.1  1992/10/09  19:07:48  kennykb
 * Initial revision
 *
 *
 * xessGetPrinttype.c --
 *
 *	This file contains all the support needed to parse Xess printtype
 *	specifications.
 */

#include "tclXessInt.h"

static char * xessParsePrinttype _ANSI_ARGS_((char *, int *));
				/* Service function that does the work */

static char * parseError;	/* Error message from the parse */

/*
 * xessGetPrinttype --
 *	Get an Xess printtype code and return it in `printtype'.
 *	Returns a Tcl status.
 */

int
xessGetPrinttype (interp, string, printtype)
     Tcl_Interp * interp;
     char * string;
     int * printtype;
{
  char * result;
  result = xessParsePrinttype (string, printtype);
  if (result == NULL)
    return TCL_OK;
  Tcl_SetResult (interp, result, TCL_STATIC);
  return TCL_ERROR;
}

/*
 * xessGetPrinttypeArgv --
 *
 * 	Do xessGetPrinttype from the context of Tk_ParseArgv.
 */

TK_MAKE_GENFUNC( xessGetPrinttypeArgv, int, xessGetPrinttype )

/*
 * xessParsePrinttype --
 *
 *	This function does all the real work of parsing a print type
 */

static char *
xessParsePrinttype (string, printtype)
     char * string;
     int * printtype;
{
  int len;
  len = strlen (string);
  if (strncmp (string, "ascii", len) == 0) {
    *printtype = PRINT_ASCII;
    return NULL;
  }
  else if (strncmp (string, "ps", len) == 0) {
    *printtype = PRINT_PS;
    return NULL;
  }
  else if (strncmp (string, "postscript", len) == 0) {
    *printtype = PRINT_PS;
    return NULL;
  }
  else {
    return "unknown print type -- must be \"ascii\" or \"ps\"";
  }
}
