static char copyright []
= "$Id: xessGetFormat.c,v 1.3 1994/11/09 14:40:04 johnsonm Exp $\n\
   Copyright (c) 1992 General Electric.  All rights reserved.\n\
   Copyright (C) 1994 Applied Information Systems.  All rights reserved.";

/*
 *   Permission to use, copy, modify, and distribute this
 *   software and its documentation for any purpose and without
 *   fee is hereby granted, provided that the above copyright
 *   notice appear in all copies and that both that copyright
 *   notice and this permission notice appear in supporting
 *   documentation, and that the name of General Electric not be used in
 *   advertising or publicity pertaining to distribution of the
 *   software without specific, written prior permission.
 *   General Electric makes no representations about the suitability of
 *   this software for any purpose.  It is provided "as is"
 *   without express or implied warranty.
 *
 *   This work was supported by the DARPA Initiative in Concurrent
 *   Engineering (DICE) through DARPA Contract MDA972-88-C-0047.
 *
 * $Log: xessGetFormat.c,v $
 * Revision 1.3  1994/11/09  14:40:04  johnsonm
 * *** empty log message ***
 *
 * Revision 1.2  1994/10/13  16:57:32  johnsonm
 * Added include of tclXessInt.h
 *
 * Revision 1.1  1994/08/26  14:02:37  johnsonm
 * Initial revision
 *
 *
 * Old log:
 * Revision 1.2  1994/02/28  20:57:11  kennykb
 * Removed #includes that are now obtained from tclXessInt.h
 *
 * Revision 1.1  1992/10/09  19:07:35  kennykb
 * Initial revision
 *
 *
 * xessGetFormat.c --
 *
 *	This file contains all the support needed to parse Xess format
 *	specifications.
 */

#include "tclXessInt.h"

static char * xessParseFormat _ANSI_ARGS_((char *, int *));
				/* Service function that does the work */

static char * parseError;	/* Error message from the parse */

/*
 * xessGetFormat --
 *	Get an Xess format code and return it in `format'.
 *	Returns a Tcl status.
 */

int
xessGetFormat (interp, formatname, format)
     Tcl_Interp * interp;
     char * formatname;
     int * format;
{
  char * result;
  result = xessParseFormat (formatname, format);
  if (result == NULL)
    return TCL_OK;
  Tcl_SetResult (interp, result, TCL_STATIC);
  return TCL_ERROR;
}

/*
 * xessGetFormatArgv --
 *
 *	Do xessGetFormat from the context of Tk_ParseArgv.
 */

TK_MAKE_GENFUNC( xessGetFormatArgv, int, xessGetFormat )

/*
 * xessParseFormat --
 *
 *	This function does all the real work of parsing a format name
 */

static char *
xessParseFormat (formatName, format)
     char * formatName;
     int * format;
{
  int len;
  len = strlen (formatName);
  if (len == 1 && strchr ("*efg$,hlabcdit%x", *formatName) != NULL) {
    *format = *formatName;
    return (char *) NULL;
  } else {
    return "unknown format name";
  }
}
