static char copyright []
= "$Id: xessGetFiletype.c,v 1.1 1994/08/26 13:59:49 johnsonm Exp $\n\
   Copyright (c) 1992 General Electric.  All rights reserved.";

/*
 *   Permission to use, copy, modify, and distribute this
 *   software and its documentation for any purpose and without
 *   fee is hereby granted, provided that the above copyright
 *   notice appear in all copies and that both that copyright
 *   notice and this permission notice appear in supporting
 *   documentation, and that the name of General Electric not be used in
 *   advertising or publicity pertaining to distribution of the
 *   software without specific, written prior permission.
 *   General Electric makes no representations about the suitability of
 *   this software for any purpose.  It is provided "as is"
 *   without express or implied warranty.
 *
 *   This work was supported by the DARPA Initiative in Concurrent
 *   Engineering (DICE) through DARPA Contract MDA972-88-C-0047.
 *
 * $Log: xessGetFiletype.c,v $
 * Revision 1.1  1994/08/26  13:59:49  johnsonm
 * Initial revision
 *
 *
 * Old log:
 * Revision 1.2  1994/02/28  20:56:39  kennykb
 * Removed #includes that are now obtained from tclXessInt.h
 *
 * Revision 1.1  1992/10/09  19:07:12  kennykb
 * Initial revision
 *
 *
 * xessGetFiletype.c --
 *
 *	This file contains all the support needed to parse Xess Filetype
 *	specifications.
 */

#include "tclXessInt.h"

static char * xessParseFiletype _ANSI_ARGS_((char *, int *));
				/* Service function that does the work */

static char * parseError;	/* Error message from the parse */

/*
 * xessGetFiletype --
 *	Get an Xess filetype code and return it in `filetype'.
 *	Returns a Tcl status.
 */

int
xessGetFiletype (interp, string, filetype)
     Tcl_Interp * interp;
     char * string;
     int * filetype;
{
  char * result;
  result = xessParseFiletype (string, filetype);
  if (result == NULL)
    return TCL_OK;
  Tcl_SetResult (interp, result, TCL_STATIC);
  return TCL_ERROR;
}

/*
 * xessGetFiletypeArgv --
 *
 * 	Do xessGetFiletype from the context of Tk_ParseArgv.
 */

TK_MAKE_GENFUNC( xessGetFiletypeArgv, int, xessGetFiletype )

/*
 * xessParseFiletype --
 *
 *	This function does all the real work of parsing a file type
 */

static char *
xessParseFiletype (string, filetype)
     char * string;
     int * filetype;
{
  int len;
  len = strlen (string);
  if (strncmp (string, "csv", len) == 0) {
    *filetype = CSV_FILE;
    return NULL;
  }
  else if (len >= 4 && strncmp (string, "text", len) == 0) {
    *filetype = TEXT_FILE;
    return NULL;
  }
  else if (len >= 3 && strncmp (string, "tex", len) == 0) {
    *filetype = TEX_FILE;
    return NULL;
  }
  else if (len >= 2 && strncmp (string, "tsv", len) == 0) {
    *filetype = TSV_FILE;
    return NULL;
  }
  else if (len >= 3 && strncmp (string, "wk1", len) == 0) {
    *filetype = WK1_FILE;
    return NULL;
  }
  else if (len >= 3 && strncmp (string, "wks", len) == 0) {
    *filetype = WKS_FILE;
    return NULL;
  }
  else if (strncmp (string, "xsc", len) == 0) {
    *filetype = XSC_FILE;
    return NULL;
  }
  else {
    return "unknown file type -- must be \"csv\", \"tex\", \"text\",\
 \"tsv\", \"wk1\", \"wks\", or \"xsc\"";
  }
}
