static char copyright []
= "$Id: xessEvalCallback.c,v 1.1 1994/08/26 13:53:14 johnsonm Exp $\n\
   Copyright (c) 1992 General Electric.  All rights reserved.";

/*
 *   Permission to use, copy, modify, and distribute this
 *   software and its documentation for any purpose and without
 *   fee is hereby granted, provided that the above copyright
 *   notice appear in all copies and that both that copyright
 *   notice and this permission notice appear in supporting
 *   documentation, and that the name of General Electric not be used in
 *   advertising or publicity pertaining to distribution of the
 *   software without specific, written prior permission.
 *   General Electric makes no representations about the suitability of
 *   this software for any purpose.  It is provided "as is"
 *   without express or implied warranty.
 *
 *   This work was supported by the DARPA Initiative in Concurrent
 *   Engineering (DICE) through DARPA Contract MDA972-88-C-0047.
 *
 * $Log: xessEvalCallback.c,v $
 * Revision 1.1  1994/08/26  13:53:14  johnsonm
 * Initial revision
 *
 *
 * Old log:
 * Revision 1.2  1994/02/28  20:54:25  kennykb
 * Removed #includes that are now obtained from tclXessInt.h
 * Changed code to obtain display pointer from the conneciton library rather
 * than carrying it in the XessConnection structure.
 * Changed Tcl_Eval call for version 7 compatibility.
 *
 * Revision 1.1  1992/10/09  19:05:51  kennykb
 * Initial revision
 *
 *
 * xessEvalCallback.c --
 *
 *	This file contains the procedures that process commands bound to
 * objects in the Tcl-Xess interface.  Its primary external user interface
 * is a procedure called xessEvalCallback that accepts
 *	- a connection object (optional - may be NULL)
 *	- a Tcl interpreter
 *	- a command to evaluate
 *	- a set of %-argument substitutions that the command accepts
 * It performs the %-substitutions, calls the Tcl interpreter to evaluate the
 * command, and reports any errors in the background if necessary.
 */

#include "tclXessInt.h"

char * XessCallbackMessage = "";
XessButton * XessCallbackButton = (XessButton *) NULL;

/* Static functions */

static void store_string _ANSI_ARGS_((char **, char *, char **, int *));
static void store_character _ANSI_ARGS_((char **, int, char **, int *));
static void expand_buffer _ANSI_ARGS_((char **, char **, int *));

/*
 * XessEvalCallback --
 *
 *	The following procedure processes a callback originating in the
 * Xess connection library.  It accepts a connection structure (which may
 * be NULL), a Tcl interpreter, a command to evaluate, and a list of
 * % substitutions that are permitted for the command.  The possible
 * % substitutions are:
 *
 *	%% - (ALWAYS ACCEPTED) - A literal percent sign.
 *	%B - The name of a button that was pressed.
 *	%C - The name of the connection object
 *	%D - The name of the display on which the Xess instance is running
 *	%M - The name of a menu from which a button was selected.
 *	%N - Xess's symbolic name for the connection.
 *	%P - The connection's port number.
 *	%W - The  X window ID of the Xess instance.
 *	%m - The message received from another Xess client
 */

int
XessEvalCallback (conn, interp, command, supported)
     XessConnection * conn;
     Tcl_Interp * interp;
     char * command;
     char * supported;
{
  char * buffer;
  int bufsize;
  char * from;
  char * to;
  char c;
  char workspace [80];
  int result;

  /* Don't process command if there is none. */

  if (command == NULL) return;

  /* Allocate an initial buffer to hold the expanded command */

  bufsize = strlen (command) + 1;
  buffer = ckalloc (bufsize);

  /* Walk through the command, looking for %'s */

  from = command;
  to = buffer;
  do {
    c = *from++;
    if (c != '%') {
      store_character (&to, c, &buffer, &bufsize);
    } else {

      /* Found a % - expand it. */

      c = *from++;
      if (c == '%') {
	store_character (&to, '%', &buffer, &bufsize);
      }
      else if (c == '\0' || strchr (supported, c) == NULL) {
	store_character (&to, '%', &buffer, &bufsize);
	store_character (&to, c, &buffer, &bufsize);
      }
      else {
	switch (c)
	  {
	  case 'B':
	    if (XessCallbackButton != NULL)
	      store_string (&to, XessCallbackButton -> objectName,
			    &buffer, &bufsize);
	    break;

	  case 'C':		/* Connection ID */
	    store_string (&to, conn -> objectName, &buffer, &bufsize);
	    break;

	  case 'D':		/* Display name */
	    store_string (&to, 
			  DisplayString (xess_display (conn -> port)),
			  &buffer, &bufsize);
	    break;

	  case 'M':
	    if (XessCallbackButton != NULL)
	      store_string (&to, XessCallbackButton -> menu -> objectName,
			    &buffer, &bufsize);
	    break;

	  case 'N':		/* Xess symbolic name for connection */
	    store_string (&to, conn -> name, &buffer, &bufsize);
	    break;

	  case 'P':		/* Port number */
	    sprintf (workspace, "%d", conn -> port);
	    store_string (&to, workspace, &buffer, &bufsize);
	    break;

	  case 'W':		/* Window token */
	    sprintf (workspace, "0x%lx", (unsigned long) conn -> window);
	    store_string (&to, workspace, &buffer, &bufsize);
	    break;

	  case 'm':
	    store_string (&to, XessCallbackMessage, &buffer, &bufsize);
	    break;

          default:
	    store_character (&to, '%', &buffer, &bufsize);
	    store_character (&to, c, &buffer, &bufsize);
	  }
      }
    }

  } while (c != '\0');

  /* Evaluate the command */

  result = Tcl_Eval (interp, buffer);

  (void) ckfree (buffer);
  return result;
}

/* 
 * store_string --
 *
 *	Store into `to' a copy of the string `from', expanding `buffer'
 * if necessary.
 */

static void
store_string (to, from, buffer, bufsize)
     char ** to;
     char * from;
     char ** buffer;
     int * bufsize;
{
  int len;
  int space_needed;

  len = strlen (from);
  space_needed = (*to - *buffer) + len;
  while (space_needed > *bufsize) {
    expand_buffer (to, buffer, bufsize);
  }
  strncpy (*to, from, len);
  *to += len;
}

/*
 * store_character --
 *
 *	Store the character `c' in `to', expanding `buffer' if necessary
 */

static void
store_character (to, c, buffer, bufsize)
     char ** to;
     int c;
     char ** buffer;
     int * bufsize;
{
  int space_needed;
  space_needed = (*to - *buffer) + 1;
  if (space_needed > *bufsize) {
    expand_buffer (to, buffer, bufsize);
  }
  **to = c;
  ++*to;
}

/*
 * expand_buffer --
 *
 *	Expand buffer `buffer' by doubling its length, `bufsize', and
 * copying its content.  Adjust the insertion pointer, `to'.
 */

static void
expand_buffer (to, buffer, bufsize)
     char ** to;
     char ** buffer;
     int * bufsize;
{
  int current_size = *to - *buffer;
  int new_size = *bufsize * 2;
  char * new_buffer = ckalloc (new_size);
  (void) strncpy (new_buffer, *buffer, current_size);
  (void) ckfree (*buffer);
  *buffer = new_buffer;
  *bufsize = new_size;
  *to = new_buffer + current_size;
}
