static char copyright []
= "$Id: xessDecode.c,v 1.1 1994/08/26 13:45:51 johnsonm Exp $\n\
   Copyright (c) 1992 General Electric.  All rights reserved.";

/*
 *   Permission to use, copy, modify, and distribute this
 *   software and its documentation for any purpose and without
 *   fee is hereby granted, provided that the above copyright
 *   notice appear in all copies and that both that copyright
 *   notice and this permission notice appear in supporting
 *   documentation, and that the name of General Electric not be used in
 *   advertising or publicity pertaining to distribution of the
 *   software without specific, written prior permission.
 *   General Electric makes no representations about the suitability of
 *   this software for any purpose.  It is provided "as is"
 *   without express or implied warranty.
 *
 *   This work was supported by the DARPA Initiative in Concurrent
 *   Engineering (DICE) through DARPA Contract MDA972-88-C-0047.
 *
 * $Log: xessDecode.c,v $
 * Revision 1.1  1994/08/26  13:45:51  johnsonm
 * Initial revision
 *
 *
 * Old log:
 * Revision 1.3  1994/03/02  22:54:22  kennykb
 * Made row and column numbers unsigned in a few places.  The Xess connection
 * library is inconsistent.
 *
 * Revision 1.2  1994/02/28  20:51:09  kennykb
 * Removed #includes that are now obtained from tclXessInt.h
 *
 * Revision 1.1  1992/10/09  19:04:09  kennykb
 * Initial revision
 *
 *
 * xessDecode.c --
 *
 *	This file contains the C source for the `xess' subcommands that
 *	decode row, column, range, and row specifications.
 */

#include "tclXessInt.h"

/*
 * Xess_decode_column_cmd --
 *
 *	Xess subcommand to decode a column specifier
 *
 * Syntax:
 *	xess decode_column column
 *
 * Where:
 *	column is a column number expressed in alphabetic form, with optional
 *		dollar sign for absolute addressing.
 *
 * Result:
 *	Returns a standard Tcl result, which is normally a two-element list
 *	comprising the column number and a binary digit that is 1 if absolute
 *	addressing was specified and 0 otherwise.
 */

/* ARGSUSED */
int
Xess_decode_column_cmd (clientData, interp, argc, argv)
     ClientData clientData;
     Tcl_Interp * interp;
     int argc;
     char * * argv;
{
  int status;
  unsigned column;
  int flags;

  if (argc != 2) {
    Tcl_AppendResult (interp, "wrong # args, should be \"", argv [-1], " ",
		      argv [0], " column#\"", (char *) NULL);
    return TCL_ERROR;
  }

  flags = 0;
  status = xessGetColumn (interp, argv [1], 0, &column, &flags,
			  (char * *) NULL);
  if (status != 0)
    return status;

  sprintf (interp -> result, "%d %d",
	   (int) column, ((flags & XESS_CELL_ABSCOL) != 0));
  return TCL_OK;
}

/*
 * Xess_decode_row_cmd --
 *
 *	Xess subcommand to decode a row specifier
 *
 * Syntax:
 *	xess decode_row row
 *
 * Where:
 *	row is a row number expressed in numeric form, with optional
 *		dollar sign for absolute addressing.
 *
 * Result:
 *	Returns a standard Tcl result, which is normally a two-element list
 *	comprising the row number and a binary digit that is 1 if absolute
 *	addressing was specified and 0 otherwise.
 */

/* ARGSUSED */
int
Xess_decode_row_cmd (clientData, interp, argc, argv)
     ClientData clientData;
     Tcl_Interp * interp;
     int argc;
     char * * argv;
{
  int status;
  unsigned row;
  int flags;

  if (argc != 2) {
    Tcl_AppendResult (interp, "wrong # args, should be \"", argv [-1], " ",
		      argv [0], " row#\"", (char *) NULL);
    return TCL_ERROR;
  }

  flags = 0;
  status = xessGetRow (interp, argv [1], 0, &row, &flags,
			  (char * *) NULL);
  if (status != 0)
    return status;

  sprintf (interp -> result, "%d %d",
	   (int) row, ((flags & XESS_CELL_ABSROW) != 0));
  return TCL_OK;
}

/*
 * Xess_decode_cell_cmd --
 *
 *	Xess subcommand to decode a cell specifier
 *
 * Syntax:
 *	xess decode_cell cell
 *
 * Where:
 *	cell is a cell number expressed in alphabetic form, with optional
 *		dollar sign for absolute addressing.
 *
 * Result:
 *	Returns a standard Tcl result, which is normally a three-element list
 *	comprising the row and column numbers and a pair of binary digits
 *	R and C that are 1 if absolute addressing was specified and
 *	0 otherwise.
 */

/* ARGSUSED */
int
Xess_decode_cell_cmd (clientData, interp, argc, argv)
     ClientData clientData;
     Tcl_Interp * interp;
     int argc;
     char * * argv;
{
  int status;
  XessCell cell;

  if (argc != 2) {
    Tcl_AppendResult (interp, "wrong # args, should be \"", argv [-1], " ",
		      argv [0], " cell#\"", (char *) NULL);
    return TCL_ERROR;
  }

  status = xessGetCell (interp, argv [1], &cell);
  if (status != 0)
    return status;

  sprintf (interp -> result, "%d %d %d%d", cell.row, cell.col,
	   ((cell.flags & XESS_CELL_ABSROW) != 0),
	   ((cell.flags & XESS_CELL_ABSCOL) != 0));
  return TCL_OK;
}

/*
 * Xess_decode_range_cmd --
 *
 *	Xess subcommand to decode a range specifier
 *
 * Syntax:
 *	xess decode_range range
 *
 * Where:
 *	range is a range expressed in alphanumeric form.
 *
 * Result:
 *	Returns a standard Tcl result, which is normally a two-element list
 *	comprising the specifications of the starting and ending cells
 *      in the same form as `xess decode_cell' returns them.
 */

/* ARGSUSED */
int
Xess_decode_range_cmd (clientData, interp, argc, argv)
     ClientData clientData;
     Tcl_Interp * interp;
     int argc;
     char * * argv;
{
  int status;
  Range range;

  if (argc != 2) {
    Tcl_AppendResult (interp, "wrong # args, should be \"", argv [-1], " ",
		      argv [0], " range#\"", (char *) NULL);
    return TCL_ERROR;
  }

  status = xessGetRange (interp, argv [1], &range);
  if (status != 0)
    return status;

  sprintf (interp -> result, "{%d %d %d%d} {%d %d %d%d}",
	   range.r0, range.c0,
	   ((range.flags & ABS_R0) != 0),
	   ((range.flags & ABS_C0) != 0),
	   range.r1, range.c1,
	   ((range.flags & ABS_R1) != 0),
	   ((range.flags & ABS_C1) != 0));
  return TCL_OK;
}
