static char copyright []
= "$Id: xessCOVersionCmd.c,v 1.1 1994/08/26 13:34:05 johnsonm Exp $\n\
   Copyright (c) 1992 General Electric.  All rights reserved.";

/*
 *   Permission to use, copy, modify, and distribute this
 *   software and its documentation for any purpose and without
 *   fee is hereby granted, provided that the above copyright
 *   notice appear in all copies and that both that copyright
 *   notice and this permission notice appear in supporting
 *   documentation, and that the name of General Electric not be used in
 *   advertising or publicity pertaining to distribution of the
 *   software without specific, written prior permission.
 *   General Electric makes no representations about the suitability of
 *   this software for any purpose.  It is provided "as is"
 *   without express or implied warranty.
 *
 *   This work was supported by the DARPA Initiative in Concurrent
 *   Engineering (DICE) through DARPA Contract MDA972-88-C-0047.
 *
 * $Log: xessCOVersionCmd.c,v $
 * Revision 1.1  1994/08/26  13:34:05  johnsonm
 * Initial revision
 *
 *
 * Old log:
 * Revision 1.1  1992/10/09  19:02:32  kennykb
 * Initial revision
 *
 *
 * xessCOVersionCmd.c --
 * 
 *	Handle the `version' command on an Xess connection object
 */

#include <tcl.h>
#include <tk.h>
#include "tclXessInt.h"

/*
 * XessConnObj_version_cmd --
 *
 *	Handle the `version' command on an Xess connection object
 *
 * Syntax:
 *
 *	connectionName version
 *
 * Where:
 *	connectionName is the name of an Xess connection object.
 *
 * Results:
 *	Returns a standard Tcl result, whose value is a string giving
 *	the version number of Xess that is running at the other end of
 *	the specified connection.
 */

int
XessConnObj_version_cmd (clientData, interp, argc, argv)
     ClientData clientData;
     Tcl_Interp * interp;
     int argc;
     char * * argv;
{
  XessConnection * conn = (XessConnection *) clientData;
  char * result;

  if (argc != 1) {
    Tcl_AppendResult (interp, "wrong # args, should be \"", argv [-1],
		      " ", argv [0], "\"", (char *) NULL);
    return TCL_ERROR;
  }

  result = xess_version (conn -> port);
  if (result == NULL) {
    Tcl_SetResult (interp, "internal error: port no longer valid", TCL_STATIC);
    conn -> flags |= XESS_CONNECTION_CLOSED;
    Tcl_DeleteCommand (interp, conn -> objectName);
    return TCL_ERROR;
  }
  else if (*result == '\0') {
    Tcl_SetResult (interp, "not connected", TCL_STATIC);
    Tcl_DeleteCommand (interp, conn -> objectName);
    return TCL_ERROR;
  }
  else {
    Tcl_SetResult (interp, result, TCL_VOLATILE);
    return TCL_OK;
  }
}
