/*
 * $Id: genfunc.h,v 1.1 1994/08/26 14:32:49 johnsonm Exp $
 *
 * Copyright (c) 1992 General Electric.  All rights reserved.
 *
 *   Permission to use, copy, modify, and distribute this
 *   software and its documentation for any purpose and without
 *   fee is hereby granted, provided that the above copyright
 *   notice appear in all copies and that both that copyright
 *   notice and this permission notice appear in supporting
 *   documentation, and that the name of General Electric not be used in
 *   advertising or publicity pertaining to distribution of the
 *   software without specific, written prior permission.
 *   General Electric makes no representations about the suitability of
 *   this software for any purpose.  It is provided "as is"
 *   without express or implied warranty.
 *
 *   This work was supported by the DARPA Initiative in Concurrent
 *   Engineering (DICE) through DARPA Contract MDA972-88-C-0047.
 *
 * $Log: genfunc.h,v $
 * Revision 1.1  1994/08/26  14:32:49  johnsonm
 * Initial revision
 *
 *
 *
 * Macros to aid in building parsers for Tk_ParseArgv and Tk_ConfigureWidget
 */

/* Macro to make a TK_ARGV_GENFUNC-callable function given a function name,
   the parameter type, and a parser name.

   Example:  To make a GENFUNC that duplicates TK_ARGV_INT, use:

   	TK_MAKE_GENFUNC( intGenfunc, int, Tcl_GetInt )

   Then, instead of an ArgvInfo like:

   { "-number", TK_ARGV_INT, (char *) NULL, (char *) &number, "Number" }

   one could use:

   { "-number", TK_ARGV_GENFUNC, (char *) intGenFunc, (char *) &number,
     "Number" }

   and the same effect would result.
*/

#define TK_DECLARE_GENFUNC( FUNCTION ) 					\
int FUNCTION _ANSI_ARGS_((char *, Tcl_Interp *, char *, int, char * *));

#define TK_MAKE_GENFUNC( FUNCTION, TYPE, PARSER ) 			\
int									\
FUNCTION (dest, interp, key, argc, argv)				\
     char * dest;							\
     Tcl_Interp * interp;						\
     char * key;							\
     int argc;								\
     char * * argv;							\
{									\
  int status;								\
  int i;								\
  TYPE * results = (TYPE *) dest;					\
  if (argc <= 0) {							\
    sprintf (interp -> result, "%s option requires a value", key);	\
    return -1;								\
  }									\
  status = PARSER (interp, argv [0], results);				\
  if (status != TCL_OK) 						\
    return -1;								\
  --argc;								\
  for (i = 0; i < argc; ++i)						\
    argv [i] = argv [i+1];						\
  return argc;								\
}

/* Macro to make a Tk_CustomOption - callable parse procedure given a
   procedure name, a parameter type, and the name of the underlying parse
   procedure.
 */

#define TK_DECLARE_CUSTOM_PARSE( FUNCTION )				\
int FUNCTION _ANSI_ARGS_((ClientData, Tcl_Interp *, Tk_Window,		\
                          char *, char *, int));

#define TK_MAKE_CUSTOM_PARSE( FUNCTION, TYPE, PARSER )			\
int									\
FUNCTION (clientData, interp, tkwin, value, widgRec, offset)		\
     ClientData clientData;						\
     Tcl_Interp * interp;						\
     Tk_Window tkwin;							\
     char * value;							\
     char * widgrec;							\
     int offset;							\
{									\
  return PARSER (interp, value, (TYPE *) (widgRec + offset));		\
}
  
