#!/usr/local/bin/tclXess -f

# This is a proceedure/control structure that can iterate a command
# over a range.

#     $Id: foreach_cell.tcl,v 1.1 1994/08/26 16:35:45 johnsonm Exp $

#     Copyright (c) 1992 General Electric.  All rights reserved.

#     Permission to use, copy, modify, and distribute this software and
#     its documentation for any purpose and without fee is hereby
#     granted, provided that the above copyright notice appear in all
#     copies and that both that copyright notice and this permission
#     notice appear in supporting documentation, and that the name of
#     General Electric not be used in advertising or publicity
#     pertaining to distribution of the software without specific,
#     written prior permission.  General Electric makes no
#     representations about the suitability of this software for any
#     purpose.  It is provided "as is" without express or implied
#     warranty.

#     This work was supported by the DARPA Initiative in Concurrent
#     Engineering (DICE) through DARPA Contract MDA972-88-C-0047.

#     $Log: foreach_cell.tcl,v $
# Revision 1.1  1994/08/26  16:35:45  johnsonm
# Initial revision
#

proc foreach_cell {varname range command} {
	upvar 1 $varname var
	set r [xess decode_range $range]
	set cell1 [lindex $r 0]
	set cell2 [lindex $r 1]
	set row1 [lindex $cell1 0]
	set col1 [lindex $cell1 1]
	set row2 [lindex $cell2 0]
	set col2 [lindex $cell2 1]
	for {set row $row1} {$row <= $row2} {incr row} {
		for {set col $col1} {$col <= $col2} {incr col} {
			set var [xess encode_cell $row $col 00]
			uplevel 1 $command
		}
	}
	unset var
}
