proc parseArgs {argc argv} {
  global width height
  for {set i 0} {$i < $argc} {incr i} {
    set arg [lindex $argv $i]
    case $arg {
      -helpme  printHelp
      -v {
        global version
        echo "tksquare, version $version. By Fabrizio Pivari"
        exit
      }
      -side {
        incr i
        set width [lindex $argv $i]
        set height [lindex $argv $i]
      }
      default	printHelp
    }
  }
  if {$width > [maxwidth] || $width < [minwidth]} {printHelp}
}

proc printHelp {} {
  echo {tsquare -helpme -v -side [side]}
  echo side must be less than [maxwidth] and more than [minwidth]
  exit
}

parseArgs $argc $argv

wm withdraw .
toplevel .w
wm title .w Square
if {[file exists $sourceDir/square.xbm] == 1} {
   wm iconbitmap .w @$sourceDir/square.xbm
   }
makeBoard .w $width $height
