# global stuff
umask 002
set daynames {Sunday Monday Tuesday Wednesday Thursday Friday Saturday}
set people {}
set holi_list ""
set mc_height 60
set armed_person ""
set armed_person_change 0
set hostname [exec /bin/hostname]
#
set log_file "${work_dir}/absence.log"
set holiday_file "${work_dir}/.feiertage";	# dates & desc of holidays
set messe_file "${work_dir}/.messen";		# computer show dates
if {$argv0 == "abwesenheit"} {
  set color_file "$env(HOME)/.abwesenheit_colors";	# personal color file
} else {
  set color_file "$env(HOME)/.absence_colors";	# personal color file
}
set username [exec whoami]
set cell_binding {}
set data_file_extension "WB_DATA"
set lock_file_extension "WB_LOCK"
set rev_cell_binding() ""
set num_halfcells 0
set ignore_request 0
set dialog_button -1
set addchange_tablist {}
set resconf_tablist {}
set add_change() ""
set add_change_button ""
set resconf_button ""
set resconf_user ""
set change_person_selection ""
set person_info() ""
set person_mtime() ""
set person_reservations() ""
set virgin_biglist {}
set select_start_half 0
set alarm_minutes 2
set scan_interval 15;	# seconds
set prop_font	"-Adobe-times-medium-r-normal--*-180*"

# initial sanity check
if {([catch {file stat $work_dir sc_tmp}]) || ($sc_tmp(type) != "directory")} {
  puts "$work_dir doesn't exist or isn't a directory"
  exit
}
#(31,28,31,30,31,30,31,31,30,31,30,31);
proc MonthDays {month year} {
  set m_l "31 28 31 30 31 30 31 31 30 31 30 31"
  if {($month == 2) && ([expr $year / 4] == [expr ${year}.0 / 4.0])} {
    return 29
  }
  return [lindex $m_l [expr $month - 1]]
}
# now the names...
set month_name(1) January
set month_name(2) February
set month_name(3) March
set month_name(4) April
set month_name(5) May
set month_name(6) June
set month_name(7) July
set month_name(8) August
set month_name(9) September
set month_name(10) October
set month_name(11) November
set month_name(12) December
#
set month_names {spacer January February March April May June July August September October November December}


proc SetDateVars {} {
  global week_num weekday_num monthday_num month_num year_num today
  global month_names
  set week_num [string trimleft [fmtclock [getclock] %W] 0]
  set weekday_num [fmtclock [getclock] %w]
  set monthday_num [string trimleft [fmtclock [getclock] %d] 0]
  set month_num [string trimleft [fmtclock [getclock] %m] 0]
  set year_num [fmtclock [getclock] %y]
  set today "${monthday_num}-[string toupper [string range\
    [lindex $month_names $month_num] 0 2]]-${year_num}"
}

SetDateVars

proc Truncate {foo} {
  regsub {\..*} "$foo" {} tmp
  return "$tmp"
}

proc GetRealName {username} {
  global hostname
  if {$username == "jmh"} {
    return "Holzer"
  }
  if {$hostname == "doofus"} {
    set pwline [exec grep $username /etc/passwd]
  } else {
    set pwline [exec ypcat passwd | grep $username]
  }
  set gecos [lindex [split $pwline {:}] 4]
  set fullname [lindex [split $gecos {,}] 0]
  return [lindex $fullname [expr [llength $fullname] - 1]]
}

proc RequestLock {person} {
  global work_dir username lock_file_extension
  set lock_name "${work_dir}/${person}.$lock_file_extension"
  if {[file exist $lock_name]} {
    set fh [open $lock_name]

    set fink [gets $fh]
    close $fh
    Dialog .dialog {Person Locked} \
      "Sorry, \"$fink\" is currently reserving person $person. Try again later."\
      error -1 OK
    return 0
  } else {
    set fh [open $lock_name "w" 0640]
    puts $fh "$username"
    close $fh
    return 1
  }
}

proc Mail {user message} {
  set fileid [open "|mail -s \"your reservation was deleted\" $user" w]
  puts $fileid "$message"
  close $fileid
}

proc ZeroPersonBits {person start end} {
  global biglist num_halfcells
  for {set i $start} {($i <= $end)&&($i < $num_halfcells)} {incr i} {
    set biglist($person) [lreplace $biglist($person) $i $i 0]
  }
}

proc Convert {code halfcell} {
  global cell_binding weekday_num daynames month_names daynames year_num
#  puts "Convert: halfcell=$halfcell"
  set cell [expr $halfcell / 2]
  set binding [lindex $cell_binding $cell]
  set half [expr "[odd ${halfcell}] ? {afternoon} : {morning}"]
  set halfgerm [expr "[odd ${halfcell}] ? {Nachmittag} : {Vormittag}"]
  set dayofmonth [lindex $binding 0]
  set monthnum [lindex $binding 1]
  set year [lindex $binding 2]
  set month [lindex $month_names $monthnum]
  set vmsmonth [string toupper [string range $month 0 2]]
  set dayofweeknum [expr ($weekday_num + $dayofmonth) % 7]
  set dayname [lindex $daynames $dayofweeknum]
  switch $code {
    monthnum     {set answer $monthnum}
    month        {set answer $month}
    dayofmonth   {set answer $dayofmonth}
    halfnum      {set answer [odd $halfcell]}
    halfword     {set answer $half}
    dayofweeknum {set answer $dayofweeknum}
    dayname      {set answer $dayname}
    nicedate     {set answer "${month} $dayofmonth, $half"}
    secdate      {set answer [format "%d/%d/%d %s" $dayofmonth $monthnum \
                  $year_num $halfgerm]}
    file_format  {set answer [format "%d/%d/%d/%d" $dayofmonth $monthnum \
                  $year_num [odd $halfcell]]}
    vmsdate	 {set answer "${dayofmonth}-${vmsmonth}-${year}"}
  }
  return $answer
}

proc ReserveBits {person start end cust sonst fone} {
  global num_cells person_reservations biglist num_halfcells
  set real_end [expr "{$end} > {$num_halfcells} ? {$num_cells} : {$end}"]
  set tag [GetFreeTag $person]
  set count $start
  while {$count <= $real_end} {
    set biglist($person) [lreplace $biglist($person) $count $count $tag]
    incr count
  }
  lappend person_reservations($person) "{$tag} {$start} {$end} {$cust}\
    {$sonst} {$fone}"
}

proc GetFreeTag {person} {
  global person_reservations
  set alltags {}
  if {[catch {set person_reservations($person)}]} {
    return 1
  }
  foreach ent $person_reservations($person) {
    lappend alltags [lindex $ent 0]
  }
  set found 0
  set trytag 1
  while {!$found} {
    if {[lsearch $alltags $trytag] < 0} {
      set found 1
      break
    }
    incr trytag
  }
  return $trytag
}

proc CellBind {} {
  global cell_binding month_num monthday_num year_num
  global num_cells num_halfcells rev_cell_binding holiday_list
  global holidays messen messe_list
  #puts "DBG: CellBind"
  set num_halfcells [expr $num_cells * 2]
  set count 0
  set cell_binding ""
  set holiday_list ""
  set messe_list ""
  set year $year_num
  set curr_month $month_num
  set curr_day_of_month $monthday_num
  set tmp [expr $num_cells * 4]
  #puts "DBG: num_cells=$num_cells, count=$count, tmp=$tmp"
  while {$count < $tmp} {
    lappend cell_binding "$curr_day_of_month $curr_month $year"
    if {[IsHoliday "$curr_day_of_month $curr_month $year"]} {
      lappend holiday_list "_${count}_"
    } elseif {[IsMesse "$curr_day_of_month $curr_month $year"]} {
      lappend messe_list "_${count}_"
    }
    set rev_cell_binding(${curr_day_of_month}_${curr_month}_$year) $count
    incr curr_day_of_month
    if {$curr_day_of_month > [MonthDays $curr_month $year]} {
      if {$curr_month == 12} {
        set curr_month 1
        incr year
      } else {
        incr curr_month
      }
      set curr_day_of_month 1
    }
    incr count
  }
}

proc FindPeople {} {
  global work_dir data_file_extension people person_mtime
  set people ""
  cd $work_dir
  set list {}
  catch {set list [glob *.$data_file_extension]}
  foreach tmp $list {
    regsub {\..*$} $tmp {} person
    lappend people $person
    file stat $tmp stat_var
    set person_mtime($person) $stat_var(mtime)
  }
  set people [lsort $people]
}

proc CheckDate {} {
  global weekday_num
  set tmp [fmtclock [convertclock now] %w]
  if {$tmp != $weekday_num} {
    SetDateVars
    Init
    return 1
  }
  return 0
}
proc UpdateIfChanged {person} {
  global people person_mtime data_file_extension work_dir
  cd $work_dir
  file stat "${person}.$data_file_extension" stat_info
  if {[catch {set person_mtime($person)}]} {set person_mtime($person) 0}
  if {$stat_info(mtime) != $person_mtime($person)} {
    set person_mtime($person) $stat_info(mtime)
    ReadPersonFile $person
    UpdatePersonList $person
    UpdatePersonDisplay $person
  }
}

proc ScanForChanges {} {
  global people person_mtime data_file_extension work_dir scan_interval
  global weekday_num armed_person quickie_var cell_binding
  if {$armed_person != ""} {
    after [expr $scan_interval * 1000] ScanForChanges
    return
  }
  if {[catch {cd $work_dir}]} {
    puts "$work_dir not available"
    after [expr $scan_interval * 1000] ScanForChanges
    return
  }
  set tmp {}
  set complete_init 0
  catch {set tmp [glob *.$data_file_extension]}
  regsub -all {\..[^ ]*} $tmp {} list
  if {([lsort $list] == [lsort $people])&&([exec date +%w] == $weekday_num)} {
    foreach person $people {
      UpdateIfChanged $person
    }
  } else {
#    puts "Initing again..."
    Quickie {Have Patience...} 2
    SetDateVars
    Init
    set quickie_var foo
  }
  after [expr $scan_interval * 1000] ScanForChanges
}

proc ZeroPersonLists {} {
  global people virgin_biglist biglist
  foreach person $people {
    set biglist($person) "$virgin_biglist"
  }
}

proc odd {int} {
  if {[expr $int % 2]} {
    return 1
  }
  return 0
}

proc ChangePerson {} {
  global people change_person_selection person_info add_change armed_person
  global armed_person_change
  if {$armed_person == ""} {
    Dialog .dialog {Sorry, pal} "You have not requested a lock for any person.\
      To do this select the person by pressing MB1 on the button for the \
      person to the left." {error} -1 OK
    return
  }

#  puts "person=$armed_person"
  set list $person_info($armed_person)
  set add_change(person) [lindex $list 0]
  set add_change(phone) [lindex $list 1]
  set add_change(address) [lindex $list 2]
  if {[AddChangePerson change] > 0} {
    set person_info($armed_person) "{$add_change(person)} {$add_change(phone)}\
      {$add_change(address)}"
    set armed_person_change 1
    LogIt "changed Stammdaten for $armed_person"
  }
}

proc ReadAllPeople {} {
  global people
  foreach person $people {
    ReadPersonFile $person
  }
}

proc ReadPersonFile {person} {
  global person_reservations person_info data_file_extension
  set phone ""
  set address ""
  set person_reservations($person) ""
  set filename "${person}.${data_file_extension}"
  set file_id [open $filename "r"]
  while {[gets $file_id line] != -1} {
    set label [lindex $line 0]
    set contents [lindex $line 1]
    switch $label {
      person   {
        if {$person != $contents} {
          puts "person in data file doesn't match filename for person $person"
          puts "bailing..."
          exit
        }
      }
      phone {set phone $contents}
      address  {set address $contents}
      res      {
        set tmp "[ConvertFromFileRes $contents]"
        if {$tmp != ""} {
          lappend person_reservations($person) "$tmp"
        }
      }
      default  {puts "junk in data file: $contents"}
    }
  }
  close $file_id
  set person_info($person) "{$person} {$phone} {$address}"
}

proc ConvertFromFileRes {list} {
  set tag [lindex $list 0]
  set start_date [lindex $list 1]
  set end_date [lindex $list 2]
#  set reserver [lindex $list 3]
  set cust [lindex $list 3]
  set sonst [lindex $list 4]
  set fone [lindex $list 5]
  # DEBUG
  # puts "ConvertFromFileRes: fone=$fone"
  set start_halfcell [ConvertFromFileDate $start_date]
  set end_halfcell [ConvertFromFileDate $end_date]
  if {($end_halfcell ==  -1)||($start_halfcell == -1)||($end_halfcell == {})} {
    return {}
  }
  if {$start_halfcell == ""} {
    set start_halfcell 0
  }
  return "{$tag} {$start_halfcell} {$end_halfcell} {$cust} {$sonst} {$fone}"
}

proc ConvertFromFileDate {file_date} {
#  puts "ConvertFromFileDate: $file_date"
  global month_num year_num monthday_num cell_binding num_cells year_num
  global rev_cell_binding log_file
  if {[scan $file_date "%d/%d/%d/%d" day month year half] != 4} {
    puts "error trying to convert $file_date to internal format"
    LogErr "ConvertFromFileDate: error converting $file_date to internal format"
    return {-1}
  }
  if {$year > 1900} {set year [expr $year - 1900]}
  if {$year < $year_num} {return {}}
  if {($year == $year_num)&&(($month < $month_num) ||
      (($month == $month_num) && ($day < $monthday_num)))} {
    return {}
  }
  if {[catch {set cell [set rev_cell_binding(${day}_${month}_$year)]}]} {
    LogErr "ConvertFromFileDate: file_date=$file_date (rev_cell_binding)"
    puts "Error, see $log_file"
    return {-1}
  } else {
    return [expr ($cell * 2) + $half]
  }
}

proc LogErr {message} {
  global username today log_file
  set fileid [open $log_file a]
  puts $fileid "ERROR: \[$today\] $username $message"
  close $fileid
}
  

proc ConvertFromFileDateOrig {file_date} {
  global month_num year_num monthday_num cell_binding num_cells year_num
  if {[scan $file_date "%d/%d/%d/%d" day month year half] != 4} {
    puts "error trying to convert $file_date to internal format"
  }
  if {$year < $year_num} {return {}}
  if {($year == $year_num)&&(($month < $month_num) ||
      (($month == $month_num) && ($day < $monthday_num)))} {
    return {}
  }
  set count 0
  while {$count < $num_cells * 4} {
    set tmp [lindex $cell_binding $count]
    set d [lindex $tmp 0]
    set m [lindex $tmp 1]
    set y [lindex $tmp 2]
    if {($m == $month)&&($d == $day)&&($year == $y)} {
      return [expr ($count * 2) + $half]
    }
    incr count
  }
}

proc WritePersonFile {person chgrp} {
  global person_info person_reservations data_file_extension 
#  puts "-- WritePersonFile --"
  set filename "${person}.${data_file_extension}"
  set file_id [open $filename w 0660]
  puts $file_id "person {$person}"
  puts $file_id "phone {[lindex $person_info($person) 1]}"
  puts $file_id "address {[lindex $person_info($person) 2]}"
  catch {
    foreach ent $person_reservations($person) {
      puts $file_id "res {[ConvertToFileRes $ent]}"
    }
  }
  close $file_id
  if {$chgrp == "chgrp"} {chgrp staff $filename}
}

proc ConvertToFileRes {list} {
#  puts "ConvertToFileRes: list=$list"
  set tag [lindex $list 0]
  set start_date [Convert file_format [lindex $list 1]]
  set end_date   [Convert file_format [lindex $list 2]]
#  set reserver   [lindex $list 3]
  set cust       [lindex $list 3]
  set sonst      [lindex $list 4]
  set fone      [lindex $list 5]
  return "{$tag} {$start_date} {$end_date} {$cust} {$sonst} {$fone}"
}

proc UpdateLists {} {
  global people
  foreach person $people {
    UpdatePersonList $person
  }
}

proc UpdatePersonList {person} {
  global person_reservations biglist virgin_biglist num_halfcells
  set biglist($person) "$virgin_biglist"
  foreach entry $person_reservations($person) {
    set tag [lindex $entry 0]
    set start [lindex $entry 1]
    set end [lindex $entry 2]
    set count $start
    while {($count < $num_halfcells)&&($count <= $end)} {
      set biglist($person) [lreplace $biglist($person) $count $count $tag]
      incr count
    }
  }
}
  

  
proc InitVirginBiglist {} {
  global virgin_biglist num_cells
  set count 0
  while {$count < [expr $num_cells * 2]} {
    lappend virgin_biglist 0
    incr count
  }
}

proc LogIt {message} {
  global username today log_file
#  puts " -- LogIt --"
  set fileid [open $log_file a]
  puts $fileid "\[$today\] $username $message"
  close $fileid
}
proc LoadHolidays {} {
  global holidays holiday_file
  set holidays ""
  if {[file exist $holiday_file]} {
    set fid [open $holiday_file r]
    while {[gets $fid line] != -1} {
      if {![regexp {^#} $line]} {
        set type [lindex $line 0]
        set date [lindex $line 1]
        if {[scan $date "%d/%d/%d" day month year] == 3} {
          set desc [lindex $line 2]
          lappend holidays "$day $month $year {$desc} $type"
        }
      }
    }
    close $fid
  }
}
proc LoadMessen {} {
  global messen messe_file
  set messen ""
  if {[file exist $messe_file]} {
    set fid [open $messe_file r]
    while {[gets $fid line] != -1} {
      if {(![regexp {^#} $line])&&
          ([scan $line "%d/%d/%d %s\n" day month year desc] == 4)} {
        set desc [lindex $line 1]
        lappend messen "$day $month $year {$desc}"
        # debug
	# puts "LoadMessen: got $day $month $year {$desc}"
      }
    }
    close $fid
  }
}

proc GetHoliday {cell} {
  global holidays cell_binding
  set binding [lindex $cell_binding $cell]
  foreach holiday $holidays {
    if {([lindex $binding 0] == [lindex $holiday 0])&&\
        ([lindex $binding 1] == [lindex $holiday 1])&&\
        ([lindex $binding 2] == [lindex $holiday 2])} {
        return "{[lindex $holiday 3]} {[lindex $holiday 4]}"
    }
  }
  puts "ERROR: GetHoliday: cell=$cell, holidays=$holidays, holiday_list=$holiday_list"
}

proc GetMesse {cell} {
  global messen cell_binding
  set binding [lindex $cell_binding $cell]
  foreach messe $messen {
    if {([lindex $binding 0] == [lindex $messe 0])&&\
        ([lindex $binding 1] == [lindex $messe 1])&&\
        ([lindex $binding 2] == [lindex $messe 2])} {
        return [lindex $messe 3]
    }
  }
  puts "ERROR: GetMesse: cell=$cell, messen=$messen, messe_list=$messe_list"
}

proc IsHoliday {cell} {
  global cell_binding holidays holiday_list
  foreach holiday $holidays {
#    puts "IsHoliday: cell=$cell, holiday=$holiday"
#    puts "c0=\[[lindex $cell 0]\], h0=\[[lindex $holiday 0]\]"
#    puts "c1=\[[lindex $cell 1]\], h1=\[[lindex $holiday 1]\]"
#    puts "c2=\[[lindex $cell 2]\], h2=\[[lindex $holiday 2]\]"
    if {([lindex $cell 0] == [lindex $holiday 0])&&\
        ([lindex $cell 1] == [lindex $holiday 1])&&\
        ([lindex $cell 2] == [lindex $holiday 2])} {
#      lappend holiday_list "_${num}_"
      return 1
    }
  }
  return 0
}
proc IsMesse {cell} {
  global cell_binding messen messe_list
  foreach messe $messen {
#    puts "IsMesse: cell=$cell, messe=$messe"
#    puts "c0=\[[lindex $cell 0]\], h0=\[[lindex $messe 0]\]"
#    puts "c1=\[[lindex $cell 1]\], h1=\[[lindex $messe 1]\]"
#    puts "c2=\[[lindex $cell 2]\], h2=\[[lindex $messe 2]\]"
    if {([lindex $cell 0] == [lindex $messe 0])&&\
        ([lindex $cell 1] == [lindex $messe 1])&&\
        ([lindex $cell 2] == [lindex $messe 2])} {
#      lappend messe_list "_${num}_"
      return 1
    }
  }
  return 0
}

proc NotifyQuery {op person start_hc end_hc} {
  global weekday_num dialog_button resconf_cust
  if {[expr $start_hc/2 < (6 - $weekday_num)]} {
    Dialog .dialog {Send Mail?} "Send mail to Nadja & Marion? (Instead of\
      going to their office and entering into timesheet)"\
      question -1 Yes No
    if {$dialog_button == 0} {
      set my_days {Montag Dienstag Mittwoch Donnerstag Freitag}
      set real_user [GetRealName $person]
      set start_secdate [Convert secdate $start_hc]
      set end_secdate [Convert secdate $end_hc]
      set start_half    [expr "[odd $start_hc] ? {Nachmittag} : {Vormittag}"]
      set end_half      [expr "[odd $end_hc] ? {Nachmittag} : {Vormittag}"]
      set start_str "[lindex $my_days [expr ($start_hc / 2) + $weekday_num - 1]\
                     ] $start_half [lindex $start_secdate 0]"
      set end_str   "$end_half [lindex $end_secdate 0]"
      if {$op == "confirm"} {
        set subject "$real_user Abwesenheit"
        set line1 "$real_user wird von $start_str bis $end_str abwesend sein"
        set line2 "Firma/Grund: $resconf_cust"
      } else {
        set line1 "$real_user hat Termin/Abwesenheit GELOESCHT! (nicht mehr gueltig)"
        set line2 "Firma/Grund WAR: $resconf_cust"
        set subject "$real_user: Abwesenheit Eintrag STORNIERT"
      }
      set fid [open "|mail -s \"$subject\" abwesenheit" w]
      puts $fid "$line1"
      puts $fid "$line2"
      close $fid
    }
  }
}
