#ifndef _TreePoint_h_
#define _TreePoint_h_

/*
 * TreePoint.h - definition of class TreePoint
 *
 * -----------------------------------------------------------------------------
 * Copyright 1994 Allan Brighton.
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies.  
 * Allan Brighton make no representations about the suitability of this 
 * software for any purpose. It is provided "as is" without express or 
 * implied warranty.
 * -----------------------------------------------------------------------------
 */

#include <iostream.h>
#include "config.h"

class _EXPORT TreePoint {
public:
    short x, y;
    
    TreePoint() : x(0), y(0) {}
    TreePoint(int x_, int y_) : x(x_), y(y_) {}
    
    TreePoint operator+(const TreePoint &p) const { return TreePoint(x+p.x, y+p.y); }
    TreePoint operator-(const TreePoint &p) const { return TreePoint(x-p.x, y-p.y); }
    int operator==(const TreePoint &p) const { return (x==p.x && y==p.y); }
    int operator!=(const TreePoint &p) const { return (x!=p.x || y!=p.y); }
};

inline ostream& operator<<(ostream& os, const TreePoint& p) { os << p.x << " " << p.y; return os;}

#endif /* _TreePoint_h_ */
