/* tinfo.c
**************************************************************************** 
expecTerm version 1.0 beta
Mark Weissman
Christopher Matheus
Copyright 1992 by GTE Laboratories Incorporated.

Portions of this work are in the public domain.  Permission to use,
copy, modify, and distribute this software and its documentation for
any purpose and without fee is hereby granted, provided that the above
copyright notice appear in all copies and that both the copyright
notice and warranty disclaimer appear in supporting documentation, and
that the names of GTE Laboratories or any of their entities not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

GTE disclaims all warranties with regard to this software, including
all implied warranties of merchantability and fitness for a particular
purpose, even if GTE Laboratories Incorporated knows about the
purpose.  In no event shall GTE be liable for any special, indirect or
consequential damages or any damages whatsoever resulting from loss of
use, data or profits, whether in an action of contract, negligence or
other tortuous action, arising out of or in connection with the use or
performance of this software.

This code is based on and may include parts of Don Libes' expect code:
  expect written by: Don Libes, NIST, 2/6/90
  Design and implementation of expect was paid for by U.S. tax
  dollars.  Therefore it is public domain.  However, the author and NIST
  would appreciate credit if this program or parts of it are used.
*****************************************************************************

Written by: Mark Weissman 9/1992
*/

/* #define DEBUG_SMARTHASH 1 */
/* #define DEBUG_TERMFUNCS 1 */
Break() {}
#include "compat.h"
#include "win.h"
#include "termfuncs.h"
extern char Nextch();
extern double NextchInputWait;
extern long Arg[], Argno, Vars[];

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

#define CLOBBER_OLD_VAL 0

#define TBOOL   "boolean"
#define TNUM    "number"
#define TSTRING "string"
#define TINFO   "infoString"

typedef struct Entry_Struct {
  char *terminfo, *termcap, *name, *access, *type, *doc;
  void (*func)();
} Entry;
static Entry *Entries = NULL;
#define EntryToIndex(ENTRY) (ENTRY - Entries)
#define ENTRY(INDEX) (Entries + INDEX)
#define EntryINC 256
static long EntryCurr=1, EntryMax=0;
TermTab *CurrTerm;

typedef struct Nodetruct {
  char first, last;
  short int entry;
  union {
    short int *children;
    short int child;
  } u;
} Node;
static Node *Nodes = NULL;
#define NODE(INDEX) (Nodes + INDEX)
#define NodeToIndex(NODE) (NODE - Nodes)
#define NodeINC 256
static int NodeMax = 0, NodeCurr = 1;

static short int EscSeqTab=0;
char *ExpectLogDir, *ExpectDir;

char *FixEscapes(buf, from) 
char *buf, *from;
{
  char *to = buf;
  if (!from) return("*UNKNOWN ESCAPE SEQUENCE*");
  while (*from) {
    if (*from < ' ') { *to++ = '^'; *to++ = *from++ + 'A' - ''; }
    else *to++ = *from++;
  }
  *to='\0';
  return(buf);
}


char *CleanKey(s)
char *s;
{
  static char pbuf[256], *p;
  int tot;
  p=pbuf;
  for(p=pbuf; *s; ++s) {
    switch (*s) {
    case '$': while(*s && (*s++ != '>')); *p++ = *s; break;
    case '{': for(tot=0; *s && (*s != '}'); tot = (tot*10)+(*s - '0'), ++s); *p++ = tot; break;
    case '\'':
      { switch(*(++s)) {
	case '\\':
	  switch(*(++s)) {
	  case 'n': *p = '\n'; break;
	  case 'l': *p = ''; break;
	  case 'r': *p = '\r'; break;
	  case 't': *p = '\t'; break;
	  case 'b': *p = '\b'; break;
	  case 'f': *p = '\f'; break;
	  case 's': *p = ' '; break;
	  case '0': *p = (8*(*(++s)-'0') + (*(++s)-'0')); break;
	  case '1': *p = (8*(*(++s)-'0') + (*(++s)-'0')) + 64; break;
	    /* The following case strips off 8th bit!!! */
	  case '2': *p = (8*(*(++s)-'0') + (*(++s)-'0')); break;
	  case 'e': 
	  case 'E': *p = ''; break;
	  }
	  break;
	case '^': 
	  ++s;
	  *p = *s - ((*s>='a'&&*s<'z')?'`':'@'); break;
	default:    *p = *s; break;
	}
	++p; ++s;
      } break; /* case '\'' */
    default: *p++ = *s; break;
    }
  }
  *p = '\0';
  return(pbuf);
}

long ParseConditional(s,tbuf,ebuf)
char *s, *tbuf, *ebuf;
{
  char *s0 = s, *os = s;
/*  char ntbuf[256], nebuf[256]; */
  char *ntbuf= NULL, *nebuf = NULL;
  int result = 1;
  static char *indent = "\t\t\t\t\t\t\t\t", *i= NULL;
  if (!i) i=indent+8;

  if (*s && ('%'==*s) && ('?'==*(s+1))) {
    --i;
    os = s+2;
    if (tbuf) *tbuf = '\0'; 
    if (ebuf) *ebuf = '\0';
    for(s=os; !(('%'==*s) && ('t'==*(s+1))); s += ParseConditional(s,ntbuf,nebuf));
    if (tbuf) { strncpy(tbuf,os,(s-os)); tbuf[s-os] = '\0'; }
    os = s+2;
    for(s=os; !(('%'==*s) && (*(s+1)=='e' || *(s+1)==';')); s += ParseConditional(s,ntbuf,nebuf));
    if (tbuf) { int l=strlen(tbuf); strncpy(tbuf+l,os,(s-os)); tbuf[s-os+l] = '\0'; }
    if (('%'==*s) && ('e'== *(s+1))) {
      os = s+2;
      for(s=os; !(('%'==*s) && (*(s+1)==';')); s += ParseConditional(s,ntbuf,nebuf));
      if (ebuf) { strncpy(ebuf,os,(s-os)); ebuf[s-os] = '\0'; }
    }
    s+=2;
    if (ebuf) strcat(ebuf,s);
    if (tbuf) strcat(tbuf,s);
    result = (s-s0);
    ++i;
/*    fprintf(stderr, "%sS: \"%s\", ebuf: \"%s\", tbuf: \"%s\"\n", i, s0, ebuf, tbuf); fflush(stderr); */
  }
  return(result);
}

Entry *NewEntry(stream, terminfo, termcap, type, access, func, name, doc)
FILE *stream;
char *terminfo, *termcap, *name, *access, *doc, *type;
void (*func)();
{
  Entry *new;
  if (!func && *type == *TSTRING) return(NULL);
  if (EntryCurr >= EntryMax) {
    Entry *old = Entries;
    int n;
    Entries = (Entry *)calloc(EntryMax+EntryINC, sizeof(Entry));
    for(n=0; n < EntryMax; ++n) {
      Entries[n].terminfo   = old[n].terminfo;
      Entries[n].termcap    = old[n].termcap;
      Entries[n].name       = old[n].name;
      Entries[n].access     = old[n].access;
      Entries[n].func       = old[n].func;
      Entries[n].type       = old[n].type;
      Entries[n].doc	    = old[n].doc;
    }
    if (old) free(old);
    EntryMax += EntryINC;
  }
  new = (Entries + EntryCurr++);
  new->terminfo = terminfo;
  new->termcap = termcap;
  new->doc = doc;
  new->name = name;
  new->func = func;
  new->type = type;
  return(new);
}
Entry *TerminfoToEntry(name)
char *name;
{
  int i;
  for(i=1; i<EntryCurr; ++i) if (!strcmp(name,ENTRY(i)->terminfo)) return(ENTRY(i));
  return(NULL);
}
Entry *FuncToEntry(func)
FPTR func;
{
  int i;
  for(i=1; i<EntryCurr; ++i) if (func==ENTRY(i)->func) return(ENTRY(i));
  return(NULL);
}

short int NewNode()
{
  if (NodeCurr >= NodeMax) {
    Node *old = Nodes;
    int n;
    Nodes = (Node *)calloc(NodeMax+NodeINC, sizeof(Node));
    for(n=0; n < NodeMax; ++n) {
      Nodes[n].first   = old[n].first;
      Nodes[n].last    = old[n].last;
      Nodes[n].entry   = old[n].entry;
      Nodes[n].u.children = old[n].u.children;
    }
    if (old) free(old);
    NodeMax += NodeINC;
  }
  NODE(NodeCurr)->first = -1;
  return(NodeCurr++);
}

short int Child(node,i)
short int node;
char i;
{
  Node *n = NODE(node);
  short int first = n->first;
  short int last  = n->last;
  short int *children = n->u.children;
  return (!children
	  ? 0
	  : ((first == i && last == i)
	     ? n->u.child
	     : ((first <= i && last >= i)
		? ((children[i-first] > 0)
		   ? children[i-first]
		   : 0)
		: 0)
	     )
	  );
}

short int GetChildNode(node, s)
short int node;
char *s;
{
  short int i;
  short int child;
  
  if (!node) return(NULL);
  child = Child(node, *s);
  if (child) return(child);
  child = NewNode();
  if (!NODE(node)->u.children) {
    NODE(node)->first = NODE(node)->last = *s;
    NODE(node)->u.child = child;
  }
  else if (*s < NODE(node)->first || *s > NODE(node)->last) {
    short int *children;
    int newstart  = (*s < NODE(node)->first) ? *s : NODE(node)->first;
    int newend    = (*s > NODE(node)->last)  ? *s : NODE(node)->last;
    int childrange  = NODE(node)->last - NODE(node)->first;
    if (NODE(node)->first == NODE(node)->last)
      *(children = (short int *)calloc(1, sizeof(short int))) = NODE(node)->u.child;
    else 
      children = NODE(node)->u.children;
    NODE(node)->u.children = (short int *)calloc((newend - newstart + 1), sizeof(short int));
    for (i=0; i<=childrange; ++i) NODE(node)->u.children[i + NODE(node)->first - newstart] = children[i];
    free(children);
    NODE(node)->last  = newend;
    NODE(node)->first = newstart;
    NODE(node)->u.children[*s - NODE(node)->first] = child;
  } 
  else NODE(node)->u.children[*s - NODE(node)->first] = child;
  return(child);
}

char *SetHash(stream, node, s, entry)
FILE *stream;
short int node;
char *s;
Entry *entry;
{
  static long depth = 0;
  static char seq[BUFSIZ];
  extern char *Strdup();

  if ((*s == '%') && (*(s+1)=='?')) { 
    char tbuf[256], ebuf[256], *r1, *r2;
    ParseConditional(s,tbuf,ebuf);
    r1 = SetHash(stream, node, tbuf, entry);
    r2 = SetHash(stream, node, ebuf, entry);
    return(r1 ? r1 : r2);
  }
  if (depth == 0) {
    if ((*s >= ' ') && (*s <= '~')) return(NULL);
    s = CleanKey(s);
  } else if (depth == 256) { fatal("Too Deep in SetHash"); exit(-1); }
  seq[depth] = *s; seq[depth+1] = '\0';
  if (*s) {
    short int child = GetChildNode(node, s);
    char *r;
    ++depth; r=SetHash(stream, child, s+1, entry); --depth;
    return(r);
  }
  if (stream && NODE(node)->entry && Entries[NODE(node)->entry].func != entry->func) {
    Entry *oentry = ENTRY(NODE(node)->entry);
    fprintf(stream,",\n# Escape Sequence Clash: (Keep %s)",(CLOBBER_OLD_VAL?"New":"Old"));
    fprintf(stream,",\n#   Old Cap: %-8s, Function: %s, Sequence: \"%s\"",
	    oentry->terminfo, oentry->name, FixEscapes(Buffer,oentry->access));
    fprintf(stream,",\n#   New Cap: %-8s, Function: %s, Sequence: \"%s\"",
	    entry->terminfo,  entry->name, FixEscapes(Buffer,seq));
    fflush(stream);
  }
  if (!NODE(node)->entry || CLOBBER_OLD_VAL) {
    char buf[BUFSIZ];
    NODE(node)->entry = EntryToIndex(entry);
    if (entry->access) free(entry->access);
    entry->access = Strdup(seq);
    if (stream) {
      fprintf(stream,",\n# %-8s\n	%-32s=%-s", entry->name, entry->terminfo, FixEscapes(buf,seq));
      fflush(stream);
    }
    return(entry->terminfo);
  }
  else return(NULL);
}

ShowTermCapabilities(stream, type)
FILE *stream;
char *type;
{
  int e = 0;
  for(e=1; stream && e < EntryCurr; ++e) {
    Entry *entry = &Entries[e];
    if (*entry->type == *type) {
      if (*entry->type == *TSTRING) {
	fprintf(stream,",\n# %s\n# %-8s: %-s", entry->doc, entry->terminfo, FixEscapes(Buffer,entry->access));
	fflush(stream);
      }
      else if (*entry->type == *TINFO) {
	switch ((int)entry->access) {
	case -1: case 0:
	  fprintf(stream,",\n# INFO: %-8s\n#	%-32s=", entry->doc, entry->terminfo);
	  break;
	default:
	  fprintf(stream,",\n# INFO: %-8s\n	%-32s=%-s", entry->doc, entry->terminfo, FixEscapes(Buffer,entry->access));
	  break;
	}
	fflush(stream);
      }
      else if (*entry->type == *TNUM) {
	fprintf(stream,  ",\n# %s\n%s#%-d", entry->doc, entry->terminfo, entry->access);
	fflush(stream);
      }
      else if (*entry->type == *TBOOL) {
	switch ((int)entry->access) {
	case 0: 
	  fprintf(stream,",\n# %s\n%s@", entry->doc, entry->terminfo);
	  break;
	case 1: 
	  fprintf(stream,",\n# %s\n%s",  entry->doc, entry->terminfo);
	  break;
	default:
	  fprintf(stream,",\n# %s\n# %s = %d", entry->doc, entry->terminfo, entry->access);
	  break;
	}
	fflush(stream);
      }
      else {
	sprintf(Buffer, "Unknown t->type: %s\n",entry->type);
	fatal(Buffer);
	exit(-1);
      }
    }
  }
}

DumpHashTab(stream,node) 
FILE *stream;
short int node;
{
  static long depth = 0;
  static char seq[BUFSIZ];
  char buf[BUFSIZ];
  char c;


  if (!stream || !NODE(node)->u.children) return;
  if (!depth && stream) fprintf(stream,",\n# Dumping Sequence Table");

  for (c = NODE(node)->first; c <= NODE(node)->last; ++c) {
    int child = Child(node,c);
    if (child) {
      seq[depth] = c;
      seq[depth+1]='\0';
      if (NODE(child)->entry) {
	Entry *entry = ENTRY(NODE(child)->entry);
	fprintf(stream,",\n# %-8s\n	%-32s=%-s", entry->name, entry->terminfo, FixEscapes(buf,seq));
	fflush(stream);
      }
      ++depth;
      DumpHashTab(stream, child);
      --depth;
    }
  }
}


#ifdef DEBUG_SMARTHASH
static char *SHSeq="";
#define CharTab(CHAR, TEST) ((child = Child(node, CHAR)) && (TEST))
#define CacheSeq() char *oseq = SHSeq
#define BindTab(CHAR) \
register short int node = child; \
CacheSeq(); \
char seq[BUFSIZ]; \
if (CHAR<' ') sprintf(seq, "%s^%c", oseq, (CHAR+'@')); else sprintf(seq,"%s%c",oseq,CHAR); \
SHSeq=seq;
#define RestoreTab() SHSeq=oseq
#define WithCharTable(CHAR, TEST, BODY) if (CharTab(CHAR,TEST)) {BindTab(CHAR); BODY; RestoreTab();}
#else
#define CacheSeq() NULL
#define CharTab(CHAR, TEST) ((child = Child(node, CHAR)) && (TEST))
#define BindTab(CHAR) register short int node = child;
#define RestoreTab() NULL
#define WithCharTable(CHAR, TEST, BODY) if (CharTab(CHAR,TEST)) {BindTab(CHAR); BODY; RestoreTab();}
#endif

static char *EndPtr;

FPTR SmartHash(node, s, pop)
register short int node;
char *s;
long *pop;
{
  FPTR r = NULL;
  char *c;
  register short int child; /* temporary used in WithCharTable */

#ifdef DEBUG_SMARTHASH
  static int depth=0;
  CacheSeq();
  ++depth;
#endif
  
  
  if (!node || !s) fatal("Bad Args to SmartHash");
  if (!*s && NODE(node)->u.children && Nextch(NextchInputWait, s)) *(s+1)='\0';
  
#ifdef DEBUG_SMARTHASH
  {
    static char space[BUFSIZ];
    char buf[BUFSIZ];
    int sp;
    for (sp=0; sp < depth; ++sp) space[sp]='|'; space[sp]='\0';
    fprintf(stderr, "%s%d SmartHash(node:%3d, s:\"%s\", pop:0x%d=%d:'%c') seq:\"%s\"\n", 
	    space, depth, node, s, pop, *pop, ((*pop<256)?(char)*pop:'?'), SHSeq); 
    fprintf(stderr, "%s%s a0: %d, a1: %d, a2: %d a3: %d a4: %d\n", space, (depth>9?"  ":" "), 
	    Arg[0], Arg[1], Arg[2], Arg[3], Arg[4]);
  }
#endif

  if (!*s && NODE(node)->entry) { EndPtr=s; r=Entries[NODE(node)->entry].func; goto DONE; }
  else if (!*s) { r = NULL; goto DONE; }
  
  if (CharTab(BYTE7(*s),TRUE)) {
    long npop = BYTE7(*s), opop = *pop;
    BindTab(*s);
    *pop = npop;
    if (r=SmartHash(node, (s+1), &npop)) goto DONE; 
    *pop = opop;
    RestoreTab();
  }
  if (CharTab('%',TRUE)) { 
    BindTab('%');
    if (CharTab('%', (*s == '%'))) { 
      long npop = *s, opop = *pop;
      BindTab('c'); 
      *pop = npop;
      if (r=SmartHash(node, (s+1), &npop)) goto DONE;
      *pop = opop;
      RestoreTab();
    }
    if (CharTab('c', TRUE)) { 
      long npop = BYTE7(*s), opop = *pop;
      BindTab('c'); 
      *pop = npop;
      if (r=SmartHash(node, (s+1), &npop)) goto DONE;
      *pop = opop;
      RestoreTab();
    }
    if (CharTab('s',TRUE)) { 
      static char buf[257], *b; /* This is limited to only one string match !!! */
      long opop = *pop, len = (*pop > 256) ? 256 : *pop; /* Drop Overflow! */
      BindTab('s');
      for (c = s, b = buf; (len-- > 0); ++b, ++c) {
	if (!*c && Nextch(NextchInputWait,c)) *(c+1)='\0';
	*b = BYTE7(*c);
      }
      *b='\0';
      *pop = (long)buf; 
      if (r = SmartHash(node, c, pop)) goto DONE;
      *pop = opop;
      RestoreTab();
    }
    if (CharTab('d',TRUE)) {
      long npop=0, opop = *pop;
      BindTab('d');
      c = s;
      while (*c >= '0' && *c <= '9') {
        npop = ((npop * 10)+(*c - '0'));
	if (!*(++c) && Nextch(NextchInputWait,c)) *(c+1)='\0';
      }
      while ((c > s) && (*s >= '0' && *s <= '9')) {
        *pop = npop;
        if (r=SmartHash(node, c, &npop)) goto DONE;
        --c; npop /= 10;
      }
      *pop = opop;
      RestoreTab();
    }
    if (CharTab('p',TRUE)) {
      BindTab('p');
      for (c="123456789"; *c; ++c) {
	if (CharTab(*c,TRUE)) {
	  long argno = (*c - '1'), old = Arg[argno];
	  BindTab(*c);
	  if (r=SmartHash(node, s, (Arg+argno))) {
	    if (argno >= Argno) Argno = argno+1;
	    *pop = Arg[argno];
	    goto DONE; }
	  Arg[argno] = old; 
	  RestoreTab();
	}
      }
      RestoreTab();
    }
    if (CharTab('g',TRUE)) {
      BindTab('g');
      for (c="abcdefghijklmnopqrstuvwxyz"; *c; ++c) {
	if (CharTab(*c,TRUE)) { 
	  long varno = (*c - 'a'), old = Vars[varno];
	  BindTab(*c);
	  if (r=SmartHash(node, s, (Vars+varno))) {
	    *pop = Vars[varno];
	    goto DONE; }
	  Vars[varno] = old; 
	  RestoreTab();
	}
      }
      RestoreTab();
    }
    if (CharTab('P',TRUE)) { 
      BindTab('P');
      for (c="abcdefghijklmnopqrstuvwxyz"; *c; ++c) {
	if (CharTab(*c,TRUE)) { 
	  long npop = Vars[(*c - 'a')];
	  BindTab(*c);
	  if (r=SmartHash(node, s, &npop)) goto DONE;
	  RestoreTab();
	}
      }
      RestoreTab();
    }
    WithCharTable('l',TRUE, if (r=SmartHash(node, s, pop)) goto DONE; );
    WithCharTable('i',TRUE, if (r=SmartHash(node, s, pop)) { Arg[0]--; Arg[1]--; goto DONE;});
    WithCharTable('~',TRUE, if (r=SmartHash(node, s, pop)) { *pop = ~*pop; goto DONE; });
    WithCharTable('!',TRUE, if (r=SmartHash(node, s, pop)) { *pop = !*pop; goto DONE; });
    
    WithCharTable('+',TRUE, { long npop = *pop; if (r=SmartHash(node, s, &npop)) { *pop -= npop; goto DONE;}});
    WithCharTable('-',TRUE, { long npop = *pop; if (r=SmartHash(node, s, &npop)) { *pop += npop; goto DONE;}});
    WithCharTable('*',TRUE, { long npop = *pop; if (r=SmartHash(node, s, &npop)) { *pop /= npop; goto DONE;}});
    WithCharTable('/',TRUE, { long npop = *pop; if (r=SmartHash(node, s, &npop)) { *pop *= npop; goto DONE;}});
    WithCharTable('|',TRUE, { long npop = *pop; if (r=SmartHash(node, s, &npop)) { *pop -= npop; goto DONE;}});
    WithCharTable('O',TRUE, { long npop = *pop; if (r=SmartHash(node, s, &npop)) { *pop -= npop; goto DONE;}});
    WithCharTable('&',TRUE, { long npop = *pop; if (r=SmartHash(node, s, &npop)) { *pop -= npop; goto DONE;}});
    WithCharTable('A',TRUE, { long npop = *pop; if (r=SmartHash(node, s, &npop)) { *pop -= npop; goto DONE;}});
    WithCharTable('^',TRUE, if (r=SmartHash(node, s, pop)) goto DONE);
    WithCharTable('m',TRUE, if (r=SmartHash(node, s, pop)) goto DONE); 
    WithCharTable('<',TRUE, NULL); WithCharTable('>',TRUE, NULL); WithCharTable('=',TRUE, NULL);
    RestoreTab();
  };
  if (NODE(node)->entry) EndPtr=s;
  r = (NODE(node)->entry ? (Entries + NODE(node)->entry)->func : NULL);
 DONE:
#ifdef DEBUG_SMARTHASH
  { static char space[BUFSIZ];
    char buf[BUFSIZ];
    int sp;
    for (sp=0; sp < depth; ++sp) space[sp]='|'; space[sp]='\0';
    fprintf(stderr, "%s%d => [pop:%d:'%c'] r:%s() seq:\"%s\"\n",
	    space, depth, *pop, ((*pop<256)?(char)*pop:'?'), (r?FuncToEntry(r)->name:"NULL"), SHSeq);
    fprintf(stderr, "%s%s a0: %d, a1: %d, a2: %d a3: %d a4: %d\n", space, (depth>9?"  ":" "), 
	    Arg[0], Arg[1], Arg[2], Arg[3], Arg[4]);
  }
  --depth;
#endif
  RestoreTab();
  return(r);
}

char *LookupCap(termtab, cap) 
char *cap;
TermTab *termtab;
{
  Entry *entry = TerminfoToEntry(cap);
  if (!entry) return(NULL);
  if (*entry->type == *TNUM) {
    sprintf(Buffer,"%d", (int)*(int *)(((char *)termtab) + (int)entry->func));
    Buffer[strlen(Buffer)+1] = 'n'; /* Hide Type info after string */
    return(Buffer);
  }
  if (*entry->type == *TBOOL) {
    int b = (int)*(char *)(((char *)termtab) + (int)entry->func);
    if (b != 1 && b != 0) return(NULL);
    sprintf(Buffer,"%d", b);
    Buffer[strlen(Buffer)+1] = 'b'; /* Hide Type info after string */
    return(Buffer);
  }
  if (*entry->type == *TINFO) {
    char *s= *(char **)(((char *)termtab) + (int)entry->func);
    return((s>(char *)0)?s:(char *)NULL);
  }
}

char *InstallCapability(stream, cap, code, type, access, func, funcname, doc)
FILE *stream;
void (*func)();
char *cap, *access, *doc, *code, *funcname, *type;
{
  if (*type == *TSTRING) {
    if (func && access) return(SetHash(stream, EscSeqTab, access, TerminfoToEntry(cap)));
    else return(NULL);
  }
  else if (*type == *TNUM) {
    Entry *entry = TerminfoToEntry(cap);
    int *valptr = (int *)((char *)CurrTerm + (int)entry->func);
    if (stream && *valptr != -1 && *valptr != (int)access) {
      fprintf(stream,",\n# %s Value Clash for Cap: %s, (Keep %s)", type, cap, (CLOBBER_OLD_VAL?"New":"Old"));
      fprintf(stream,",\n#   Old Value: %d", *valptr);
      fprintf(stream,",\n#   New Value: %d", (int)access);
      fflush(stream);
    }
    if (*valptr == -1 || (CLOBBER_OLD_VAL && *valptr != (int)access)) {
      if (valptr) *valptr = (int)access;
      if (entry) entry->access = access;
    }
  }
  else if (*type == *TBOOL) {
    Entry *entry = TerminfoToEntry(cap);
    char *valptr = (char *)((char *)CurrTerm + (int)entry->func);
    if (stream && *valptr != (char)-1 && *valptr != (char)access) {
      fprintf(stream,",\n# %s Value Clash for Cap: %s, (Keep %s)", type, cap, (CLOBBER_OLD_VAL?"New":"Old"));
      fprintf(stream,",\n#   Old Value: %d", *valptr);
      fprintf(stream,",\n#   New Value: %d", (int)(char)access);
      fflush(stream);
    }
    if (*valptr == (char)-1 || (CLOBBER_OLD_VAL && *valptr != (char)access)) {
      if (valptr) *valptr = (char)access;
      if (entry) entry->access = access;
    }
  }
  else if (*type == *TINFO) {
    Entry *entry = TerminfoToEntry(cap);
    char **valptr = (char **)((char *)CurrTerm + (int)entry->func);
    if (stream && *valptr != (char *)-1 && (access>(char *)0) && strcmp(*valptr,(char *)access)) {
      fprintf(stream,",\n# %s Value Clash for Cap: %s, (Keep %s)", type, cap, (CLOBBER_OLD_VAL?"New":"Old"));
      fprintf(stream,",\n#   Old Value: \"%s\"", *valptr);
      fprintf(stream,",\n#   New Value: \"%s\"", (char *)access);
      fflush(stream);
    }
    if ((*valptr == (char *)-1) || (CLOBBER_OLD_VAL && (access>(char *)0) && strcmp(*valptr,(char *)access))) {
      if (valptr && *valptr != (char *)-1) { free(*valptr); *valptr = (char *)-1; }
      if (valptr) {
	if (access>(char *)0) {
	  *valptr = (char *)malloc(strlen(access)+2);
	  strcpy(*valptr,access);
	  (*valptr)[strlen(access)+1] = 's';	/* Hide Type info after string */
	}
      }
      if (entry) entry->access = *valptr;
    }
  }
}

char *ReadToken(istream, delims, delimp)
FILE *istream;
char *delims;
char *delimp;
{
  static char buf[BUFSIZ], *b=NULL, *r, *e;

  if (!b) b=buf;
  while (1) {
    while (*b && strchr(" 	",*b)) b++;
    if (!*b || *b=='#') {
      b = buf; 
      if (!istream || !fgets(buf,BUFSIZ,istream)) return(NULL);
      if (buf[strlen(buf)-1]=='\n') buf[strlen(buf)-1]='\0';
      continue;
    }
    r=b;
    for(b=r; *b && !strchr(delims,*b); ++b) if (*b == '\\') ++b;
    *delimp = *b;
    if (*b) *b++ = '\0';
    for(e = r+strlen(r)-1; e>=r && strchr(" 	",*e); *e-- = '\0');
    return(r);
  }
}

int ReadExtraTermCapabilities(stream,termtype)
FILE *stream;
char *termtype;
{
  FILE *fp;
  char message[BUFSIZ], fn[BUFSIZ], *ns;
  int pass = 0, found = 0;
  char *b, *delim = " ";

  sprintf(fn,"%s/ExpectCap.%s",ExpectDir,termtype);
  fp = fopen(fn,"r");
  if (!fp) { sprintf(fn,"%s/ExpectCap",ExpectDir); fp = fopen(fn,"r"); }
  if (!fp) return(0);
  
  while(b = ReadToken(fp, "|,", delim)) {
    if (!strcmp(b,termtype)) {
      found = 1;
      if (*delim != ',') ReadToken(fp,",",delim);
      break;
    }
    if (*delim == ',') while(ReadToken(fp,",",delim) && (*delim==','));
  }
  while(b && (*delim==',') && (b = ReadToken(fp, ",=#@", delim))) {
    char terminfo[64];
    Entry *entry;

    strcpy(terminfo, b);
    entry = TerminfoToEntry(terminfo);
    if (!entry) { sprintf(message,"Bad Terminfo: %s in Term File: %s", terminfo,fn); fatal(message); exit(-1); }
    if (!pass++ && stream) fprintf(stream,",\n# Adding Sequences from %s", fn);
    if (*entry->type == *TBOOL) {
      if (*delim == '@') {
	ns = (char *)0;
	ReadToken(NULL,",",delim);
      }
      else ns = (char *)1;
      InstallCapability(stream, terminfo, entry->termcap, entry->type, ns, entry->func, entry->name, entry->doc);
    }
    else if (*entry->type == *TNUM) {
      if (*delim != '#' || !(b = ReadToken(fp, ",", delim))) {
	sprintf(message,"Bad Terminfo: %s in Term File: %s", terminfo,fn); fatal(message); exit(-1);
      }
      ns = (char *)atoi(b);
      InstallCapability(stream, terminfo, entry->termcap, entry->type, ns, entry->func, entry->name, entry->doc);
    }
    else {
      char nseq[BUFSIZ];
      if (*delim != '=' || !(b = ReadToken(fp, ",", delim))) {
	sprintf(message,"Bad Terminfo: %s in Term File: %s", terminfo,fn); fatal(message); exit(-1);
      }
      for(ns=nseq; *b; ++b, ++ns) {
	  switch (*b) {
	  case '\\':
	    switch (*(++b)) {
	    case 'n': *ns = '\n'; break;
	    case 'l': *ns = ''; break;
	    case 'r': *ns = '\r'; break;
	    case 't': *ns = '\t'; break;
	    case 'b': *ns = '\b'; break;
	    case 'f': *ns = '\f'; break;
	    case 's': *ns = ' '; break;
	    case '0': *ns = '\200'; break;
	    case 'E': case 'e': *ns = ''; break;
	    default: *ns = *b; break;
	    } break;
	  case '^': *ns = (*(++b) - 'A' + ''); break;
	  default: *ns = *b; break;
	  }
	}
      *ns = '\0';
      ns = nseq;
      InstallCapability(stream, terminfo, entry->termcap, entry->type, ns, entry->func, entry->name, entry->doc);
    }
  }
  fclose(fp);
  return(found);
}

static jmp_buf input_env;	/* for interruptable read() */
static int input_env_valid = FALSE;	/* whether we can longjmp or not */

CacheInput() {
  if (input_env_valid && Session->breaksp) {
    longjmp(input_env,2);
  }
  return(0);
}

#define IBUFSIZ 128
char *OutputSequence = NULL;
long handle_output()
{ /* handle_output - Main loop of output process. Reads and dispatches characters from output stream. */
  static char CurrInputSeq[IBUFSIZ]; /* don't want this on stack */
  static long n, pop=0, i, len;
  static FPTR func;
  static int readcount;

  Session->input_cached_p = 0;
  input_env_valid = FALSE;
  if (setjmp(input_env) != 2) {
    for (n=0; Nextch(0.0, CurrInputSeq); n++) {
      (OutputSequence=EndPtr = CurrInputSeq)[1] = '\0';
      while (*EndPtr) {
	OutputSequence = EndPtr;
	for (i=0; i < Argno; ++i) Arg[i]=0; Argno=0; pop = 0;
	NextchInputWait = (*EndPtr == '\033') ? 3.0 : 1.0;
	func=SmartHash(Session->term->termtab, EndPtr, &pop);
#ifdef DEBUG_TERMFUNCS
	if (Session->raw_log && func) {
	  fprintf(Session->raw_log, "\n<<%s: %d %d,%d,%d>>\n", FuncToEntry(func)->name, Argno, Arg[0], Arg[1], Arg[2]);
	  fflush(Session->raw_log);
	}
#endif
	if (func) (*func)();
	else if (*EndPtr == NUL && Session->term->bool_in==1) { /* NUL inserts whitespace */
	  EndPtr++; BPUTC(' ');
	}
	else if ((*EndPtr >= ' ') && !(*EndPtr & ~BITS7)) BPUTC(Session, *EndPtr++);
	else EndPtr++;
	input_env_valid = TRUE;
      }
    }
  }
  else {			/* Jumped */
    len=strlen(OutputSequence);
    for (i=0; i<len; ++i) UngetChar(OutputSequence[len-i-1]);
    Session->input_cached_p = len;
  }
  input_env_valid = FALSE;
  return(n);
}

#include <term.h>

TermTab *EmulateTerm(termtype, inp, outp)
FILE *inp, *outp;
char *termtype;
{
  static int n, ok, found;
  static int pass = 0;
  extern char *Strdup();
#define MAXTERMTYPE 32
  static TermTab terms[MAXTERMTYPE];
  static TERMINAL emu_term;
  static TERMINAL *oterm;
  oterm = cur_term;
  ok = 1; 
  if (!pass++) {
    memset((char *)terms, -1, sizeof(terms));
    for (n=0; n < MAXTERMTYPE; ++n) {
      terms[n].type = NULL; 
      terms[n].termtab = NULL; 
      terms[n].Local=0;
      terms[n].InsertMode=1;
    }
    unlink(WLOG);
    ExpectDir=(char *)getenv("EXPECT_DIR");
    ExpectLogDir=(char *)getenv("EXPECT_LOGDIR");
    if (!ExpectDir) ExpectDir = (char *)Strdup(PROGDIR);
    if (!ExpectLogDir) ExpectLogDir = (char *)getenv("HOME");
    if (!ExpectLogDir) ExpectLogDir = (char *) Strdup("");
    { TermTab tt;
      CurrTerm = &tt;
      MapTermCaps(stdout, NewEntry);
      CurrTerm = NULL;
    }
  }
  for (n=0; n < MAXTERMTYPE && terms[n].type; ++n)
    if (!strcmp(terms[n].type, termtype)) break;
  CurrTerm = terms + n;
  if (n < MAXTERMTYPE && !CurrTerm->type) {
    FILE *stream;
    if (SetAlarm(5.0)) {
      set_curterm(&emu_term); 
      setupterm(Strdup(termtype), fileno(outp), &ok);
    }
    ClearAlarm();
    if (ok != 1) {
      /* del_curterm(&emu_term); */ 
      set_curterm(oterm);
      /* return(NULL); */
    }
    { char buf[64];
      sprintf(buf,"%s/ExpectCap.terminfo", ExpectLogDir);
      stream = fopen(buf,"w");
      if (!stream) {
        sprintf(buf,"ExpectCap.terminfo", ExpectLogDir);
        stream = fopen(buf,"w");
      }
      if (!stream) {
        sprintf(buf,"/tmp/ExpectCap.terminfo", ExpectLogDir);
        stream = fopen(buf,"w");
      }
    }
    if (stream) fprintf(stream,"%s", termtype); 
    EscSeqTab = NewNode();
    CurrTerm->type = Strdup(termtype);
    CurrTerm->termtab = EscSeqTab;
#if CLOBBER_OLD_VAL
    if (ok && stream) fprintf(stream,",\n# Adding Sequences from Terminfo");
    if (ok) MapTermCaps(stream, InstallCapability);
    found=ReadExtraTermCapabilities(stream, Strdup(termtype));
#else
    found=ReadExtraTermCapabilities(stream, Strdup(termtype));
    if (ok && stream) fprintf(stream,",\n# Adding Sequences from Terminfo");
    if (ok) MapTermCaps(stream, InstallCapability);
#endif
    if (!ok && !found) { if (stream != stdout && stream) fclose(stream); return(NULL); }
    if (stream) fprintf(stream,",\n# Nodes: %d", NodeCurr);
    if (stream) fprintf(stream,",\n# Entries:   %d", EntryCurr);
    if (stream) fflush(stream);

    ShowTermCapabilities(stream,TBOOL);
    ShowTermCapabilities(stream,TNUM);
    ShowTermCapabilities(stream,TINFO);
/*    DumpHashTab(stream,EscSeqTab); */
    set_curterm(oterm);
    if (stream) { 
      time_t ltime;
      time(&ltime);	
      fprintf(stream,"\n# %s", ctime(&ltime));
    }
    if (stream && stream != stdout) fclose(stream);
  } else EscSeqTab = CurrTerm->termtab;
  return(CurrTerm);
}

#define OFFSET(STRUCT, FIELD) ((int)(&STRUCT->FIELD)-(int)(STRUCT))
MapTermCaps(stream, func)
void (*func)();
FILE *stream;
{
  /* Boolean Capabilities */
#ifndef auto_right_margin
#define auto_right_margin -1
#endif
  (*func)(stream,"am", 	"am",	TBOOL,   auto_right_margin,	OFFSET(CurrTerm,bool_am),	NULL,	"wraps right");
#ifndef auto_left_margin
#define auto_left_margin -1
#endif
  (*func)(stream,"bw",	"bw",	TBOOL,   auto_left_margin,	OFFSET(CurrTerm,bool_bw),	NULL,	"left wrap");
#ifndef hard_cursor
#define hard_cursor -1
#endif
  (*func)(stream,"chts","HC",	TBOOL,   hard_cursor,		OFFSET(CurrTerm,bool_chts),	NULL,	"hard to see curs needs to be more visible");
#ifndef command_character
#define command_character -1
#endif
  (*func)(stream,"cmdch","CC",	TBOOL,   command_character,	OFFSET(CurrTerm,bool_cmdch),	NULL,	"Indicates term command prot char can be set");
#ifndef memory_above
#define memory_above -1
#endif
  (*func)(stream,"da",	"da",	TBOOL,   memory_above,		OFFSET(CurrTerm,bool_da),	NULL,	"Can retain display memory above screen");
#ifndef memory_below
#define memory_below -1
#endif
  (*func)(stream,"db",	"db",	TBOOL,   memory_below,		OFFSET(CurrTerm,bool_db),	NULL,	"Can retain display memory below screen");
#ifndef erase_overstrike
#define erase_overstrike -1
#endif
  (*func)(stream,"eo",	"eo",	TBOOL,   erase_overstrike,	OFFSET(CurrTerm,bool_eo),	NULL,	"Can erase overstrike with blanks");
#ifndef status_line_esc_ok
#define status_line_esc_ok -1
#endif
  (*func)(stream,"eslok","es",	TBOOL,   status_line_esc_ok,	OFFSET(CurrTerm,bool_eslok),	NULL,	"Escape can be used on status line");
#ifndef generic_type
#define generic_type -1
#endif
  (*func)(stream,"gn",	"gn",	TBOOL,   generic_type,		OFFSET(CurrTerm,bool_gn),	NULL,	"Generic line type");
#ifndef hard_copy
#define hard_copy -1
#endif
  (*func)(stream,"hc",	"hc",	TBOOL,   hard_copy,		OFFSET(CurrTerm,bool_hc),	NULL,	"term is hardcopy printer");
#ifndef has_status_line
#define has_status_line -1
#endif
  (*func)(stream,"hs",	"hs",	TBOOL,   has_status_line,	OFFSET(CurrTerm,bool_hs),	NULL,	"Has extra status line");
#ifndef tilde_glitch
#define tilde_glitch -1
#endif
  (*func)(stream,"hz",	"hz",	TBOOL,   tilde_glitch,		OFFSET(CurrTerm,bool_hz),	NULL,	"Can't print ~");
#ifndef insert_null_glitch
#define insert_null_glitch -1
#endif
  (*func)(stream,"in",	"in",	TBOOL,   insert_null_glitch,	OFFSET(CurrTerm,bool_in),	NULL,	"NULL(o200) inserts whitespace");
#ifndef has_meta_key
#define has_meta_key -1
#endif
  (*func)(stream,"km",	"km",	TBOOL,   has_meta_key,		OFFSET(CurrTerm,bool_km),	NULL,	"has meta key");
#ifndef prtr_silent
#define prtr_silent -1
#endif
  (*func)(stream,"mc5i","5i",	TBOOL,   prtr_silent,		OFFSET(CurrTerm,bool_mc5i),	NULL,	"Terminal aux prtr causes no echo on screen");
#ifndef move_insert_mode
#define move_insert_mode -1
#endif
  (*func)(stream,"mir",	"mi",	TBOOL,   move_insert_mode,	OFFSET(CurrTerm,bool_mir),	NULL,	"cursor may move in insert mode");
#ifndef cursor_mem_address
#define cursor_mem_address -1
#endif
  (*func)(stream,"mrcup","CM",	TBOOL,	cursor_mem_address,	OFFSET(CurrTerm,bool_mrcup),	NULL,	"cursor relative memory addressing");
#ifndef move_standout_mode
#define move_standout_mode -1
#endif
  (*func)(stream,"msgr","ms",	TBOOL,   move_standout_mode,	OFFSET(CurrTerm,bool_msgr),	NULL,	"Is safe to move in standout modes");
#ifndef needs_xon_xoff
#define needs_xon_xoff -1
#endif
  (*func)(stream,"nxon","nx",	TBOOL, needs_xon_xoff,		OFFSET(CurrTerm,bool_nxon),	NULL,	"Padding will not work, xon/xoff req");
#ifndef no_pad_char
#define no_pad_char -1
#endif
  (*func)(stream,"npc",	"NP",	TBOOL,   no_pad_char,		OFFSET(CurrTerm,bool_npc),	NULL,	"No pad char exists for the terminal");
#ifndef non_rev_rmcup
#define non_rev_rmcup -1
#endif
  (*func)(stream,"nrrmc","NR",	TBOOL,   non_rev_rmcup,		OFFSET(CurrTerm,bool_nrrmc),	NULL,	"smcup cannot reverse rmcup");
#ifndef over_strike
#define over_strike -1
#endif
  (*func)(stream,"os",	"os",	TBOOL,   over_strike,		OFFSET(CurrTerm,bool_os),	NULL,	"overstrike");
#ifndef transparent_underline
#define transparent_underline -1
#endif
  (*func)(stream,"ul",	"ul",	TBOOL,   transparent_underline,	OFFSET(CurrTerm,bool_ul),	NULL,	"underline");
#ifndef eat_newline_glitch
#define eat_newline_glitch -1
#endif
  (*func)(stream,"xenl","xn",	TBOOL,   eat_newline_glitch,	OFFSET(CurrTerm,bool_xenl),	NULL,	"New-line ignored after 80 cols");
#ifndef ceol_standout_glitch
#define ceol_standout_glitch -1
#endif
  (*func)(stream,"shp",	"sh",	TBOOL,   ceol_standout_glitch,	OFFSET(CurrTerm,bool_xhp),	NULL,	"standout not erased by overwriting(xhp?)");
#ifndef ceol_standout_glitch
#define ceol_standout_glitch -1
#endif
  (*func)(stream,"xhp",	"xs",	TBOOL,   ceol_standout_glitch,	OFFSET(CurrTerm,bool_xhp),	NULL,	"standout not erased by overwriting");
#ifndef xon_xoff
#define xon_xoff -1
#endif
  (*func)(stream,"xon",	"xo",	TBOOL,   xon_xoff,		OFFSET(CurrTerm,bool_xon),	NULL,	"uses xon/xoff");
#ifdef beehive_glitch
  (*func)(stream,"xsb",	"xb",	TBOOL,   beehive_glitch,	OFFSET(CurrTerm,bool_xsb),	NULL,	"No escape or ctrl-C,(f1=esc, f2=ctrl-c)");
#else
#ifndef no_esc_ctlc
#define no_esc_ctlc -1
#endif
  (*func)(stream,"xsb",	"xs",	TBOOL,   no_esc_ctlc,		OFFSET(CurrTerm,bool_xsb),	NULL,	"No escape or ctrl-C,(f1=esc, f2=ctrl-c)");
#endif
/*(*func)(stream,"xsb",	"xb",	TBOOL,   no_esc_ctlc,		NULL,	NULL,	"No escape or ctrl-C,(f1=esc, f2=ctrl-c)");*/
#ifdef teleray_glitch
  (*func)(stream,"xt",	"xt",	TBOOL,   teleray_glitch,	OFFSET(CurrTerm,bool_xt),	NULL,	"backspace with spaces over tabs");
#else
#ifndef dest_tabs_magic_smso
#define dest_tabs_magic_smso -1
#endif
  (*func)(stream,"xt",	"xt",	TBOOL,   dest_tabs_magic_smso,	OFFSET(CurrTerm,bool_xt),	NULL,	"backspace with spaces over tabs"); 
#endif

  /* Numeric Capablities */
#ifndef columns
#define columns -1
#endif
  (*func)(stream,"cols",	"co",	TNUM,    columns,	OFFSET(CurrTerm,int_cols),	NULL,	"columns");
#ifndef init_tabs
#define init_tabs -1
#endif
  (*func)(stream,"it",	"it",	TNUM,    init_tabs,		OFFSET(CurrTerm,int_it),	NULL,	"initial hardware tabstops");
#ifndef label_height
#define label_height -1
#endif
  (*func)(stream,"lh",	"lh",	TNUM,    label_height,		OFFSET(CurrTerm,int_lh),	NULL,	"label height");
#ifndef lines
#define lines -1
#endif
  (*func)(stream,"lines",	"li",	TNUM,    lines,		OFFSET(CurrTerm,int_lines),	NULL,	"lines");
#ifndef lines_of_memory
#define lines_of_memory -1
#endif
  (*func)(stream,"lm",	"lm",	TNUM,    lines_of_memory,	OFFSET(CurrTerm,int_lm),	NULL,	"lines of memory if > lines(0=varies)");
#ifndef label_width
#define label_width -1
#endif
  (*func)(stream,"lw",	"lw",	TNUM,    label_width,		OFFSET(CurrTerm,int_lw),	NULL,	"number of columns in each label");
#ifndef num_labels
#define num_labels -1
#endif
  (*func)(stream,"nlab",	"Nl",	TNUM,    num_labels,	OFFSET(CurrTerm,int_nlab),	NULL,	"number of labels on screen(start at 1)");
#ifndef padding_baud_rate
#define padding_baud_rate -1
#endif
  (*func)(stream,"pb",	"pb",	TNUM,    padding_baud_rate,	OFFSET(CurrTerm,int_pb),	NULL,	"lowest baud rate where padding needed");
#ifndef width_status_line
#define width_status_line -1
#endif
  (*func)(stream,"wsl",	"ws",	TNUM,    width_status_line,	OFFSET(CurrTerm,int_wsl),	NULL,	"number of cols in status line");
#ifndef magic_cookie_glitch
#define magic_cookie_glitch -1
#endif
  (*func)(stream,"xmc",	"sg",	TNUM,    magic_cookie_glitch,	OFFSET(CurrTerm,int_xmc),	NULL,	"number of blank chars left by smso or rmso");
#ifndef virtual_terminal
#define virtual_terminal -1
#endif
  (*func)(stream,"vt",	"vt",	TNUM,    virtual_terminal,	OFFSET(CurrTerm,int_vt),	NULL,	"virtual terminal number");

  /* string info */

#ifndef appl_defined_str
#define appl_defined_str NULL
#endif
  (*func)(stream,"apstr",	"za",	TINFO, appl_defined_str,	OFFSET(CurrTerm,str_apstr),	"apstr",	"Application defined string");
#ifndef box_attr_1
#define box_attr_1 NULL
#endif
  (*func)(stream,"batt1",	"Bx",	TINFO, box_attr_1,		OFFSET(CurrTerm,str_batt1),	"batt1",	"atributes for box_chars_1");
#ifndef box_attr_2
#define box_attr_2 NULL
#endif
  (*func)(stream,"batt2",	"Byx",	TINFO, box_attr_2,		OFFSET(CurrTerm,str_batt2),	"batt2",	"atributes for box_chars_2");
#ifndef box_chars_1
#define box_chars_1 NULL
#endif
  (*func)(stream,"box1",	"bx",	TINFO, box_chars_1,		OFFSET(CurrTerm,str_box1),	"box1",		"Terminal box chars 1");
#ifndef box_chars_2
#define box_chars_2 NULL
#endif
  (*func)(stream,"box2",	"by",	TINFO, box_chars_2,		OFFSET(CurrTerm,str_box2),	"box2",		"Terminal box chars 2");
#ifndef color_bg_0
#define color_bg_0 NULL
#endif
  (*func)(stream,"colb0",	"d0",	TINFO, color_bg_0,		OFFSET(CurrTerm,str_colb0),	"colb0",	"Background color 0 black");
#ifndef color_bg_1
#define color_bg_1 NULL
#endif
  (*func)(stream,"colb1",	"d1",	TINFO, color_bg_1,		OFFSET(CurrTerm,str_colb1),	"colb1",	"Background color 1 red");
#ifndef color_bg_2
#define color_bg_2 NULL
#endif
  (*func)(stream,"colb2",	"d2",	TINFO, color_bg_2,		OFFSET(CurrTerm,str_colb2),	"colb2",	"Background color 2 green");
#ifndef color_bg_3
#define color_bg_3 NULL
#endif
  (*func)(stream,"colb3",	"d3",	TINFO, color_bg_3,		OFFSET(CurrTerm,str_colb3),	"colb3",	"Background color 3 brown");
#ifndef color_bg_4
#define color_bg_4 NULL
#endif
  (*func)(stream,"colb4",	"d4",	TINFO, color_bg_4,		OFFSET(CurrTerm,str_colb4),	"colb4",	"Background color 4 blue");
#ifndef color_bg_5
#define color_bg_5 NULL
#endif
  (*func)(stream,"colb5",	"d5",	TINFO, color_bg_5,		OFFSET(CurrTerm,str_colb5),	"colb5",	"Background color 5 magenta");
#ifndef color_bg_6
#define color_bg_6 NULL
#endif
  (*func)(stream,"colb6",	"d6",	TINFO, color_bg_6,		OFFSET(CurrTerm,str_colb6),	"colb6",	"Background color 6 cyan");
#ifndef color_bg_7
#define color_bg_7 NULL
#endif
  (*func)(stream,"colb7",	"d7",	TINFO, color_bg_7,		OFFSET(CurrTerm,str_colb7),	"colb7",	"Background color 7 white");
#ifndef color_fg_0
#define color_fg_0 NULL
#endif
  (*func)(stream,"colf0",	"0",	TINFO, color_fg_0,		OFFSET(CurrTerm,str_colf0),	"colf0",	"Foreground color 0 white");
#ifndef color_fg_1
#define color_fg_1 NULL
#endif
  (*func)(stream,"colf1",	"c1",	TINFO, color_fg_1,		OFFSET(CurrTerm,str_colf1),	"colf1",	"Foreground color 1 red");
#ifndef color_fg_2
#define color_fg_2 NULL
#endif
  (*func)(stream,"colf2",	"c2",	TINFO, color_fg_2,		OFFSET(CurrTerm,str_colf2),	"colf2",	"Foreground color 2 green");
#ifndef color_fg_3
#define color_fg_3 NULL
#endif
  (*func)(stream,"colf3",	"c3",	TINFO, color_fg_3,		OFFSET(CurrTerm,str_colf3),	"colf3",	"Foreground color 3 brown");
#ifndef color_fg_4
#define color_fg_4 NULL
#endif
  (*func)(stream,"colf4",	"c4",	TINFO, color_fg_4,		OFFSET(CurrTerm,str_colf4),	"colf4",	"Foreground color 4 blue");
#ifndef color_fg_5
#define color_fg_5 NULL
#endif
  (*func)(stream,"colf5",	"c5",	TINFO, color_fg_5,		OFFSET(CurrTerm,str_colf5),	"colf5",	"Foreground color 5 magenta");
#ifndef color_fg_6
#define color_fg_6 NULL
#endif
  (*func)(stream,"colf6",	"c6",	TINFO, color_fg_6,		OFFSET(CurrTerm,str_colf6),	"colf6",	"Foreground color 6 cyan");
#ifndef color_fg_7
#define color_fg_7 NULL
#endif
  (*func)(stream,"colf7",	"c7",	TINFO, color_fg_7,		OFFSET(CurrTerm,str_colf7),	"colf7",	"Foreground color 7 black");
#ifndef init_file
#define init_file NULL
#endif
  (*func)(stream,"if",		"if",	TINFO, init_file,		OFFSET(CurrTerm,str_if),	"if",		"/usr/lib/tabset/? init file");
#ifndef insert_padding
#define insert_padding NULL
#endif
  (*func)(stream,"ip",		"ip",	TINFO, insert_padding,		OFFSET(CurrTerm,str_ip),	"ip",		"insert padding after char inserted");
#ifndef init_prog
#define init_prog NULL
#endif
  (*func)(stream,"iprog",	"iP",	TINFO, init_prog,		OFFSET(CurrTerm,str_iprog),	"iprog",	"path name for prog initialization");
#ifndef key_backspace
#define key_backspace NULL
#endif
  (*func)(stream,"kbs",		"kb",	TINFO, key_backspace,		OFFSET(CurrTerm,str_kbs),	"kbs",		"backspace key");
#ifndef key_sbeg
#define key_sbeg NULL
#endif
  (*func)(stream,"kBEG",	"&9",	TINFO, key_sbeg,		OFFSET(CurrTerm,str_kBEG),	"kBEG",		"Shifted beginning key");
#ifndef key_scancel
#define key_scancel NULL
#endif
  (*func)(stream,"kCAN",	"&0",	TINFO, key_scancel,		OFFSET(CurrTerm,str_kCAN),	"kCAN",		"Shifted cancel key");
#ifndef key_scommand
#define key_scommand NULL
#endif
  (*func)(stream,"kCMD",	"*1",	TINFO, key_scommand,		OFFSET(CurrTerm,str_kCMD),	"kCMD",		"Shifted CMD key");
#ifndef key_scopy
#define key_scopy NULL
#endif
  (*func)(stream,"kCPY",	"*2",	TINFO, key_scopy,		OFFSET(CurrTerm,str_kCPY),	"kCPY",		"Shifted CPY key");
#ifndef key_screate
#define key_screate NULL
#endif
  (*func)(stream,"kCRT",	"*3",	TINFO, key_screate,		OFFSET(CurrTerm,str_kCRT),	"kCRT",		"Shifted CRT key");
#ifndef key_sdc
#define key_sdc NULL
#endif
  (*func)(stream,"kDC",		"*4",	TINFO, key_sdc,			OFFSET(CurrTerm,str_kDC),	"kDC",		"Shifted DC key");
#ifndef key_sdl
#define key_sdl NULL
#endif
  (*func)(stream,"kDL",		"*5",	TINFO, key_sdl,			OFFSET(CurrTerm,str_kDL),	"kDL",		"Shifted DL key");
#ifndef key_send
#define key_send NULL
#endif
  (*func)(stream,"kEND",	"*7",	TINFO, key_send,		OFFSET(CurrTerm,str_kEND),	"kEND",		"Shifted END key");
#ifndef key_seol
#define key_seol NULL
#endif
  (*func)(stream,"kEOL",	"*8",	TINFO, key_seol,		OFFSET(CurrTerm,str_kEOL),	"kEOL",		"Shifted EOL key");
#ifndef key_sexit
#define key_sexit NULL
#endif
  (*func)(stream,"kEXT",	"*9",	TINFO, key_sexit,		OFFSET(CurrTerm,str_kEXT),	"kEXT",		"Shifted EXT key");
#ifndef key_sfind
#define key_sfind NULL
#endif
  (*func)(stream,"kFND",	"*0",	TINFO, key_sfind,		OFFSET(CurrTerm,str_kFND),	"kFND",		"Shifted FND key");
#ifndef key_shelp
#define key_shelp NULL
#endif
  (*func)(stream,"kHLP",	"#1",	TINFO, key_shelp,		OFFSET(CurrTerm,str_kHLP),	"kHLP",		"Shifted HLP key");
#ifndef key_shome
#define key_shome NULL
#endif
  (*func)(stream,"kHOM",	"#2",	TINFO, key_shome,		OFFSET(CurrTerm,str_kHOM),	"kHOM",		"Shifted HOM key");
#ifndef key_sic
#define key_sic NULL
#endif
  (*func)(stream,"kIC",		"#3",	TINFO, key_sic,			OFFSET(CurrTerm,str_kIC),	"kIC",		"Shifted IC key");
#ifndef key_sleft
#define key_sleft NULL
#endif
  (*func)(stream,"kLFT",	"#4",	TINFO, key_sleft,		OFFSET(CurrTerm,str_kLFT),	"kLFT",		"Shifted LFT key");
#ifndef key_smove
#define key_smove NULL
#endif
  (*func)(stream,"kMOV",	"%b",	TINFO, key_smove,		OFFSET(CurrTerm,str_kMOV),	"kMOV",		"Shifted MOV key");
#ifndef key_smessage
#define key_smessage NULL
#endif
  (*func)(stream,"kMSG",	"%a",	TINFO, key_smessage,		OFFSET(CurrTerm,str_kMSG),	"kMSG",		"Shifted MSG key");
#ifndef key_snext
#define key_snext NULL
#endif
  (*func)(stream,"kNXT",	"%c",	TINFO, key_snext,		OFFSET(CurrTerm,str_kNXT),	"kNXT",		"Shifted NXT key");
#ifndef key_soptions
#define key_soptions NULL
#endif
  (*func)(stream,"kOPT",	"%d",	TINFO, key_soptions,		OFFSET(CurrTerm,str_kOPT),	"kOPT",		"Shifted OPT key");
#ifndef key_sprint
#define key_sprint NULL
#endif
  (*func)(stream,"kPRT",	"%f",	TINFO, key_sprint,		OFFSET(CurrTerm,str_kPRT),	"kPRT",		"Shifted PRT key");
#ifndef key_sprevious
#define key_sprevious NULL
#endif
  (*func)(stream,"kPRV",	"%e",	TINFO, key_sprevious,		OFFSET(CurrTerm,str_kPRV),	"kPRV",		"Shifted PRV key");
#ifndef key_sredo
#define key_sredo NULL
#endif
  (*func)(stream,"kRDO",	"%g",	TINFO, key_sredo,		OFFSET(CurrTerm,str_kRDO),	"kRDO",		"Shifted RDO key");
#ifndef key_srsume
#define key_srsume NULL
#endif
  (*func)(stream,"kRES",	"%j",	TINFO, key_srsume,		OFFSET(CurrTerm,str_kRES),	"kRES",		"Shifted RES key");
#ifndef key_sright
#define key_sright NULL
#endif
  (*func)(stream,"kRIT",	"%i",	TINFO, key_sright,		OFFSET(CurrTerm,str_kRIT),	"kRIT",		"Shifted RIT key");
#ifndef key_sreplace
#define key_sreplace NULL
#endif
  (*func)(stream,"kRPL",	"%h",	TINFO, key_sreplace,		OFFSET(CurrTerm,str_kRPL),	"kRPL",		"Shifted RPL key");
#ifndef key_ssave
#define key_ssave NULL
#endif
  (*func)(stream,"kSAV",	"!1",	TINFO, key_ssave,		OFFSET(CurrTerm,str_kSAV),	"kSAV",		"Shifted SAV key");
#ifndef key_ssuspend
#define key_ssuspend NULL
#endif
  (*func)(stream,"kSPD",	"!2",	TINFO, key_ssuspend,		OFFSET(CurrTerm,str_kSPD),	"kSPD",		"Shifted SPD key");
#ifndef key_sundo
#define key_sundo NULL
#endif
  (*func)(stream,"kUND",	"!3",	TINFO, key_sundo,		OFFSET(CurrTerm,str_kUND),	"kUND",		"Shifted UND key");
#ifndef key_a1
#define key_a1 NULL
#endif
  (*func)(stream,"ka1",		"K1",	TINFO, key_a1,			OFFSET(CurrTerm,str_ka1),	"ka1",		"a1 key, Upper left keypad");
#ifndef key_a3
#define key_a3 NULL
#endif
  (*func)(stream,"ka3",		"K3",	TINFO, key_a3,			OFFSET(CurrTerm,str_ka3),	"ka3",		"a3 key, Upper right Key Pad");
#ifndef key_b2
#define key_b2 NULL
#endif
  (*func)(stream,"kb2",		"K2",	TINFO, key_b2,			OFFSET(CurrTerm,str_kb2),	"kb2",		"b2 key, Center key Pad");
#ifndef key_beg
#define key_beg NULL
#endif
  (*func)(stream,"kbeg",	"@1",	TINFO, key_beg,			OFFSET(CurrTerm,str_kbeg),	"kbeg",		"beg key");
#ifndef key_c1
#define key_c1 NULL
#endif
  (*func)(stream,"kc1",		"K4",	TINFO, key_c1,			OFFSET(CurrTerm,str_kc1),	"kc1",		"c1 key, Lower left keypad");
#ifndef key_c3
#define key_c3 NULL
#endif
  (*func)(stream,"kc3",		"K5",	TINFO, key_c3,			OFFSET(CurrTerm,str_kc3),	"kc3",		"c3 key, lower right keypad");
#ifndef key_cancel
#define key_cancel NULL
#endif
  (*func)(stream,"kcan",	"@2",	TINFO, key_cancel,		OFFSET(CurrTerm,str_kcan),	"kcan",		"cancel key");
#ifndef key_back_tab
#define key_back_tab NULL
#endif
  (*func)(stream,"kbtab",	"k0",	TINFO, key_back_tab,		OFFSET(CurrTerm,str_kbtab),	"kbtab",	"back tab key");
#ifndef key_cbtab
#define key_cbtab NULL
#endif
  (*func)(stream,"kcbt",	"kB",	TINFO, key_cbtab,		OFFSET(CurrTerm,str_kcbt),	"kcbt",		"back tab key");
#ifndef key_close
#define key_close NULL
#endif
  (*func)(stream,"kclo",	"@3",	TINFO, key_close,		OFFSET(CurrTerm,str_kclo),	"kclo",		"close key");
#ifndef key_command
#define key_command NULL
#endif
  (*func)(stream,"kcmd",	"@4",	TINFO, key_command,		OFFSET(CurrTerm,str_kcmd),	"kcmd",		"cmd key");  /* code "kc" ???? */
#ifndef key_command_pane
#define key_command_pane NULL
#endif
  (*func)(stream,"kcpn",	"kW",	TINFO, key_command_pane,	OFFSET(CurrTerm,str_kcpn),	"kcpn",		"Command pane key");
#ifndef key_copy
#define key_copy NULL
#endif
  (*func)(stream,"kcpy",	"@5",	TINFO, key_copy,		OFFSET(CurrTerm,str_kcpy),	"kcpy",		"cpy key");
#ifndef key_create
#define key_create NULL
#endif
  (*func)(stream,"kcrt",	"@6",	TINFO, key_create,		OFFSET(CurrTerm,str_kcrt),	"kcrt",		"create key");
#ifndef key_ctab
#define key_ctab NULL
#endif
  (*func)(stream,"kctab",	"kt",	TINFO, key_ctab,		OFFSET(CurrTerm,str_kctab),	"kctab",	"ctab key");
#ifndef key_do
#define key_do NULL
#endif
  (*func)(stream,"kdo",		"ki",	TINFO, key_do,			OFFSET(CurrTerm,str_kdo),	"kdo",		"do key");
#ifndef key_end
#define key_end NULL
#endif
  (*func)(stream,"kend",	"@7",	TINFO, key_end,			OFFSET(CurrTerm,str_kend),	"kend",		"end key"); /* code "kw" ??? */
#ifndef key_enter
#define key_enter NULL
#endif
  (*func)(stream,"kent",	"@8",	TINFO, key_enter,		OFFSET(CurrTerm,str_kent),	"kent",		"ent key");
#ifndef key_exit
#define key_exit NULL
#endif
  (*func)(stream,"kext",	"@9",	TINFO, key_exit,		OFFSET(CurrTerm,str_kext),	"kext",		"ext key");
#ifndef key_f0
#define key_f0 NULL
#endif
  (*func)(stream,"kf0",		"k0",	TINFO, key_f0,			OFFSET(CurrTerm,str_kf0),	"kf0",		"f0 key");
#ifndef key_f1
#define key_f1 NULL
#endif
  (*func)(stream,"kf1",		"k1",	TINFO, key_f1,			OFFSET(CurrTerm,str_kf1),	"kf1",		"f1 key");
#ifndef key_f2
#define key_f2 NULL
#endif
  (*func)(stream,"kf2",		"k2",	TINFO, key_f2,			OFFSET(CurrTerm,str_kf2),	"kf2",		"f2 key");
#ifndef key_f3
#define key_f3 NULL
#endif
  (*func)(stream,"kf3",		"k3",	TINFO, key_f3,			OFFSET(CurrTerm,str_kf3),	"kf3",		"f3 key");
#ifndef key_f4
#define key_f4 NULL
#endif
  (*func)(stream,"kf4",		"k4",	TINFO, key_f4,			OFFSET(CurrTerm,str_kf4),	"kf4",		"f4 key");
#ifndef key_f5
#define key_f5 NULL
#endif
  (*func)(stream,"kf5",		"k5",	TINFO, key_f5,			OFFSET(CurrTerm,str_kf5),	"kf5",		"f5 key");
#ifndef key_f6
#define key_f6 NULL
#endif
  (*func)(stream,"kf6",		"k6",	TINFO, key_f6,			OFFSET(CurrTerm,str_kf6),	"kf6",		"f6 key");
#ifndef key_f7
#define key_f7 NULL
#endif
  (*func)(stream,"kf7",		"k7",	TINFO, key_f7,			OFFSET(CurrTerm,str_kf7),	"kf7",		"f7 key");
#ifndef key_f8
#define key_f8 NULL
#endif
  (*func)(stream,"kf8",		"k8",	TINFO, key_f8,			OFFSET(CurrTerm,str_kf8),	"kf8",		"f8 key");
#ifndef key_f9
#define key_f9 NULL
#endif
  (*func)(stream,"kf9",		"k9",	TINFO, key_f9,			OFFSET(CurrTerm,str_kf9),	"kf9",		"f9 key");
#ifndef key_f10
#define key_f10 NULL
#endif
  (*func)(stream,"kf10",	"k;",	TINFO, key_f10,			OFFSET(CurrTerm,str_kf10),	"kf10",		"f10 key");
#ifndef key_f11
#define key_f11 NULL
#endif
  (*func)(stream,"kf11",	"F1",	TINFO, key_f11,			OFFSET(CurrTerm,str_kf11),	"kf11",		"f11 key");
#ifndef key_f12
#define key_f12 NULL
#endif
  (*func)(stream,"kf12",	"F2",	TINFO, key_f12,			OFFSET(CurrTerm,str_kf12),	"kf12",		"f12 key");
#ifndef key_f13
#define key_f13 NULL
#endif
  (*func)(stream,"kf13",	"F3",	TINFO, key_f13,			OFFSET(CurrTerm,str_kf13),	"kf13",		"f13 key");
#ifndef key_f14
#define key_f14 NULL
#endif
  (*func)(stream,"kf14",	"F4",	TINFO, key_f14,			OFFSET(CurrTerm,str_kf14),	"kf14",		"f14 key");
#ifndef key_f15
#define key_f15 NULL
#endif
  (*func)(stream,"kf15",	"F5",	TINFO, key_f15,			OFFSET(CurrTerm,str_kf15),	"kf15",		"f15 key");
#ifndef key_f16
#define key_f16 NULL
#endif
  (*func)(stream,"kf16",	"F6",	TINFO, key_f16,			OFFSET(CurrTerm,str_kf16),	"kf16",		"f16 key");
#ifndef key_f17
#define key_f17 NULL
#endif
  (*func)(stream,"kf17",	"F7",	TINFO, key_f17,			OFFSET(CurrTerm,str_kf17),	"kf17",		"f17 key");
#ifndef key_f18
#define key_f18 NULL
#endif
  (*func)(stream,"kf18",	"F8",	TINFO, key_f18,			OFFSET(CurrTerm,str_kf18),	"kf18",		"f18 key");
#ifndef key_f19
#define key_f19 NULL
#endif
  (*func)(stream,"kf19",	"F9",	TINFO, key_f19,			OFFSET(CurrTerm,str_kf19),	"kf19",		"f19 key");
#ifndef key_f20
#define key_f20 NULL
#endif
  (*func)(stream,"kf20",	"FA",	TINFO, key_f20,			OFFSET(CurrTerm,str_kf20),	"kf20",		"f20 key");
#ifndef key_f21
#define key_f21 NULL
#endif
  (*func)(stream,"kf21",	"FB",	TINFO, key_f21,			OFFSET(CurrTerm,str_kf21),	"kf21",		"f21 key");
#ifndef key_f22
#define key_f22 NULL
#endif
  (*func)(stream,"kf22",	"FC",	TINFO, key_f22,			OFFSET(CurrTerm,str_kf22),	"kf22",		"f22 key");
#ifndef key_f23
#define key_f23 NULL
#endif
  (*func)(stream,"kf23",	"FD",	TINFO, key_f23,			OFFSET(CurrTerm,str_kf23),	"kf23",		"f23 key");
#ifndef key_f24
#define key_f24 NULL
#endif
  (*func)(stream,"kf24",	"FE",	TINFO, key_f24,		 	OFFSET(CurrTerm,str_kf24),	"kf24",		"f24 key");
#ifndef key_f25
#define key_f25 NULL
#endif
  (*func)(stream,"kf25",	"FF",	TINFO, key_f25,			OFFSET(CurrTerm,str_kf25),	"kf25",		"f25 key");
#ifndef key_f26
#define key_f26 NULL
#endif
  (*func)(stream,"kf26",	"FG",	TINFO, key_f26,			OFFSET(CurrTerm,str_kf26),	"kf26",		"f26 key");
#ifndef key_f27
#define key_f27 NULL
#endif
  (*func)(stream,"kf27",	"FH",	TINFO, key_f27,			OFFSET(CurrTerm,str_kf27),	"kf27",		"f27 key");
#ifndef key_f28
#define key_f28 NULL
#endif
  (*func)(stream,"kf28",	"FI",	TINFO, key_f28,			OFFSET(CurrTerm,str_kf28),	"kf28",		"f28 key");
#ifndef key_f29
#define key_f29 NULL
#endif
  (*func)(stream,"kf29",	"FJ",	TINFO, key_f29,			OFFSET(CurrTerm,str_kf29),	"kf29",		"f29 key");
#ifndef key_f30
#define key_f30 NULL
#endif
  (*func)(stream,"kf30",	"FK",	TINFO, key_f30,			OFFSET(CurrTerm,str_kf30),	"kf30",		"f30 key");
#ifndef key_f31
#define key_f31 NULL
#endif
  (*func)(stream,"kf31",	"FL",	TINFO, key_f31,			OFFSET(CurrTerm,str_kf31),	"kf31",		"f31 key");
#ifndef key_f32
#define key_f32 NULL
#endif
  (*func)(stream,"kf32",	"FM",	TINFO, key_f32,			OFFSET(CurrTerm,str_kf32),	"kf32",		"f32 key");
#ifndef key_f33
#define key_f33 NULL
#endif
  (*func)(stream,"kf33",	"FN",	TINFO, key_f33,			OFFSET(CurrTerm,str_kf33),	"kf33",		"f33 key");
#ifndef key_f34
#define key_f34 NULL
#endif
  (*func)(stream,"kf34",	"FO",	TINFO, key_f34,			OFFSET(CurrTerm,str_kf34),	"kf34",		"f34 key");
#ifndef key_f35
#define key_f35 NULL
#endif
  (*func)(stream,"kf35",	"FP",	TINFO, key_f35,			OFFSET(CurrTerm,str_kf35),	"kf35",		"f35 key");
#ifndef key_f36
#define key_f36 NULL
#endif
  (*func)(stream,"kf36",	"FQ",	TINFO, key_f36,			OFFSET(CurrTerm,str_kf36),	"kf36",		"f36 key");
#ifndef key_f37
#define key_f37 NULL
#endif
  (*func)(stream,"kf37",	"FR",	TINFO, key_f37,			OFFSET(CurrTerm,str_kf37),	"kf37",		"f37 key");
#ifndef key_f38
#define key_f38 NULL
#endif
  (*func)(stream,"kf38",	"FS",	TINFO, key_f38,			OFFSET(CurrTerm,str_kf38),	"kf38",		"f38 key");
#ifndef key_f39
#define key_f39 NULL
#endif
  (*func)(stream,"kf39",	"FT",	TINFO, key_f39,			OFFSET(CurrTerm,str_kf39),	"kf39",		"f39 key");
#ifndef key_f40
#define key_f40 NULL
#endif
  (*func)(stream,"kf40",	"FU",	TINFO, key_f40,			OFFSET(CurrTerm,str_kf40),	"kf40",		"f40 key");
#ifndef key_f41
#define key_f41 NULL
#endif
  (*func)(stream,"kf41",	"FV",	TINFO, key_f41,			OFFSET(CurrTerm,str_kf41),	"kf41",		"f41 key");
#ifndef key_f42
#define key_f42 NULL
#endif
  (*func)(stream,"kf42",	"FW",	TINFO, key_f42,			OFFSET(CurrTerm,str_kf42),	"kf42",		"f42 key");
#ifndef key_f43
#define key_f43 NULL
#endif
  (*func)(stream,"kf43",	"FX",	TINFO, key_f43,			OFFSET(CurrTerm,str_kf43),	"kf43",		"f43 key");
#ifndef key_f44
#define key_f44 NULL
#endif
  (*func)(stream,"kf44",	"FY",	TINFO, key_f44,			OFFSET(CurrTerm,str_kf44),	"kf44",		"f44 key");
#ifndef key_f45
#define key_f45 NULL
#endif
  (*func)(stream,"kf45",	"FZ",	TINFO, key_f45,			OFFSET(CurrTerm,str_kf45),	"kf45",		"f45 key");
#ifndef key_f46
#define key_f46 NULL
#endif
  (*func)(stream,"kf46",	"Fa",	TINFO, key_f46,			OFFSET(CurrTerm,str_kf46),	"kf46",		"f46 key");
#ifndef key_f47
#define key_f47 NULL
#endif
  (*func)(stream,"kf47",	"Fb",	TINFO, key_f47,			OFFSET(CurrTerm,str_kf47),	"kf47",		"f47 key");
#ifndef key_f48
#define key_f48 NULL
#endif
  (*func)(stream,"kf48",	"Fc",	TINFO, key_f48,			OFFSET(CurrTerm,str_kf48),	"kf48",		"f48 key");
#ifndef key_f49
#define key_f49 NULL
#endif
  (*func)(stream,"kf49",	"Fd",	TINFO, key_f49,			OFFSET(CurrTerm,str_kf49),	"kf49",		"f49 key");
#ifndef key_f50
#define key_f50 NULL
#endif
  (*func)(stream,"kf50",	"Fe",	TINFO, key_f50,			OFFSET(CurrTerm,str_kf50),	"kf50",		"f50 key");
#ifndef key_f51
#define key_f51 NULL
#endif
  (*func)(stream,"kf51",	"Ff",	TINFO, key_f51,			OFFSET(CurrTerm,str_kf51),	"kf51",		"f51 key");
#ifndef key_f52
#define key_f52 NULL
#endif
  (*func)(stream,"kf52",	"Fg",	TINFO, key_f52,			OFFSET(CurrTerm,str_kf52),	"kf52",		"f52 key");
#ifndef key_f53
#define key_f53 NULL
#endif
  (*func)(stream,"kf53",	"Fh",	TINFO, key_f53,			OFFSET(CurrTerm,str_kf53),	"kf53",		"f53 key");
#ifndef key_f54
#define key_f54 NULL
#endif
  (*func)(stream,"kf54",	"Fi",	TINFO, key_f54,			OFFSET(CurrTerm,str_kf54),	"kf54",		"f54 key");
#ifndef key_f55
#define key_f55 NULL
#endif
  (*func)(stream,"kf55",	"Fj",	TINFO, key_f55,			OFFSET(CurrTerm,str_kf55),	"kf55",		"f55 key");
#ifndef key_f56
#define key_f56 NULL
#endif
  (*func)(stream,"kf56",	"Fk",	TINFO, key_f56,			OFFSET(CurrTerm,str_kf56),	"kf56",		"f56 key");
#ifndef key_f57
#define key_f57 NULL
#endif
  (*func)(stream,"kf57",	"Fl",	TINFO, key_f57,			OFFSET(CurrTerm,str_kf57),	"kf57",		"f57 key");
#ifndef key_f58
#define key_f58 NULL
#endif
  (*func)(stream,"kf58",	"Fm",	TINFO, key_f58,			OFFSET(CurrTerm,str_kf58),	"kf58",		"f58 key");
#ifndef key_f59
#define key_f59 NULL
#endif
  (*func)(stream,"kf59",	"Fn",	TINFO, key_f59,			OFFSET(CurrTerm,str_kf59),	"kf59",		"f59 key");
#ifndef key_f60
#define key_f60 NULL
#endif
  (*func)(stream,"kf60",	"Fo",	TINFO, key_f60,			OFFSET(CurrTerm,str_kf60),	"kf60",		"f60 key");
#ifndef key_f61
#define key_f61 NULL
#endif
  (*func)(stream,"kf61",	"Fp",	TINFO, key_f61,			OFFSET(CurrTerm,str_kf61),	"kf61",		"f61 key");
#ifndef key_f62
#define key_f62 NULL
#endif
  (*func)(stream,"kf62",	"Fq",	TINFO, key_f62,			OFFSET(CurrTerm,str_kf62),	"kf62",		"f62 key");
#ifndef key_f63
#define key_f63 NULL
#endif
  (*func)(stream,"kf63",	"Fr",	TINFO, key_f63,			OFFSET(CurrTerm,str_kf63),	"kf63",		"f63 key");
#ifndef key_find
#define key_find NULL
#endif
  (*func)(stream,"kfnd",	"@0",	TINFO, key_find,		OFFSET(CurrTerm,str_kfnd),	"kfnd",		"fnd key");
#ifndef key_help
#define key_help NULL
#endif
  (*func)(stream,"khlp",	"%1",	TINFO, key_help,		OFFSET(CurrTerm,str_khlp),	"khlp",		"hlp key"); /* code "kq" ??? */
#ifndef key_ll
#define key_ll NULL
#endif
  (*func)(stream,"kll",		"kH",	TINFO, key_ll,			OFFSET(CurrTerm,str_kll),	"kll",		"lower left key");
#ifndef key_move
#define key_move NULL
#endif
  (*func)(stream,"kmov",	"%4",	TINFO, key_move,		OFFSET(CurrTerm,str_kmov),	"kmov",		"mov key");
#ifndef key_smap_in1
#define key_smap_in1 NULL
#endif
  (*func)(stream,"kmpf1",	"Kv",	TINFO, key_smap_in1,		OFFSET(CurrTerm,str_kmpf1),	"kmpf1",	"Input for special mapped key 1");
#ifndef key_smap_out1
#define key_smap_out1 NULL
#endif
  (*func)(stream,"kmpt1",	"KV",	TINFO, key_smap_out1,		OFFSET(CurrTerm,str_kmpt1),	"kmpt1",	"Output for mapped key 1");
#ifndef key_smap_in2
#define key_smap_in2 NULL
#endif
  (*func)(stream,"kmpf2",	"Kw",	TINFO, key_smap_in2,		OFFSET(CurrTerm,str_kmpf2),	"kmpf2",	"Input for special mapped key 2");
#ifndef key_smap_out2
#define key_smap_out2 NULL
#endif
  (*func)(stream,"kmpt2",	"KW",	TINFO, key_smap_out2,		OFFSET(CurrTerm,str_kmpt2),	"kmpt2",	"Output for mapped key 2");
#ifndef key_smap_in3
#define key_smap_in3 NULL
#endif
  (*func)(stream,"kmpf3",	"Kx",	TINFO, key_smap_in3,		OFFSET(CurrTerm,str_kmpf3),	"kmpf3",	"Input for special mapped key 3");
#ifndef key_smap_out3
#define key_smap_out3 NULL
#endif
  (*func)(stream,"kmpt3",	"KX",	TINFO, key_smap_out3,		OFFSET(CurrTerm,str_kmpt3),	"kmpt3",	"Output for mapped key 3");
#ifndef key_smap_in4
#define key_smap_in4 NULL
#endif
  (*func)(stream,"kmpf4",	"Ky",	TINFO, key_smap_in4,		OFFSET(CurrTerm,str_kmpf4),	"kmpf4",	"Input for special mapped key 4");
#ifndef key_smap_out4
#define key_smap_out4 NULL
#endif
  (*func)(stream,"kmpt4",	"KY",	TINFO, key_smap_out4,		OFFSET(CurrTerm,str_kmpt4),	"kmpt4",	"Output for mapped key 4");
#ifndef key_smap_in5
#define key_smap_in5 NULL
#endif
  (*func)(stream,"kmpf5",	"Kz",	TINFO, key_smap_in5,		OFFSET(CurrTerm,str_kmpf5),	"kmpf5",	"Input for special mapped key 5");
#ifndef key_smap_out5
#define key_smap_out5 NULL
#endif
  (*func)(stream,"kmpt5",	"KZ",	TINFO, key_smap_out5,		OFFSET(CurrTerm,str_kmpt5),	"kmpt5",	"Output for mapped key 5");
#ifndef key_mark
#define key_mark NULL
#endif
  (*func)(stream,"kmrk",	"%2",	TINFO, key_mark,		OFFSET(CurrTerm,str_kmrk),	"kmrk",		"mark key");
#ifndef key_message
#define key_message NULL
#endif
  (*func)(stream,"kmsg",	"%3",	TINFO, key_message,		OFFSET(CurrTerm,str_kmsg),	"kmsg",		"msg key");
#ifndef key_next_pane
#define key_next_pane NULL
#endif
  (*func)(stream,"knpn",	"kv",	TINFO, key_next_pane,		OFFSET(CurrTerm,str_knpn),	"knpn",		"next pane key");
#ifndef key_npage
#define key_npage NULL
#endif
  (*func)(stream,"knp",		"kN",	TINFO, key_npage,		OFFSET(CurrTerm,str_knp),	"knp",		"new page key");
#ifndef key_next
#define key_next NULL
#endif
  (*func)(stream,"knxt",	"%5",	TINFO, key_next,		OFFSET(CurrTerm,str_knxt),	"knxt",		"nxt key");
#ifndef key_open
#define key_open NULL
#endif
  (*func)(stream,"kopn",	"%6",	TINFO, key_open,		OFFSET(CurrTerm,str_kopn),	"kopn",		"opn key");
#ifndef key_options
#define key_options NULL
#endif
  (*func)(stream,"kopt",	"%7",	TINFO, key_options,		OFFSET(CurrTerm,str_kopt),	"kopt",		"opt key");
#ifndef key_prev_cmd
#define key_prev_cmd NULL
#endif
  (*func)(stream,"kpcmd",	"kp",	TINFO, key_prev_cmd,		OFFSET(CurrTerm,str_kpcmd),	"kpcmd",	"prev command key");
#ifndef key_ppage
#define key_ppage NULL
#endif
  (*func)(stream,"kpp",		"kP",	TINFO, key_ppage,		OFFSET(CurrTerm,str_kpp),	"kpp",		"pp key");
#ifndef key_prev_pane
#define key_prev_pane NULL
#endif
  (*func)(stream,"kppn",	"kV",	TINFO, key_prev_pane,		OFFSET(CurrTerm,str_kppn),	"kppn",		"prev pane key");
#ifndef key_print
#define key_print NULL
#endif
  (*func)(stream,"kprt",	"%9",	TINFO, key_print,		OFFSET(CurrTerm,str_kprt),	"kprt",		"prt key");
#ifndef key_previous
#define key_previous NULL
#endif
  (*func)(stream,"kprv",	"%8",	TINFO, key_previous,		OFFSET(CurrTerm,str_kprv),	"kprv",		"prv key");
#ifndef key_quit
#define key_quit NULL
#endif
  (*func)(stream,"kpquit",	"kQ",	TINFO, key_quit,		OFFSET(CurrTerm,str_kpquit),	"kpquit",	"quit key");
#ifndef key_redo
#define key_redo NULL
#endif
  (*func)(stream,"krdo",	"%0",	TINFO, key_redo,		OFFSET(CurrTerm,str_krdo),	"krdo",		"redo key");
#ifndef key_reference
#define key_reference NULL
#endif
  (*func)(stream,"kref",	"&1",	TINFO, key_reference,		OFFSET(CurrTerm,str_kref),	"kref",		"reference key");
#ifndef key_resume
#define key_resume NULL
#endif
  (*func)(stream,"kres",	"&5",	TINFO, key_resume,		OFFSET(CurrTerm,str_kres),	"kres",		"resume key");
#ifndef key_refresh
#define key_refresh NULL
#endif
  (*func)(stream,"krfr",	"&2",	TINFO, key_refresh,		OFFSET(CurrTerm,str_krfr),	"krfr",		"refresh key");
#ifndef key_replace
#define key_replace NULL
#endif
  (*func)(stream,"krpl",	"&3",	TINFO, key_replace,		OFFSET(CurrTerm,str_krpl),	"krpl",		"replace key");
#ifndef key_restart
#define key_restart NULL
#endif
  (*func)(stream,"krst",	"&4",	TINFO, key_restart,		OFFSET(CurrTerm,str_krst),	"krst",		"restart key");
#ifndef key_save
#define key_save NULL
#endif
  (*func)(stream,"ksav",	"&6",	TINFO, key_save,		OFFSET(CurrTerm,str_ksav),	"ksav",		"save key");
#ifndef key_select
#define key_select NULL
#endif
  (*func)(stream,"kslt",	"*6",	TINFO, key_select,		OFFSET(CurrTerm,str_kslt),	"kslt",		"select key");
#ifndef key_suspend
#define key_suspend NULL
#endif
  (*func)(stream,"kspd",	"&7",	TINFO, key_suspend,		OFFSET(CurrTerm,str_kspd),	"kspd",		"suspend key");
#ifndef key_undo
#define key_undo NULL
#endif
  (*func)(stream,"kund",	"&8",	TINFO, key_undo,		OFFSET(CurrTerm,str_kund),	"kund",		"undo key");
#ifndef lab_f0
#define lab_f0 NULL
#endif
  (*func)(stream,"lf0",		"l0",	TINFO, lab_f0,		OFFSET(CurrTerm,str_lf0),	"lf0",	"labels on function key f0 inf not f0");
#ifndef lab_f1
#define lab_f1 NULL
#endif
  (*func)(stream,"lf1",		"l1",	TINFO, lab_f1,		OFFSET(CurrTerm,str_lf1),	"lf1",	"labels on function key f1 inf not f1");
#ifndef lab_f2
#define lab_f2 NULL
#endif
  (*func)(stream,"lf2",		"l2",	TINFO, lab_f2,		OFFSET(CurrTerm,str_lf2),	"lf2",	"labels on function key f2 inf not f2");
#ifndef lab_f3
#define lab_f3 NULL
#endif
  (*func)(stream,"lf3",		"l3",	TINFO, lab_f3,		OFFSET(CurrTerm,str_lf3),	"lf3",	"labels on function key f3 inf not f3");
#ifndef lab_f4
#define lab_f4 NULL
#endif
  (*func)(stream,"lf4",		"l4",	TINFO, lab_f4,		OFFSET(CurrTerm,str_lf4),	"lf4",	"labels on function key f4 inf not f4");
#ifndef lab_f5
#define lab_f5 NULL
#endif
  (*func)(stream,"lf5",		"l5",	TINFO, lab_f5,		OFFSET(CurrTerm,str_lf5),	"lf5",	"labels on function key f5 inf not f5");
#ifndef lab_f6
#define lab_f6 NULL
#endif
  (*func)(stream,"lf6",		"l6",	TINFO, lab_f6,		OFFSET(CurrTerm,str_lf6),	"lf6",	"labels on function key f6 inf not f6");
#ifndef lab_f7
#define lab_f7 NULL
#endif
  (*func)(stream,"lf7",		"l7",	TINFO, lab_f7,		OFFSET(CurrTerm,str_lf7),	"lf7",	"labels on function key f7 inf not f7");
#ifndef lab_f8
#define lab_f8 NULL
#endif
  (*func)(stream,"lf8",		"l8",	TINFO, lab_f8,		OFFSET(CurrTerm,str_lf8),	"lf8",	"labels on function key f8 inf not f8");
#ifndef lab_f9
#define lab_f9 NULL
#endif
  (*func)(stream,"lf9",		"l9",	TINFO, lab_f9,		OFFSET(CurrTerm,str_lf9),	"lf9",	"labels on function key f9 inf not f9");
#ifndef lab_f10
#define lab_f10 NULL
#endif
  (*func)(stream,"lf10",	"la",	TINFO, lab_f10,		OFFSET(CurrTerm,str_lf10),	"lf10",	"labels on function key f10 inf not f10");
#ifndef pad_char
#define pad_char NULL
#endif
  (*func)(stream,"pad",		"pc",	TINFO, pad_char,	OFFSET(CurrTerm,str_pad),	"pad",		"pad char other than NULL");
#ifndef reset_file
#define reset_file NULL
#endif
  (*func)(stream,"rf",		"rf",	TINFO, reset_file,	OFFSET(CurrTerm,str_rf),	"rf",		"name of file containing reset string");
#ifndef char_padding
#define char_padding NULL
#endif
  (*func)(stream,"rmp",		"rP",	TINFO, char_padding,	OFFSET(CurrTerm,str_rmp),	"rmp",		"char padding time if not in insert mode");
#ifndef xoff_character
#define xoff_character NULL
#endif
  (*func)(stream,"xoffc",	"XF",	TINFO, xoff_character,	OFFSET(CurrTerm,str_xoffc),	"xoffc",	"xoff character");
#ifndef xon_character
#define xon_character NULL
#endif
  (*func)(stream,"xonc",	"XN",	TINFO, xon_character,	OFFSET(CurrTerm,str_xonc),	"xonc",		"xon character");
#ifndef acs_chars
#define acs_chars NULL
#endif
  (*func)(stream,"acsc",	"ac",	TINFO, acs_chars, 	OFFSET(CurrTerm,str_acsc),	"acsc",		"Alternate char set pairs");
#ifndef key_newline
#define key_newline NULL
#endif
  (*func)(stream,"knl",		"kn",	TINFO, key_newline,    	OFFSET(CurrTerm,str_knl),	"knl",		"nl key");
#ifndef key_clear
#define key_clear NULL
#endif
  (*func)(stream,"kclr",	"kC",	TINFO, key_clear,	OFFSET(CurrTerm,str_kclr),	"kclr",		"clr key");
#ifndef key_left
#define key_left NULL
#endif
  (*func)(stream,"kcub1",	"kl",	TINFO, key_left,	OFFSET(CurrTerm,str_kcub1),	"kcub1",	"left key");
#ifndef key_down
#define key_down NULL
#endif
  (*func)(stream,"kcud1",	"kd",	TINFO, key_down,	OFFSET(CurrTerm,str_kcud1),	"kcud1",	"down key");
#ifndef key_right
#define key_right NULL
#endif
  (*func)(stream,"kcuf1",	"kr",	TINFO, key_right,	OFFSET(CurrTerm,str_kcuf1),	"kcuf1",	"right key");
#ifndef key_up
#define key_up NULL
#endif
  (*func)(stream,"kcuu1",	"ku",	TINFO, key_up,		OFFSET(CurrTerm,str_kcuu1),	"kcuu1",	"up key");
#ifndef key_dc
#define key_dc NULL
#endif
  (*func)(stream,"kdch1",	"kD",	TINFO, key_dc,		OFFSET(CurrTerm,str_kdch1),	"kdch1",	"delete key");
#ifndef key_dl
#define key_dl NULL
#endif
  (*func)(stream,"kdl1",	"kL",	TINFO, key_dl,		OFFSET(CurrTerm,str_kdl1),	"kdl1",		"dl1 key");
#ifndef key_eos
#define key_eos NULL
#endif
  (*func)(stream,"ked",		"kS",	TINFO, key_eos,		OFFSET(CurrTerm,str_ked),	"ked",		"clear to eos");
#ifndef key_eol
#define key_eol NULL
#endif
  (*func)(stream,"kel",		"kE",	TINFO, key_eol,		OFFSET(CurrTerm,str_kel),	"kel",		"clear to end of line");
#ifndef key_home
#define key_home NULL
#endif
  (*func)(stream,"khome",	"kh",	TINFO, key_home,	OFFSET(CurrTerm,str_khome),	"khome",	"home key");
#ifndef key_stab
#define key_stab NULL
#endif
  (*func)(stream,"khts",	"kT",	TINFO, key_stab,	OFFSET(CurrTerm,str_khts),	"khts",		"set tab key");
#ifndef key_ic
#define key_ic NULL
#endif
  (*func)(stream,"kich1",	"kI",	TINFO, key_ic,		OFFSET(CurrTerm,str_kich1),	"kich1",	"insert key");
#ifndef key_il
#define key_il NULL
#endif
  (*func)(stream,"kil1",	"kA",	TINFO, key_il,		OFFSET(CurrTerm,str_kil1),	"kil1",		"il key");
#ifndef key_sf
#define key_sf NULL
#endif
  (*func)(stream,"kind",	"kF",	TINFO, key_sf,		OFFSET(CurrTerm,str_kind),	"kind",		"scroll fwd/up key");
#ifndef key_sr
#define key_sr NULL
#endif
  (*func)(stream,"kri",		"kR",	TINFO, key_sr,		OFFSET(CurrTerm,str_kri),	"kri",		"scroll up key");
#ifndef key_eic
#define key_eic NULL
#endif
  (*func)(stream,"krmir",	"kM",	TINFO, key_eic,		OFFSET(CurrTerm,str_krmir),	"krmir",	"exit insert mode key");
#ifndef key_scroll_left
#define key_scroll_left NULL
#endif
  (*func)(stream,"kscl",	"kz",	TINFO, key_scroll_left,	OFFSET(CurrTerm,str_kscl),	"kscl",		"scroll left key");
#ifndef key_scroll_right
#define key_scroll_right NULL
#endif
  (*func)(stream,"kscr",	"kZ",	TINFO, key_scroll_right,OFFSET(CurrTerm,str_kscr),	"kscr",		"scroll right key");
#ifndef key_tab
#define key_tab NULL
#endif
  (*func)(stream,"ktab",	"ko",	TINFO, key_tab,		OFFSET(CurrTerm,str_ktab),	"ktab",		"tab key");
#ifndef key_catab
#define key_catab NULL
#endif
  (*func)(stream,"ktbc",	"ka",	TINFO, key_catab,	OFFSET(CurrTerm,str_ktbc),	"ktbc",		"clear all tabs key");

  (*func)(stream,"use",		NULL,	TINFO, NULL,  		OFFSET(CurrTerm,str_use),	"use",	"user other terminal description");

  /* string capabilities */

/* list higher priority ones first */
#ifndef back_tab
#define back_tab NULL
#endif
  (*func)(stream,"cbt",		"bt",	TSTRING, back_tab,		do_backtab,	"do_backtab",	"cursor back tab");
#ifndef newline
#define newline NULL
#endif
  (*func)(stream,"nel",	"nw",	TSTRING, newline,		do_newline,	"do_newline",	"beginning of next line");
#ifndef scroll_forward
#define scroll_forward NULL
#endif
  (*func)(stream,"ind",	"sf",	TSTRING, scroll_forward,	do_scroll_forward,	"do_scroll_forward",	"scroll fwd/up");
#ifndef exit_attribute_mode
#define exit_attribute_mode NULL
#endif
  (*func)(stream,"sgr0",	"me",	TSTRING, exit_attribute_mode,	do_normal,	"do_normal",	"turn off all attributes");
#ifndef bell
#define bell NULL
#endif
  (*func)(stream,"bel",	"bl",	TSTRING, bell,			do_bell,	"do_bell",	"bell");
#ifndef enter_blink_mode
#define enter_blink_mode NULL
#endif
  (*func)(stream,"blink",	"mb",	TSTRING, enter_blink_mode,	do_blink,	"do_blink",	"enter blink mode");
#ifndef enter_bold_mode
#define enter_bold_mode NULL
#endif
  (*func)(stream,"bold",	"md",	TSTRING, enter_bold_mode,	do_bold,	"do_bold",	"enter bold mode");
#ifndef cursor_invisible
#define cursor_invisible NULL
#endif
  (*func)(stream,"civis",	"vi",	TSTRING, cursor_invisible,	do_cursor_invisible,	"do_cursor_invisible",	"cursor invisible");
#ifndef clear_screen
#define clear_screen NULL
#endif
  (*func)(stream,"clear",	"cl",	TSTRING, clear_screen,		do_clear,	"do_clear",	"Clear entire screen then home");
#ifndef cursor_normal
#define cursor_normal NULL
#endif
  (*func)(stream,"cnorm",	"ve",	TSTRING, cursor_normal,		do_cursor_normal,	"do_cursor_normal",	"cursor normal");
#ifndef carriage_return
#define carriage_return NULL
#endif
  (*func)(stream,"cr",	"cr",	TSTRING, carriage_return,	do_carriage_return,	"do_carriage_return",	"carriage-return");
#ifndef change_scroll_region
#define change_scroll_region NULL
#endif
  (*func)(stream,"csr",	"cs",	TSTRING, change_scroll_region,	do_set_scroll_region,	"do_set_scroll_region",	"change scroll region");
#ifndef parm_left_cursor
#define parm_left_cursor NULL
#endif
  (*func)(stream,"cub",	"LE",	TSTRING, parm_left_cursor,	do_curse_back,	"do_curse_back",	"Move Left N places");
#ifndef cursor_left
#define cursor_left NULL
#endif
  (*func)(stream,"cub1",	"le",	TSTRING, cursor_left,		do_curse_back,	"do_curse_back",	"cursor back 1");
#ifndef parm_down_cursor
#define parm_down_cursor NULL
#endif
  (*func)(stream,"cud",	"DO",	TSTRING, parm_down_cursor,	do_curse_down,	"do_curse_down",	"Move down N places");
#ifndef cursor_down
#define cursor_down NULL
#endif
  (*func)(stream,"cud1",	"do",	TSTRING, cursor_down,		do_curse_down,	"do_curse_down",	"cursor down 1");
#ifndef parm_right_cursor
#define parm_right_cursor NULL
#endif
  (*func)(stream,"cuf",	"RI",	TSTRING, parm_right_cursor,	do_curse_forward,	"do_curse_forward",	"Move right N places");
#ifndef cursor_right
#define cursor_right NULL
#endif
  (*func)(stream,"cuf1",	"nd",	TSTRING, cursor_right,		do_curse_forward,	"do_curse_forward",	"cursor forward 1");
#ifndef cursor_address
#define cursor_address NULL
#endif
  (*func)(stream,"cup",	"cm",	TSTRING, cursor_address,	do_set_cursor,	"do_set_cursor",	"Cursor to X/Y");
#ifndef parm_up_cursor
#define parm_up_cursor NULL
#endif
  (*func)(stream,"cuu",	"UP",	TSTRING, parm_up_cursor,	do_curse_up,	"do_curse_up",	"Move up N places");
#ifndef cursor_up
#define cursor_up NULL
#endif
  (*func)(stream,"cuu1",	"up",	TSTRING, cursor_up,		do_curse_up,	"do_curse_up",	"cursor up 1");
#ifndef cursor_visible
#define cursor_visible NULL
#endif
  (*func)(stream,"cvvis",	"vs",	TSTRING, cursor_visible,	do_cursor_brighter,	"do_cursor_brighter",	"cursor brighter");
#ifndef parm_dch
#define parm_dch NULL
#endif
  (*func)(stream,"dch",	"DC",	TSTRING, parm_dch,		do_delete_chars,	"do_delete_chars",	"delete N chars");
#ifndef delete_character
#define delete_character NULL
#endif
  (*func)(stream,"dch1",	"dc",	TSTRING, delete_character,	do_delete_chars,	"do_delete_chars",	"delete 1 char");
#ifndef enter_dim_mode
#define enter_dim_mode NULL
#endif
  (*func)(stream,"dim",	"mh",	TSTRING, enter_dim_mode,	do_dim,	"do_dim",	"dim");
#ifndef parm_delete_line
#define parm_delete_line NULL
#endif
  (*func)(stream,"dl",	"DL",	TSTRING, parm_delete_line,	do_delete_line,	"do_delete_line",	"delete N lines ,shift up lines below");
#ifndef delete_line
#define delete_line NULL
#endif
  (*func)(stream,"dl1",	"dl",	TSTRING, delete_line,		do_delete_line,	"do_delete_line",	"delete curr line ,shift up lines below");
#ifndef dis_status_line
#define dis_status_line NULL
#endif
  (*func)(stream,"dsl",	"ds",	TSTRING, dis_status_line,	do_display_status,	"do_display_status",	"display status line");
#ifndef erase_chars
#define erase_chars NULL
#endif
  (*func)(stream,"ech",	"ec",	TSTRING, erase_chars,		do_erase_chars,	"do_erase_chars",	"Erase N characters without moving cursor");
#ifndef clr_eos
#define clr_eos NULL
#endif
  (*func)(stream,"ed",	"cd",	TSTRING, clr_eos,		do_clear_to_eos,	"do_clear_to_eos",	"clear to end of display ,no move");
#ifndef clr_eol
#define clr_eol NULL
#endif
  (*func)(stream,"el",	"ce",	TSTRING, clr_eol,		do_clear_to_eol,	"do_clear_to_eol",	"clear to eol no move");
#ifndef clr_bol
#define clr_bol NULL
#endif
  (*func)(stream,"eli",	"cb",	TSTRING, clr_bol,		do_clear_to_bol,	"do_clear_to_bol",	"clear bol to curpos ,no move");
/*(*func)(stream,"el1",	"cb",	TSTRING, clr_bol,		do_clear_to_bol,	"do_clear_to_bol",	"clear bol to curpos ,no mv");*/
#ifndef ena_acs
#define ena_acs NULL
#endif
  (*func)(stream,"enacs",	"eA",	TSTRING, ena_acs,		do_enable_altchar_mode,	"do_enable_altchar_mode",	"enable alternate char set");
#ifndef form_feed
#define form_feed NULL
#endif
  (*func)(stream,"ff",	"ff",	TSTRING, form_feed,		do_formfeed,	"do_formfeed",	"form feed");
#ifndef flash_screen
#define flash_screen NULL
#endif
  (*func)(stream,"flash",	"vb",	TSTRING, flash_screen,		do_visible_bell,	"do_visible_bell",	"visible bell");
#ifndef font_0
#define font_0 NULL
#endif
  (*func)(stream,"font0",	"f0",	TSTRING, font_0,		do_font0,	"do_font0",	"Select font 0");
#ifndef font_1
#define font_1 NULL
#endif
  (*func)(stream,"font1",	"f1",	TSTRING, font_1,		do_font1,	"do_font1",	"Select font 1");
#ifndef font_2
#define font_2 NULL
#endif
  (*func)(stream,"font2",	"f2",	TSTRING, font_2,		do_font2,	"do_font2",	"Select font 2");
#ifndef font_3
#define font_3 NULL
#endif
  (*func)(stream,"font3",	"f3",	TSTRING, font_3,		do_font3,	"do_font3",	"Select font 3");
#ifndef font_4
#define font_4 NULL
#endif
  (*func)(stream,"font4",	"f4",	TSTRING, font_4,		do_font4,	"do_font4",	"Select font 4");
#ifndef font_5
#define font_5 NULL
#endif
  (*func)(stream,"font5",	"f5",	TSTRING, font_5,		do_font5,	"do_font5",	"Select font 5");
#ifndef font_6
#define font_6 NULL
#endif
  (*func)(stream,"font6",	"f6",	TSTRING, font_6,		do_font6,	"do_font6",	"Select font 6");
#ifndef font_7
#define font_7 NULL
#endif
  (*func)(stream,"font7",	"f7",	TSTRING, font_7,		do_font7,	"do_font7",	"Select font 7");
#ifndef from_status_line
#define from_status_line NULL
#endif
  (*func)(stream,"fsl",	"fs",	TSTRING, from_status_line,	do_return_from_status,	"do_return_from_status",	"return from status line");
#ifndef down_half_line
#define down_half_line NULL
#endif
  (*func)(stream,"hd",	"hd",	TSTRING, down_half_line,	do_cursor_down_half_line,	"do_cursor_down_half_line",	"cursor down half line");
#ifndef cursor_home
#define cursor_home NULL
#endif
  (*func)(stream,"home",	"ho",	TSTRING, cursor_home,		do_home,	"do_home",	"cursor up left corner");
#ifndef column_address
#define column_address NULL
#endif
  (*func)(stream,"hpa",	"ch",	TSTRING, column_address,	do_set_cursor_column,	"do_set_cursor_column",	"Move to column N");
#ifndef tab
#define tab NULL
#endif
  (*func)(stream,"ht",	"ta",	TSTRING, tab,			do_tab,	"do_tab",	"hardware tab");
#ifndef set_tab
#define set_tab NULL
#endif
  (*func)(stream,"hts",	"st",	TSTRING, set_tab,		do_set_tab_stop,	"do_set_tab_stop",	"set tab stops");
#ifndef up_half_line
#define up_half_line NULL
#endif
  (*func)(stream,"hu",	"hu",	TSTRING, up_half_line,		do_cursor_up_half_line,	"do_cursor_up_half_line",	"cursor up half line");
#ifndef parm_ich
#define parm_ich NULL
#endif
  (*func)(stream,"ich",	"IC",	TSTRING, parm_ich,		do_insert_chars,	"do_insert_chars",	"insert N characters");
#ifndef insert_character
#define insert_character NULL
#endif
  (*func)(stream,"ich1",	"ic",	TSTRING, insert_character,	do_insert_chars,	"do_insert_chars",	"insert following char");
#ifndef parm_insert_line
#define parm_insert_line NULL
#endif
  (*func)(stream,"il",	"AL",	TSTRING, parm_insert_line,	do_insert_line,	"do_insert_line",	"insert N blank lines above curs at prev nl");
#ifndef insert_line
#define insert_line NULL
#endif
  (*func)(stream,"il1",	"al",	TSTRING, insert_line,		do_insert_line,	"do_insert_line",	"insert blank above curs at start new line");
#ifndef parm_index
#define parm_index NULL
#endif
  (*func)(stream,"indn",	"SF",	TSTRING, parm_index,		do_scroll_forward,	"do_scroll_forward",	"scroll forward/up N lines");
#ifndef enter_secure_mode
#define enter_secure_mode NULL
#endif
  (*func)(stream,"invis",	"mk",	TSTRING, enter_secure_mode,	do_invisible,	"do_invisible",	"enter_secure_mode");
#ifndef init_1string
#define init_1string NULL
#endif
  (*func)(stream,"is1",		"i1",	TSTRING, init_1string,		do_reset,	"do_reset",		"secondary term init string");
#ifndef init_2string
#define init_2string NULL
#endif
/*  (*func)(stream,"is2",	"i2",	TSTRING, init_2string,		do_reset,	"do_reset",	"Main Term init string"); */
  (*func)(stream,"is2",	"is",	TSTRING, init_2string,		do_reset,	"do_reset",	"Main Term init string");
#ifndef init_3string
#define init_3string NULL
#endif
  (*func)(stream,"is3",		"i3",	TSTRING, init_3string,		do_reset,	"do_reset",		"Secondary term init string");
#ifndef cursor_to_ll
#define cursor_to_ll NULL
#endif
  (*func)(stream,"ll",	"ll",	TSTRING, cursor_to_ll,		do_lower_left,	"do_lower_left",	"Move to lower left");
#ifndef clear_margins
#define clear_margins NULL
#endif
  (*func)(stream,"mgc",	"MC",	TSTRING, clear_margins,		do_clear_soft_margins,	"do_clear_soft_margins",	"clear left and right soft margins");
#ifndef pkey_key
#define pkey_key NULL
#endif
  (*func)(stream,"pfkey",	"pk",	TSTRING, pkey_key,		do_program_type,	"do_program_type",	"Program funct key #1 to type string #2");
#ifndef pkey_local
#define pkey_local NULL
#endif
  (*func)(stream,"pfloc",	"pl",	TSTRING, pkey_local,		do_program_local,	"do_program_local",	"Program funct key #1 to execute string #2");
#ifndef pkey_xmit
#define pkey_xmit NULL
#endif
  (*func)(stream,"pfx",	"px",	TSTRING, pkey_xmit,		do_program_xmit,	"do_program_xmit",	"Program funct key #1 to transmit string #2");
#ifndef plab_norm
#define plab_norm NULL
#endif
  (*func)(stream,"pln",	"pn",	TSTRING, plab_norm,		do_program_label,	"do_program_label",	"Program label #1 to show string #2");
#ifndef enter_protected_mode
#define enter_protected_mode NULL
#endif
  (*func)(stream,"prot",	"mp",	TSTRING, enter_protected_mode,	do_protect,	"do_protect",	"Enter protected mode");
#ifndef restore_cursor
#define restore_cursor NULL
#endif
  (*func)(stream,"rc",	"rc",	TSTRING, restore_cursor,	do_restore_cursor,	"do_restore_cursor",	"restore cursor from saved pos");
#ifndef repeat_char
#define repeat_char NULL
#endif
  (*func)(stream,"rep",	"rp",	TSTRING, repeat_char,		do_repeat_char,	"do_repeat_char",	"char #1 is repeated #2 times");
#ifndef enter_reverse_mode
#define enter_reverse_mode NULL
#endif
  (*func)(stream,"rev",	"mr",	TSTRING, enter_reverse_mode,	do_reverse,	"do_reverse",	"enter reverse video mode");
#ifndef req_for_input
#define req_for_input NULL
#endif
  (*func)(stream,"rfi",	"RF",	TSTRING, req_for_input,		do_request_for_input,	"do_request_for_input",	"send next char (for pty)");
#ifndef scroll_reverse
#define scroll_reverse NULL
#endif
  (*func)(stream,"ri",	"sr",	TSTRING, scroll_reverse,	do_scroll_reverse,	"do_scroll_reverse",	"scroll text down 1 line");
#ifndef parm_rindex
#define parm_rindex NULL
#endif
  (*func)(stream,"rin",	"SR",	TSTRING, parm_rindex,		do_scroll_reverse,	"do_scroll_reverse",	"scroll text down N lines");
#ifndef exit_alt_charset_mode
#define exit_alt_charset_mode NULL
#endif
  (*func)(stream,"rmacs",	"ae",	TSTRING, exit_alt_charset_mode,	do_noaltcharset,	"do_noaltcharset",	"end alt charset mode");
#ifndef exit_am_mode
#define exit_am_mode NULL
#endif
  (*func)(stream,"rmam",	"RA",	TSTRING, exit_am_mode,		do_exit_automatic_margin_mode,	"do_exit_automatic_margin_mode",	"turn off automatic margins");
#ifndef exit_ca_mode
#define exit_ca_mode NULL
#endif
  (*func)(stream,"rmcup",	"te",	TSTRING, exit_ca_mode,		do_exit_cursor_addressing_mode,	"do_exit_cursor_addressing_mode",	"End programs that use cup");
#ifndef exit_delete_mode
#define exit_delete_mode NULL
#endif
  (*func)(stream,"rmdc",	"ed",	TSTRING, exit_delete_mode,	do_exit_delete_mode,	"do_exit_delete_mode",	"exit delete mode");
#ifndef exit_insert_mode
#define exit_insert_mode NULL
#endif
  (*func)(stream,"rmir",	"ei",	TSTRING, exit_insert_mode,	do_exit_insert_mode,	"do_exit_insert_mode",	"exit insert mode");
#ifndef keypad_local
#define keypad_local NULL
#endif
  (*func)(stream,"rmkx",	"ke",	TSTRING, keypad_local,		do_stop_keypad,	"do_stop_keypad",	"end keypad transmit mode");
#ifndef label_off
#define label_off NULL
#endif
  (*func)(stream,"rmln",	"LF",	TSTRING, label_off,		do_disable_soft_labels,	"do_disable_soft_labels",	"turn off soft labels");
#ifndef meta_off
#define meta_off NULL
#endif
  (*func)(stream,"rmm",	"mo",	TSTRING, meta_off,		do_exit_meta_mode,	"do_exit_meta_mode",	"turn off meta mode");
#ifndef exit_standout_mode
#define exit_standout_mode NULL
#endif
  (*func)(stream,"rmso",	"se",	TSTRING, exit_standout_mode,	do_nostandout,	"do_nostandout",	"exit standout mode");
#ifndef exit_underline_mode
#define exit_underline_mode NULL
#endif
  (*func)(stream,"rmul",	"ue",	TSTRING, exit_underline_mode,	do_nounderline,	"do_nounderline",	"exit underline mode");
#ifndef exit_xon_mode
#define exit_xon_mode NULL
#endif
  (*func)(stream,"rmxon",	"RX",	TSTRING, exit_xon_mode,		do_exit_xon_xoff_mode,	"do_exit_xon_xoff_mode",	"exit xon/xoff mode");
#ifndef reset_1string
#define reset_1string NULL
#endif
  (*func)(stream,"rs1",	"r1",	TSTRING, reset_1string,		do_reset,	"do_reset",	"reset term completely to sane modes");
#ifndef reset_2string
#define reset_2string NULL
#endif
  (*func)(stream,"rs2",	"r2",	TSTRING, reset_2string,		do_reset,	"do_reset",	"reset term completely to sane modes");
#ifndef reset_3string
#define reset_3string NULL
#endif
  (*func)(stream,"rs3",	"r3",	TSTRING, reset_3string,		do_reset,	"do_reset",	"reset term completely to sane modes");
#ifndef save_cursor
#define save_cursor NULL
#endif
  (*func)(stream,"sc",	"sc",	TSTRING, save_cursor,		do_save_cursor,	"do_save_cursor",	"save cursor");
#ifndef set_attributes
#define set_attributes NULL
#endif
  (*func)(stream,"sgr",	"sa",	TSTRING, set_attributes,	do_sgr,	"do_sgr",	"define video attributes");
#ifndef enter_alt_charset_mode
#define enter_alt_charset_mode NULL
#endif
  (*func)(stream,"smacs",	"as",	TSTRING, enter_alt_charset_mode,do_altcharset,	"do_altcharset",	"enter alt charset mode");
#ifndef enter_am_mode
#define enter_am_mode NULL
#endif
  (*func)(stream,"smam",	"SA",	TSTRING, enter_am_mode,		do_enter_automatic_margin_mode,	"do_enter_automatic_margin_mode",	"turn on automatic margins");
#ifndef enter_ca_mode
#define enter_ca_mode NULL
#endif
  (*func)(stream,"smcup",	"ti",	TSTRING, enter_ca_mode,		do_enter_cursor_addressing_mode,	"do_enter_cursor_addressing_mode",	"Set cursor addressing mode (cup)");
#ifndef enter_delete_mode
#define enter_delete_mode NULL
#endif
  (*func)(stream,"smdc",	"dm",	TSTRING, enter_delete_mode,	do_enter_delete_mode,	"do_enter_delete_mode",	"enter delete mode");
#ifndef set_left_margin
#define set_left_margin NULL
#endif
  (*func)(stream,"smgl",	"ML",	TSTRING, set_left_margin,	do_set_left_margin,	"do_set_left_margin",	"Set soft left margin");
#ifndef set_right_margin
#define set_right_margin NULL
#endif
  (*func)(stream,"smgr",	"MR",	TSTRING, set_right_margin,	do_set_right_margin,	"do_set_right_margin",	"Set soft right margin");
#ifndef enter_insert_mode
#define enter_insert_mode NULL
#endif
  (*func)(stream,"smir",	"im",	TSTRING, enter_insert_mode,	do_enter_insert_mode,	"do_enter_insert_mode",	"enter insert mode");
#ifndef keypad_xmit
#define keypad_xmit NULL
#endif
  (*func)(stream,"smkx",	"ks",	TSTRING, keypad_xmit,		do_start_keypad,	"do_start_keypad",	"enter keypad transmit mode");
#ifndef label_on
#define label_on NULL
#endif
  (*func)(stream,"smln",	"LO",	TSTRING, label_on,		do_enable_soft_labels,	"do_enable_soft_labels",	"Turn on soft labels");
#ifndef meta_on
#define meta_on NULL
#endif
  (*func)(stream,"smm",	"mm",	TSTRING, meta_on,		do_enter_meta_mode,	"do_enter_meta_mode",	"Enter Meta mode");
#ifndef enter_standout_mode
#define enter_standout_mode NULL
#endif
  (*func)(stream,"smso",	"so",	TSTRING, enter_standout_mode,	do_standout,	"do_standout",	"Enter standout mode");
#ifndef enter_underline_mode
#define enter_underline_mode NULL
#endif
  (*func)(stream,"smul",	"us",	TSTRING, enter_underline_mode,	do_underline,	"do_underline",	"Enter underline mode");
#ifndef enter_xon_mode
#define enter_xon_mode NULL
#endif
  (*func)(stream,"smxon",	"SX",	TSTRING, enter_xon_mode,	do_enter_xon_xoff_mode,	"do_enter_xon_xoff_mode",	"enter xon mode");
#ifndef clear_all_tabs
#define clear_all_tabs NULL
#endif
  (*func)(stream,"tbc",	"ct",	TSTRING, clear_all_tabs,	do_clear_tabs,	"do_clear_tabs",	"clear tab stops");
#ifndef to_status_line
#define to_status_line NULL
#endif
  (*func)(stream,"tsl",	"ts",	TSTRING, to_status_line,	do_go_to_status,	"do_go_to_status",	"Move column #1 in status line");
#ifndef underline_char
#define underline_char NULL
#endif
  (*func)(stream,"uc",	"uc",	TSTRING, underline_char,	do_underline_char,	"do_underline_char",	"Undersocore one char and move past it");
#ifndef row_address
#define row_address NULL
#endif
  (*func)(stream,"vpa",	"cv",	TSTRING, row_address,		do_set_cursor_row,	"do_set_cursor_row",	"Move to line N");
#ifndef set_window
#define set_window NULL
#endif
  (*func)(stream,"wind",	"wi",	TSTRING, set_window,	do_set_window,	"do_set_window",		"Current window is #1-#2 cols #3-#4");
#ifndef print_screen
#define print_screen NULL
#endif
  (*func)(stream,"mc0",		"ps",	TSTRING, print_screen,	do_print_screen,	"do_print_screen",		"print screen");
#ifndef prtr_off
#define prtr_off NULL
#endif
  (*func)(stream,"mc4",		"pf",	TSTRING, prtr_off,	do_printer_off,	"do_printer_off",		"turn printer off");
#ifndef prtr_on
#define prtr_on NULL
#endif
  (*func)(stream,"mc5",		"po",	TSTRING, prtr_on,	do_printer_on,	"do_printer_on",		"turn printer on");
#ifndef prtr_non
#define prtr_non NULL
#endif
  (*func)(stream,"mc5p",	"pO",	TSTRING, prtr_non,	do_print_nbytes,	"do_print_nbytes",		"turn printer on for N bytes");

  (*func)(stream,"NOOP", 	"NOOP",	TSTRING, NULL,		do_nothing,		"do_nothing",		"");
  (*func)(stream,"VTMODES",  "VTMODES",	TSTRING, NULL,		do_VTModes,		"do_VTModes",		"");

  (*func)(stream,"HPDC2",  "HPDC2",	TSTRING, NULL,		do_HPDC2,		"do_HPDC2",		"");
  (*func)(stream,"HPSHAKE",  "HPSHAKE",	TSTRING, NULL,		do_HPSHAKE,		"do_HPSHAKE",		"");
  (*func)(stream,"HPBLOCK",  "HPBLOCK",	TSTRING, NULL,		do_HPBLOCKMODE,		"do_HPBLOCKMODE",		"");
  (*func)(stream,"HPPAGE",  "HPPAGE",	TSTRING, NULL,		do_HPPAGE,		"do_HPPAGE",		"");
  (*func)(stream,"HPNOPAGE",  "HPNOPAGE",	TSTRING, NULL,		do_HPNOPAGE,		"do_HPNOPAGE",		"");
  (*func)(stream,"HPPAGEMODE",  "HPPAGEMODE",	TSTRING, NULL,		do_HPPAGEMODE,		"do_HPPAGEMODE",		"");
  (*func)(stream,"HPEOLWRAP",  "HPEOLWRAP",	TSTRING, NULL,		do_HPEOLWRAP,		"do_HPEOLWRAP",		"");
  (*func)(stream,"HPSPOW",  "HPSPOW",	TSTRING, NULL,		do_HPSPOW,		"do_HPSPOW",		"");
  (*func)(stream,"HPXMITFUNS",  "HPXMITFUNS",	TSTRING, NULL,		do_HPXMITFUNS,		"do_HPXMITFUNS",		"");
  (*func)(stream,"HPAUTOKBDLOCK",  "HPAUTOKBDLOCK",	TSTRING, NULL,		do_HPAUTOKBDLOCK,		"do_HPAUTOKBDLOCK",		"");
  (*func)(stream,"HPAUTOLINEFEED",  "HPAUTOLINEFEED",	TSTRING, NULL,		do_HPAUTOLINEFEED,		"do_HPAUTOLINEFEED",		"");
  (*func)(stream,"HPCAPSLOCK",  "HPCAPSLOCK",	TSTRING, NULL,		do_HPCAPSLOCK,		"do_HPCAPSLOCK",		"");
  (*func)(stream,"HPKBDLOCK",  "HPKBDLOCK",	TSTRING, NULL,		do_HPKBDLOCK,		"do_HPKBDLOCK",		"");
  (*func)(stream,"HPKBDUNLOCK",  "HPKBDUNLOCK",	TSTRING, NULL,		do_HPKBDUNLOCK,		"do_HPKBDUNLOCK",		"");
  (*func)(stream,"HPMEMLOCK",  "HPMEMLOCK",	TSTRING, NULL,		do_HPMEMLOCK,		"do_HPMEMLOCK",		"");
  (*func)(stream,"HPMEMUNLOCK",  "HPMEMUNLOCK",	TSTRING, NULL,		do_HPMEMUNLOCK,		"do_HPMEMUNLOCK",		"");
  (*func)(stream,"HPFORMAT",  "HPFORMAT",	TSTRING, NULL,		do_HPFORMAT,		"do_HPFORMAT",		"");
  (*func)(stream,"HPNOFORMAT",  "HPNOFORMAT",	TSTRING, NULL,		do_HPNOFORMAT,		"do_HPNOFORMAT",		"");
  (*func)(stream,"HPDISPFUNS",  "HPDISPFUNS",	TSTRING, NULL,		do_HPDISPFUNS,		"do_HPDISPFUNS",		"");
  (*func)(stream,"HPNODISPFUNS",  "HPNODISPFUNS",	TSTRING, NULL,		do_HPNODISPFUNS,		"do_HPNODISPFUNS",		"");
  (*func)(stream,"HPSTATUS1",  "HPSTATUS1",	TSTRING, NULL,		do_HPSTATUS1,		"do_HPSTATUS1",		"");
  (*func)(stream,"HPSTATUS2",  "HPSTATUS2",	TSTRING, NULL,		do_HPSTATUS2,		"do_HPSTATUS2",		"");
  (*func)(stream,"HPDEVICEID",  "HPDEVICEID",	TSTRING, NULL,		do_HPDEVICEID,		"do_HPDEVICEID",		"");
  (*func)(stream,"HPMODES",  "HPMODES",	TSTRING, NULL,		do_HPMODES,		"do_HPMODES",		"");
  (*func)(stream,"HPKEYS",  "HPKEYS",	TSTRING, NULL,		do_HPKEYS,		"do_HPKEYS",		"");
  (*func)(stream,"HPNOKEYS",  "HPNOKEYS",	TSTRING, NULL,		do_HPNOKEYS,		"do_HPNOKEYS",		"");
  (*func)(stream,"HPAUTOTERM",  "HPAUTOTERM",	TSTRING, NULL,		do_HPAUTOTERM,		"do_HPAUTOTERM",		"");
  (*func)(stream,"HPCLEARTERM",  "HPCLEARTERM",	TSTRING, NULL,		do_HPCLEARTERM,		"do_HPCLEARTERM",		"");
  (*func)(stream,"HPATTR",  "HPATTR",	TSTRING, NULL,		do_HPATTR,		"do_HPATTR",		"");

  (*func)(stream,"CRNL", 	 "CRNL",	TSTRING, NULL,		do_CRNL_on,		"do_CRNL_on",		"");
  (*func)(stream,"NOCRNL",  "NOCRNL",	TSTRING, NULL,		do_CRNL_off,		"do_CRNL_off",		"");
  (*func)(stream,"ECHO", 	 "ECHO",	TSTRING, NULL,		do_ECHO_on,		"do_ECHO_on",		"");
  (*func)(stream,"NOECHO",  "NOECHO",	TSTRING, NULL,		do_ECHO_off,		"do_ECHO_off",		"");
  (*func)(stream,"TABSPACE","TABSPACE",	TSTRING, NULL,		do_TABSPACE_on,		"do_TABSPACE_on",	"");
  (*func)(stream,"NOTABSPACE","NOTABSPACE",TSTRING, NULL,		do_TABSPACE_off,	"do_TABSPACE_off",	"");


  (*func)(stream,"CLRLN",	 "CLRLN",	TSTRING, NULL,		do_clear_line,		"do_clear_line",	"");
  (*func)(stream,"CLR2BOS", "CLR2BOS",	TSTRING, NULL,		do_clear_to_bos,	"do_clear_to_bos",	"");
  (*func)(stream,"NOALTCHR", "NOALTCHR",	TSTRING, NULL,	do_disable_altchar_mode,"do_disable_altchar_mode",	"");
  (*func)(stream,"NOBLINK",  "NOBLINK",	TSTRING, NULL,		do_noblink,		"do_noblink",		"");
  (*func)(stream,"NOBOLD",   "NOBOLD",	TSTRING, NULL,		do_nobold,		"do_nobold",		"");
  (*func)(stream,"NODIM",    "NODIM",	TSTRING, NULL,		do_nodim,		"do_nodim",		"");
  (*func)(stream,"NOSTATLN", "NOSTATLN",	TSTRING, NULL,		do_nodisplay_status,	"do_nodisplay_status",	"");
  (*func)(stream,"NOPROTECT","NOPROTECT",	TSTRING, NULL,		do_noprotect,		"do_noprotect",		"");
  (*func)(stream,"NOREVERSE","NOREVERSE",	TSTRING, NULL,		do_noreverse,		"do_noreverse",		"");
  (*func)(stream,"NOWRAP",	 "NOWRAP",	TSTRING, NULL,		do_nowrap,		"do_nowrap",		"");
  (*func)(stream,"WRAP",	 "WRAP",	TSTRING, NULL,		do_wrap,		"do_wrap",		"");
};



