#ifndef _StrUtil_h_
#define _StrUtil_h_

/*
 * StrUtil.h - utility routines for Strings
 *
 * -----------------------------------------------------------------------------
 * Copyright 1993 Allan Brighton.
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies.  Allan
 * Brighton make no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 * -----------------------------------------------------------------------------
 */


#include <iostream.h>
#include <OS/string.h>


// stream output
ostream& operator<<(ostream& os, const String& s);

// concat strings
CopyString operator+(const String& s1, const String& s2);

// standard filename operations
String basename(const String&);
String dirname(const String&);

// convert int to string
CopyString itos(int i);

#endif _StrUtil_h_
