#include <tk.h>
#include "bltConfig.h"


/*
 *----------------------------------------------------------------------
 *
 * Blt_FindCmd --
 *
 *      Given the name of a command, return a pointer to the
 *      clientData field of the command.
 *
 * Results:
 *      A standard TCL result. If the command is found, TCL_OK
 *	is returned and clientDataPtr points to the clientData
 *	field of the command (if the clientDataPtr in not NULL).
 *
 * Side effects:
 *      If the command is found, clientDataPtr is set to the address
 *	of the clientData of the command.  If not found, an error
 *	message is left in interp->result.
 *
 *----------------------------------------------------------------------
 */

int
Blt_FindCmd(interp, cmdName, clientDataPtr)
    Tcl_Interp *interp;		/* Interpreter in which to look. */
    char *cmdName;		/* Name of desired command */
    ClientData *clientDataPtr;
{
    Tcl_CmdInfo info;

    if (!Tcl_GetCommandInfo(interp, cmdName, &info)) {
	Tcl_AppendResult(interp, "can't find command \"", cmdName, "\"",
	    (char *)NULL);
	return TCL_ERROR;
    }
    if (clientDataPtr != NULL) {
	*clientDataPtr = info.clientData;
    }
    return TCL_OK;
}


/*
 *----------------------------------------------------------------------
 *
 * Blt_OptionChanged --
 *
 *      Given the specs and offsets of a Tk_ConfigSpec structure
 *      indicates if any of the requested options have changed.
b *
 * Results:
 *      Returns 1 if one of the options has changed, 0 otherwise.
 *
 *----------------------------------------------------------------------
 */

int
Blt_OptionChanged(specs, offsets, numOffsets)
    Tk_ConfigSpec specs[];
    int offsets[];
    int numOffsets;
{
    register Tk_ConfigSpec *specPtr;
    register int i;

    for (specPtr = specs; specPtr->type != TK_CONFIG_END; specPtr++) {
	for (i = 0; i < numOffsets; i++) {
	    if ((offsets[i] == specPtr->offset) &&
		(specPtr->specFlags & TK_CONFIG_OPTION_SPECIFIED)) {
		return 1;
	    }
	}
    }
    return 0;
}

#ifndef HAVE_STRDUP
/*
 *----------------------------------------------------------------------
 *
 * strdup --
 *
 *      Create a copy of the string from heap storage.
 *
 * Results:
 *      Returns a pointer to the need string copy.
 *
 *----------------------------------------------------------------------
 */
char *
strdup(string)
    char *string;
{
    char *newPtr;

    newPtr = (char *)malloc(sizeof(char) * (strlen(string) + 1));

    strcpy(newPtr, string);
    return (newPtr);
}

#endif /*HAVE_STRDUP*/
