/*  _ __ ___ _
 * | |\ /  /| |  $Id: OtclObjMgr.C,v 1.2 1995/03/03 10:26:04 deans Exp $
 * | | /  / | |  Copyright (C) 1995 IXI Limited.
 * |_|/__/_\|_|  IXI Limited, Cambridge, England.
 *
 * Component   : OtclObjMgr.C
 *
 * Author      : Dean Sheehan (deans@x.co.uk)
 *
 * Description : Contains the implementation for OtclObjMgr and abstract class
 *               and OtclObjCmdMgr class that used Tcl commands to map
 *               to Object Tcl objects.
 *
 * License     :
			Object Tcl License & Copyright
			------------------------------

IXI Object Tcl software, both binary and source (hereafter, Software) is copyrighted by IXI Limited (IXI), and ownership remains with IXI. 

IXI grants you (herafter, Licensee) a license to use the Software for academic, research and internal business purposes only, without a fee. Licensee may distribute the binary and source code (if required) to third parties provided that the copyright notice and this statement appears on all copies and that no charge is associated with such copies. 

Licensee may make derivative works. However, if Licensee distributes any derivative work based on or derived from the Software, then Licensee will (1) notify IXI regarding its distribution of the derivative work, and (2) clearly notify users that such derivative work is a modified version and not the original IXI Object Tcl distributed by IXI. IXI strongly recommends that Licensee provide IXI the right to incorporate such modifications into future releases of the Software under these license terms. 

Any Licensee wishing to make commercial use of the Software should contact IXI, to negotiate an appropriate license for such commercial use. Commercial use includes (1) integration of all or part of the source code into a product for sale or license by or on behalf of Licensee to third parties, or (2) distribution of the binary code or source code to third parties that need it to utilize a commercial product sold or licensed by or on behalf of Licensee. 

IXI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE. IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY. IXI SHALL NOT BE LIABLE FOR ANY DAMAGES WHATSOEVER SUFFERED BY THE USERS OF THIS SOFTWARE. 

Copyright (C) 1995, IXI Limited 

By using or copying this Software, Licensee agrees to abide by the copyright law and all other applicable laws of England and the U.S., including, but not limited to, export control laws, and the terms of this license. IXI shall have the right to terminate this license immediately by written notice upon Licensee's breach of, or non-compliance with, any of its terms. Licensee may be held legally responsible for any copyright infringement that is caused or encouraged by Licensee's failure to abide by the terms of this license. 

Comments and questions are welcome and can be sent to
otcl@x.co.uk 

For more information on copyright and licensing issues, contact: 
Legal Department, IXI Limited, Vision Park, Cambridge CB4 4ZR,
ENGLAND. 

 *
 */

static char rcs_id [] = "$Id: OtclObjMgr.C,v 1.2 1995/03/03 10:26:04 deans Exp $";

// Local Includes
#include "Otcl.H"
#include "OtclObject.H"
#include "OtclObjMgr.H"

OtclObjMgr::OtclObjMgr () 
{
}

OtclObjMgr::~OtclObjMgr ()
{
}

OtclObjMgrCmd::OtclObjMgrCmd ()
{
}

OtclObjMgrCmd::~OtclObjMgrCmd ()
{
}

char *OtclObjMgrCmd::manageObject (OtclObject *otclo, Tcl_Interp *interp)
{
   sprintf(symRef,"%lx",(long*)otclo);

   Tcl_CreateCommand(interp,symRef,OtclObjMgrCmd::objCmd,
                     (ClientData)new OtclObjMgrCmd::MgrAndObjPair(this,otclo),
                     (Tcl_CmdDeleteProc*)NULL);

   return symRef;
}

OtclObject *OtclObjMgrCmd::unManageObject (char *ref, Tcl_Interp *interp)
{
   Tcl_CmdInfo info;
   if (Tcl_GetCommandInfo(interp,ref,&info) == 0)
   {
      Otcl::setTclResult(interp,UNKNOWN_OBJECT_ERR,ref);
      return NULL;
   }

   Tcl_DeleteCommand(interp,ref);

   OtclObjMgrCmd::MgrAndObjPair *maop = 
      (OtclObjMgrCmd::MgrAndObjPair*)info.clientData;

   OtclObject *otclo = maop->otclo;

   delete maop;

   return otclo;
}

int OtclObjMgrCmd::obj (OtclObject *otclo, Tcl_Interp *interp,
                        int argc, char *argv[])
{
   ARGC_MIN(2)
   {
      return Otcl::setTclError(interp,ARGS_METHOD_EXE_ERR);
   }

   return otclo->executeMethod(interp,argv[1],argc-2,
                               (argc > 2 ? &argv[2] : NULL));
}

int OtclObjMgrCmd::objCmd (ClientData cd, Tcl_Interp *interp,
                        int argc, char *argv[])
{
   OtclObjMgrCmd::MgrAndObjPair *maop = (OtclObjMgrCmd::MgrAndObjPair*)cd;
   return maop->otclmc->obj(maop->otclo,interp,argc,argv);
}

OtclObject *OtclObjMgrCmd::dereference (char *symbolicRef, Tcl_Interp *interp)
{
   Tcl_CmdInfo info;
   int res = Tcl_GetCommandInfo(interp,symbolicRef,&info);
   if (res)
   {
      return ((OtclObjMgrCmd::MgrAndObjPair*)info.clientData)->otclo;
   }
   else
   {
      return NULL;
   }
}
