#ifndef OTCL_METHOD_H
#define OTCL_METHOD_H

/*  _ __ ___ _
 * | |\ /  /| |  $Id: OtclMethod.H,v 1.2 1995/03/03 10:26:01 deans Exp $
 * | | /  / | |  Copyright (C) 1995 IXI Limited.
 * |_|/__/_\|_|  IXI Limited, Cambridge, England.
 *
 * Component   : OtclMethod.H
 *
 * Author      : Dean Sheehan (deans@x.co.uk)
 *  
 * Description : Header file for OtclMethod, and subclasses, that models
 *               constructors, destructors, instance and class methods on
 *               OtclClasses.
 *
 * License     :
			Object Tcl License & Copyright
			-----------------------------

IXI Object Tcl software, both binary and source (hereafter, Software) is copyrighted by IXI Limited (IXI), and ownership remains with IXI. 

IXI grants you (herafter, Licensee) a license to use the Software for academic, research and internal business purposes only, without a fee. Licensee may distribute the binary and source code (if required) to third parties provided that the copyright notice and this statement appears on all copies and that no charge is associated with such copies. 

Licensee may make derivative works. However, if Licensee distributes any derivative work based on or derived from the Software, then Licensee will (1) notify IXI regarding its distribution of the derivative work, and (2) clearly notify users that such derivative work is a modified version and not the original IXI Object Tcl distributed by IXI. IXI strongly recommends that Licensee provide IXI the right to incorporate such modifications into future releases of the Software under these license terms. 

Any Licensee wishing to make commercial use of the Software should contact IXI, to negotiate an appropriate license for such commercial use. Commercial use includes (1) integration of all or part of the source code into a product for sale or license by or on behalf of Licensee to third parties, or (2) distribution of the binary code or source code to third parties that need it to utilize a commercial product sold or licensed by or on behalf of Licensee. 

IXI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE. IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY. IXI SHALL NOT BE LIABLE FOR ANY DAMAGES WHATSOEVER SUFFERED BY THE USERS OF THIS SOFTWARE. 

Copyright (C) 1995, IXI Limited 

By using or copying this Software, Licensee agrees to abide by the copyright law and all other applicable laws of England and the U.S., including, but not limited to, export control laws, and the terms of this license. IXI shall have the right to terminate this license immediately by written notice upon Licensee's breach of, or non-compliance with, any of its terms. Licensee may be held legally responsible for any copyright infringement that is caused or encouraged by Licensee's failure to abide by the terms of this license. 

Comments and questions are welcome and can be sent to
otcl@x.co.uk 

For more information on copyright and licensing issues, contact: 
Legal Department, IXI Limited, Vision Park, Cambridge CB4 4ZR,
ENGLAND. 

 *
 */

static char rcs_id_OtclMethod_H [] = "IXI header $RCSfile: OtclMethod.H,v $ $Revision: 1.2 $ ";

// Tcl Includes
#include <tcl.h>
#include <tclInt.h>

// Local Includes
#include "OtclClass.H"

// Public Defines
#define OTCL_CONSTRUCTOR_METHOD_NAME "constructor"
#define OTCL_DESTRUCTOR_METHOD_NAME  "destructor"

// Forward Class Declarations
class OtclPart;
class OtclPartOtcl;
class OtclFormalArg;

class OtclMethod
{
public:   // Public Enumerations

   enum Access {PUBLIC, PRIVATE};

public:   // Constructor & Destructor

   OtclMethod (char *name, OtclMethod::Access, OtclClassOtcl *otclClass);

   virtual ~OtclMethod ();

public:   // Public Instance Methods

   virtual int setFormalArgs (Tcl_Interp *interp, char *formalArgs);

   int setBody (Tcl_Interp *interp, char *body);

   int hasBody (void);

   // Execute this method in the current interpreter call frame
   // Assumes caller has set up object & class scope in frame
   int execute (Tcl_Interp *, int argc, char *argv[]);

   int isAccessible (Tcl_Interp *);

   char *giveFirstFormalArgName (void);
   char *giveNextFormalArgName (void);

protected: // Protected Instance Methods

   int bindActualToFormal (Tcl_Interp *, int argc, char *argv[]);

   int evaluateMethodBody (Tcl_Interp *);

private:  // Private Instance Methods

   int overlayFormalArgs (Tcl_Interp *, char *args);

   int argExists (char *name, OtclFormalArg *end);

protected:  // Protected Attributes

   char *name;

   OtclMethod::Access access;

   OtclClassOtcl *otclClass;

   char *body;

private:  // Private Instance Attributes

   // A list of OtclFormalArg objects
   int formalArgsSpecified;
   OtclFormalArg *formalArgHead;
   OtclFormalArg *formalArgTail;
   OtclFormalArg *currentFormalArg;

};

class OtclInstanceMethod : public OtclMethod
{
public:   // Constructor & Destructor

   OtclInstanceMethod (char *name, OtclMethod::Access,
                       OtclClassOtcl *otclClass);

   virtual ~OtclInstanceMethod ();

public:   // Public Instance Methods

};

class OtclConstructorMethod : public OtclInstanceMethod
{
public:   // Constructor & Destructor

   OtclConstructorMethod (OtclClassOtcl *otclClass);

   virtual ~OtclConstructorMethod ();

public:   // Public Instance Methods

   int setParentConstructors (Tcl_Interp *, char *parentConstructors);

   int execute (Tcl_Interp *, int argc, char *argv[], OtclPartOtcl *part);

private:  // Private Instance Attributes

   char *parentConstructorArgs[MAX_SUPERCLASSES];

};

class OtclDestructorMethod : public OtclInstanceMethod
{
public:   // Constructor & Destructor

   OtclDestructorMethod (OtclClassOtcl *otclClass);

   virtual ~OtclDestructorMethod ();

public:   // Public Instance Methods

   int setFormalArgs (Tcl_Interp *, char *formalArgs);
};

class OtclClassMethod : public OtclMethod
{
public:   // Constructor & Destructor

   OtclClassMethod (char *name, OtclMethod::Access, OtclClassOtcl *otclClass);

   virtual ~OtclClassMethod ();
};

#endif // OTCL_METHOD_H
