/*  _ __ ___ _
 * | |\ /  /| |  $Id: CdlRtn.C,v 1.2 1995/03/03 10:25:23 deans Exp $
 * | | /  / | |  Copyright (C) 1995 IXI Limited.
 * |_|/__/_\|_|  IXI Limited, Cambridge, England.
 *
 * Component   : CdlRtn.C
 *
 * Author      : Dean Sheehan (deans@x.co.uk)
 *
 * Description : Contains the implementation of CdlRtn ans subclasses that
 *               model the various types of return arguments from methods.
 *
 * License     :
			Object Tcl License & Copyright
			------------------------------

IXI Object Tcl software, both binary and source (hereafter, Software) is copyrighted by IXI Limited (IXI), and ownership remains with IXI. 

IXI grants you (herafter, Licensee) a license to use the Software for academic, research and internal business purposes only, without a fee. Licensee may distribute the binary and source code (if required) to third parties provided that the copyright notice and this statement appears on all copies and that no charge is associated with such copies. 

Licensee may make derivative works. However, if Licensee distributes any derivative work based on or derived from the Software, then Licensee will (1) notify IXI regarding its distribution of the derivative work, and (2) clearly notify users that such derivative work is a modified version and not the original IXI Object Tcl distributed by IXI. IXI strongly recommends that Licensee provide IXI the right to incorporate such modifications into future releases of the Software under these license terms. 

Any Licensee wishing to make commercial use of the Software should contact IXI, to negotiate an appropriate license for such commercial use. Commercial use includes (1) integration of all or part of the source code into a product for sale or license by or on behalf of Licensee to third parties, or (2) distribution of the binary code or source code to third parties that need it to utilize a commercial product sold or licensed by or on behalf of Licensee. 

IXI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE. IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY. IXI SHALL NOT BE LIABLE FOR ANY DAMAGES WHATSOEVER SUFFERED BY THE USERS OF THIS SOFTWARE. 

Copyright (C) 1995, IXI Limited 

By using or copying this Software, Licensee agrees to abide by the copyright law and all other applicable laws of England and the U.S., including, but not limited to, export control laws, and the terms of this license. IXI shall have the right to terminate this license immediately by written notice upon Licensee's breach of, or non-compliance with, any of its terms. Licensee may be held legally responsible for any copyright infringement that is caused or encouraged by Licensee's failure to abide by the terms of this license. 

Comments and questions are welcome and can be sent to
otcl@x.co.uk 

For more information on copyright and licensing issues, contact: 
Legal Department, IXI Limited, Vision Park, Cambridge CB4 4ZR,
ENGLAND. 

 *
 */

static char rcs_id [] = "$Id: CdlRtn.C,v 1.2 1995/03/03 10:25:23 deans Exp $";

// System Includes
#include <stdlib.h>
#include <string.h>

// Local Include
#include "CdlRtn.H"
#include "CdlFile.H"

CdlRtn *CdlRtn::exemplarHead = NULL;
CdlRtn *CdlRtn::exemplarTail = NULL;

CdlRtn::CdlRtn (int e)
{
   nextExemplar = NULL;
   if (e == 1)
   {
     // This is an exemplar
     if (exemplarTail == NULL)
     {
        exemplarHead = exemplarTail = this;
     }
     else
     {
        exemplarTail->nextExemplar = this;
        exemplarTail = this;
     }
   }
}

CdlRtn::~CdlRtn ()
{
}

int CdlRtn::setArgs (int, char *[])
{
   return 1;
}

CDL_RTN_DEF(CdlIntRtn,int)

CdlIntRtn::~CdlIntRtn ()
{
}

void CdlIntRtn::genPrototype (ofstream &of)
{
   of << "int "; 
}

void CdlIntRtn::declareLocal (ofstream &of, CdlIndent tab)
{
   of << tab << "int rtn = ";
}

void CdlIntRtn::localName (ofstream &of)
{
   of << "rtn";
}

void CdlIntRtn::postProcess (ofstream &of, CdlIndent tab)
{
   of << tab << "Otcl::setTclResult(i,\"%d\",rtn);" << endl;
}

void CdlIntRtn::returnFromTclInterp (char *interpName, ofstream &of,
                                     CdlIndent tab)
{
   of << tab << "return atoi(" << interpName << "->result);" << endl;
}

CDL_RTN_DEF(CdlFloatRtn,float)

CdlFloatRtn::~CdlFloatRtn ()
{
}

void CdlFloatRtn::genPrototype (ofstream &of)
{
   of << "float "; 
}

void CdlFloatRtn::declareLocal (ofstream &of, CdlIndent tab)
{
   of << tab << "float rtn = ";
}

void CdlFloatRtn::localName (ofstream &of)
{
   of << "rtn";
}

void CdlFloatRtn::postProcess (ofstream &of, CdlIndent tab)
{
   of << tab << "Otcl::setTclResult(i,\"%f\",rtn);" << endl;
}

void CdlFloatRtn::returnFromTclInterp (char *interpName, ofstream &of,
                                     CdlIndent tab)
{
   of << tab << "return atof(" << interpName << "->result);" << endl;
}

CDL_RTN_DEF(CdlStrRtn,str)

CdlStrRtn::~CdlStrRtn ()
{
}

void CdlStrRtn::genPrototype (ofstream &of)
{
   of << "char *"; 
}

void CdlStrRtn::declareLocal (ofstream &of, CdlIndent tab)
{
   of << tab << "char *rtn = ";
}

void CdlStrRtn::localName (ofstream &of)
{
   of << "rtn";
}

void CdlStrRtn::postProcess (ofstream &of, CdlIndent tab)
{
   of << tab << "Otcl::setTclResult(i,\"%s\",rtn);" << endl;
}

void CdlStrRtn::returnFromTclInterp (char *interpName, ofstream &of,
                                     CdlIndent tab)
{
   of << tab << "return (" << interpName << "->result);" << endl;
}

CDL_RTN_DEF(CdlObrefRtn,obref)

CdlObrefRtn::~CdlObrefRtn ()
{
   if (className)
   {
      free(className);
   }
}

int CdlObrefRtn::setArgs (int argc, char *argv[])
{
   if (argc != 1)
   {
      return 0;
   }
   className = strdup(argv[0]);
   return 1;
}

void CdlObrefRtn::genPrototype (ofstream &of)
{
   of << className << " *"; 
}

void CdlObrefRtn::declareLocal (ofstream &of, CdlIndent tab)
{
   of << tab << className << " *rtn = ";
}

void CdlObrefRtn::localName (ofstream &of)
{
   of << "rtn";
}

void CdlObrefRtn::postProcess (ofstream &of, CdlIndent tab)
{
   of << tab << "Otcl::setTclResult(i,\"%s\"," 
      << "((" << className << OTCL_PART_SUFFIX << "*)" 
      << "rtn)->giveOwner()->getSelf()"
      << ");" << endl;
}

void CdlObrefRtn::returnFromTclInterp (char *interpName, ofstream &of,
                                     CdlIndent tab)
{
   of << tab << "return (" 
      << "(" << className << "*) Otcl::otclPtr->obrefToCpp("
      << interpName << "->result ,\"" << className << "\")"
      << ");" << endl;
}

