/*  _ __ ___ _
 * | |\ /  /| |  $Id: CdlMethod.C,v 1.2 1995/03/03 10:25:18 deans Exp $
 * | | /  / | |  Copyright (C) 1995 IXI Limited.
 * |_|/__/_\|_|  IXI Limited, Cambridge, England.
 *
 * Component   : CdlMethod.C
 *
 * Author      : Dean Sheehan (deans@x.co.uk)
 *
 * Description : Contains the implementation for CdlMethod class which modesl
 *               methods on CDL'ed classes. Also include implementation for
 *               various specialised method subclasses like constructors.
 *
 * License     :
			Object Tcl License & Copyright
			------------------------------

IXI Object Tcl software, both binary and source (hereafter, Software) is copyrighted by IXI Limited (IXI), and ownership remains with IXI. 

IXI grants you (herafter, Licensee) a license to use the Software for academic, research and internal business purposes only, without a fee. Licensee may distribute the binary and source code (if required) to third parties provided that the copyright notice and this statement appears on all copies and that no charge is associated with such copies. 

Licensee may make derivative works. However, if Licensee distributes any derivative work based on or derived from the Software, then Licensee will (1) notify IXI regarding its distribution of the derivative work, and (2) clearly notify users that such derivative work is a modified version and not the original IXI Object Tcl distributed by IXI. IXI strongly recommends that Licensee provide IXI the right to incorporate such modifications into future releases of the Software under these license terms. 

Any Licensee wishing to make commercial use of the Software should contact IXI, to negotiate an appropriate license for such commercial use. Commercial use includes (1) integration of all or part of the source code into a product for sale or license by or on behalf of Licensee to third parties, or (2) distribution of the binary code or source code to third parties that need it to utilize a commercial product sold or licensed by or on behalf of Licensee. 

IXI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE. IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY. IXI SHALL NOT BE LIABLE FOR ANY DAMAGES WHATSOEVER SUFFERED BY THE USERS OF THIS SOFTWARE. 

Copyright (C) 1995, IXI Limited 

By using or copying this Software, Licensee agrees to abide by the copyright law and all other applicable laws of England and the U.S., including, but not limited to, export control laws, and the terms of this license. IXI shall have the right to terminate this license immediately by written notice upon Licensee's breach of, or non-compliance with, any of its terms. Licensee may be held legally responsible for any copyright infringement that is caused or encouraged by Licensee's failure to abide by the terms of this license. 

Comments and questions are welcome and can be sent to
otcl@x.co.uk 

For more information on copyright and licensing issues, contact: 
Legal Department, IXI Limited, Vision Park, Cambridge CB4 4ZR,
ENGLAND. 

 *
 */

static char rcs_id [] = "$Id: CdlMethod.C,v 1.2 1995/03/03 10:25:18 deans Exp $";

// System Includes
#include <string.h>

// Local Includes
#include "CdlFile.H"
#include "CdlMethod.H"
#include "CdlArg.H"
#include "CdlRtn.H"

CdlMethod::CdlMethod (char *n)
{
   name = strdup(n);
   noOfArgs = 0;
   voidReturn = 0;
   voidArgs = 0;
   rtn = NULL;
}

CdlMethod::~CdlMethod ()
{
   if (rtn != NULL)
   {
      delete rtn;
   }
   for (int a = 0; a < noOfArgs; a++)
   {
      delete arg[a];
   }
}

void CdlMethod::setVoidArgs (void)
{
   voidArgs = 1;
}

int CdlMethod::argsAreVoid (void)
{
   return voidArgs;
}

void CdlMethod::setVoidReturn (void)
{
   voidReturn = 1;
}

int CdlMethod::returnIsVoid (void)
{
   return voidReturn;
}

void CdlMethod::addArg (CdlArg *a)
{
   arg[noOfArgs] = a;
   noOfArgs++;
}

void CdlMethod::setRtn (CdlRtn *r)
{
   rtn = r;
}

CdlRtn *CdlMethod::getRtn (void)
{
   return rtn;
}

int CdlMethod::getNoOfArgs (void)
{
   return noOfArgs;
}

CdlInstanceMethod::CdlInstanceMethod (char *n) :
   CdlMethod(n)
{
   binding = STATIC;
}

CdlInstanceMethod::~CdlInstanceMethod ()
{
}

void CdlInstanceMethod::setBinding (Binding b)
{
   binding = b;
}

void CdlInstanceMethod::genDec (ofstream &of)
{
   of << "   ";

   if (voidReturn)
   {
      of << "void ";
   }
   else
   {
      rtn->genPrototype(of);
   }

   of << name << " (";

   for (int a = 0; a < noOfArgs; a++)
   {
      arg[a]->type(of);
      if (a < (noOfArgs-1))
      {
         of << ", ";
      }
   }
   of << ");" << endl;
}

int CdlInstanceMethod::isDynamic (void)
{
   return (binding == DYNAMIC ? 1 : 0);
}

void CdlInstanceMethod::executeBinding (char *className, ofstream &of)
{
   char varName[10];
   char strName[10];

   CdlIndent tab(1);

   of << tab << "if (strcmp(mName,\"" << name << "\") == 0)" << endl;
   of << tab << "{" << endl;
   tab++;

   of << tab << "*found = OTCL_TRUE;" << endl;

   of << tab << "if (argc != " << noOfArgs << ")" << endl;
   of << tab << "{" << endl;
   tab++;
      of << tab << "return Otcl::setTclError(i,ARGS_METHOD_ERR,"
         << "\"" << name << "\",\"" << className << "\");" << endl;
   tab--;
   of << tab << "}" << endl;

   for (int a = 0; a < noOfArgs; a++)
   {
     sprintf(varName,"arg%d",a);
     sprintf(strName,"argv[%d]",a);
     arg[a]->initVarFromStr(varName,strName,of,tab);
   }

   if (!voidReturn)
   {
      rtn->declareLocal(of,tab);
   }
   else
   {
      of << tab << "(void) ";
   }
   
   of << className << "::" << name << "(";
   for (a = 0; a < noOfArgs; a++)
   {
      sprintf(varName,"arg%d",a);
      of << varName;
      if (a < (noOfArgs - 1))
      {
         of << ", ";
      }
   }
   of << ");" << endl;

   for (a = 0; a < noOfArgs; a++)
   {
      sprintf(varName,"arg%d",a);
      sprintf(strName,"argv[%d]",a);
      arg[a]->cleanVarFromStr(varName,strName,of,tab);
   }

   if (!voidReturn)
   {
      rtn->postProcess(of,tab);
   }

   of << tab << "return TCL_OK;" << endl;
   tab--;
   of << tab << "}" << endl;
}

void CdlInstanceMethod::genDef (char *className, ofstream &of)
{
   int a;
   char varName[10];
   char strName[10];

   CdlIndent tab(1);

   if (voidReturn)
   {  
      of << "void";
   }
   else
   {
      rtn->genPrototype(of);
   }

   of << " " << className << OTCL_PART_SUFFIX << "::" << name << "(";
   if (voidArgs)
   {
      of << "void";
   }
   else
   {
      for (a = 0; a < noOfArgs; a++) 
      {
         sprintf(varName,"arg%d",a);
         arg[a]->type(of);
         of << " " << varName;
         if (a < (noOfArgs-1))
         {
             of << ", ";
         }
      }
   }
   of << ")" << endl;
   of << "{" << endl;
   of << tab << "if (owner->giveOtclPart() == this)" << endl;
   of << tab << "{" << endl;

   tab++;

   if (voidReturn)
   {
      of << tab;
   }
   else
   {
      of << tab << "return ";
   }

   of << className << "::" << name << "(";
   for (a = 0; a < noOfArgs; a++)
   {
      sprintf(varName,"arg%d",a);
      of << varName;
      if (a < (noOfArgs-1))
      {
         of << ", ";
      }
   }
   of << ");" << endl;
   if (voidReturn)
   {
      of << tab << "return;" << endl;
   }
   tab--;
   of << tab << "}" << endl;

   if (noOfArgs != 0)
   {
      of << tab << "char *argv[" << noOfArgs << "];" << endl;
      for (a = 0; a < noOfArgs; a++)
      {
         sprintf(varName,"arg%d",a);
         sprintf(strName,"argv[%d]",a);
         arg[a]->initStrFromVar(strName,varName,of,tab);
      }
   }

   of << endl;

   of << tab << "int result = owner->executeMethod(Otcl::tclInterp,\"" << name
      << "\"," << noOfArgs << ",";
   if (noOfArgs == 0)
   {
      of << "NULL";
   }
   else
   {
      of << "argv";
   }
   of << ");" << endl;

   of << endl;

   of << tab << "if (result != TCL_OK)" << endl;
   of << tab << "{" << endl;
   tab++;
   of << tab << "otclErrorMethod(\"" << className << "::" << name << "\",Otcl::tclInterp->result);" << endl;
   tab--;
   of << tab << "}" << endl;

   for (a = 0; a < noOfArgs; a++)
   {
      sprintf(varName,"arg%d",a);
      sprintf(strName,"argv[%d]",a);
      arg[a]->cleanStrFromVar(strName,varName,of,tab);
   }

   if (!voidReturn)
   {
     rtn->returnFromTclInterp("Otcl::tclInterp",of,tab);
   }

   of << "}" << endl;
}

CdlConstructor::CdlConstructor (char *name) :
   CdlMethod(name)
{
}

CdlConstructor::~CdlConstructor ()
{
}

void CdlConstructor::genDec (ofstream &of)
{
   of << "   " << name << "(";

   for (int a = 0; a < noOfArgs; a++)
   {
      arg[a]->type(of);
      of << ", ";
   }

   of << "OtclObject *);" << endl;
}

void CdlConstructor::defineArgs (ofstream &of)
{
   for (int a = 0; a < noOfArgs; a++)
   {
      arg[a]->type(of);
      of << " arg" << a << ", ";
   }
   
   of << "OtclObject *o";
}

void CdlConstructor::preProcessArgs (ofstream &of, CdlIndent tab)
{
   char varName[10];
   char strName[10];
   for (int a = 0; a < noOfArgs; a++)
   {
      sprintf(varName,"arg%d",a);
      sprintf(strName,"argv[%d]",a);
      arg[a]->initVarFromStr(varName,strName,of,tab);
   }
}

void CdlConstructor::passArgs (ofstream &of, char *lastArg)
{
   for (int a = 0; a < noOfArgs; a++)
   {
      of << "arg" << a << ", ";
   }
   of << lastArg;
}

void CdlConstructor::passArgsUpwards (ofstream &of)
{
   for (int a = 0; a < noOfArgs; a++)
   {
      of << "arg" << a;
      if (a < (noOfArgs-1))
      {
         of << ", ";
      }
   }
}

void CdlConstructor::postProcessArgs (ofstream &of, CdlIndent tab)
{
   char varName[10];
   char strName[10];
   for (int a = 0; a < noOfArgs; a++)
   {
      sprintf(varName,"arg%d",a);
      sprintf(strName,"argv[%d]",a);
      arg[a]->cleanVarFromStr(varName,strName,of,tab);
   }
}

CdlClassMethod::CdlClassMethod (char *n) :
   CdlMethod(n)
{
}

CdlClassMethod::~CdlClassMethod ()
{
}

void CdlClassMethod::executeBinding (char *className, ofstream &of,
                                    CdlIndent tab)
{
   char varName[10];
   char strName[10];

   of << tab << "if (strcmp(argv[1],\"" << name << "\") == 0)" << endl;
   of << tab << "{" << endl;
   tab++;

   of << tab << "if (argc-2 != " << noOfArgs << ")" << endl;
   of << tab << "{" << endl;
   tab++;
      of << tab << "return Otcl::setTclError(i,ARGS_METHOD_ERR," 
         << "\"" << name << "\",\"" << className << "\");";
   tab--;
   of << tab << "}" << endl;

   for (int a = 0; a < noOfArgs; a++)
   {
      sprintf(varName,"arg%d",a);
      sprintf(strName,"argv[%d]",a+2);
      arg[a]->initVarFromStr(varName,strName,of,tab);
   }  

   if (!voidReturn)
   {
      rtn->declareLocal(of,tab);
   } 
   else
   {
      of << tab << "(void) ";
   }

   of << className << "::" << name << "(";
   for (a = 0; a < noOfArgs; a++)
   {
      of << "arg" << a;
      if (a < (noOfArgs-1))
      {
         of << ", ";
      }
   }
   of << ");" << endl;
   
   for (a = 0; a < noOfArgs; a++)
   {
      sprintf(varName,"arg%d",a);
      sprintf(strName,"argv[%d]",a+2);
      arg[a]->cleanVarFromStr(varName,strName,of,tab);
   }

   if (!voidReturn)
   {
      rtn->postProcess(of,tab);
   }

   of << tab << "return TCL_OK;" << endl;
   
   tab--;
   of << tab << "}" << endl;
}
