#---------------------------------------------------------------------------
#
#	Help Window Creation
#
#---------------------------------------------------------------------------

#---------------------------------------------------------------------------
#
# BEWARE: the "fit" option will give you weird effects!!

defwidget Help

defmethod Help new {name args} {
  global system

  args	fit layout {height 20} help {embedded false}

  if { $layout == "" && $embedded != "true" } {
    set layout center
  }

  if { $embedded != "true" } {
    Toplevel new $name -reuse true
    Button new $name.dismiss -layout {bottom padx 10 pady 15} \
	-textfont large -text Dismiss \
	-action [list $name Dismiss]
  } {
    Frame new $name
  }
  defsuper $name Help

  set topic [lindex $help 0]
  set values [lrange $help 1 end]

  set loc Help-$system(language)
  set init {}
  set sublocs {}
  if { $system(application) != {} } {
    lappend sublocs $system(application)/
  }
  if { $system(system) != {} } {
    lappend sublocs $system(system)/
  }
  lappend sublocs {}
  foreach subloc $sublocs {
    if { [set file [check(file) $loc ${subloc}$topic.help -]] != "-" } {
      set init Formatted
      break
    }
    if { [set file [check(file) $loc ${subloc}$topic.text -]] != "-" } {
      set init Text
      break
    }
  }

  if { $init == {} } {
    if { [set file [check(file) $loc $system(system)/.help -]] != "-" } {
      set init Formatted
      set values [list $topic]
    } elseif { [set file [check(file) $loc .help -]] != "-" } {
      set init Formatted
      set values [list $topic]
    } {
      set init List
      set file [list "Help for '$topic' is not available." {largebold 0.0 end}]
    }
  }

  Textedit new $name.help -embedded true -readonly true -height $height \
	-initmethod $init -init $file -layout {top expand fill} \
	-values $values

  $name layout $layout
}

Window addDemo Help

defmethod Help demo {} {

  Help new * -help Library/printers -layout +100+100
}
