#
# XowCollection.tcl,v 1.2 1992/05/09 04:05:42 snl Exp
#
# /afs/cs/project/edrc/ndim/source/bos/base/XowCollection.tcl,v 1.2 1992/05/09 04:05:42 snl Exp
#
# HISTORY
#
# XowCollection.tcl,v
# Revision 1.2  1992/05/09  04:05:42  snl
# xow 1.5
#
# Revision 1.3  92/04/22  01:06:19  snl
# Ported to xow 1.5
# 
# Revision 1.2  92/01/27  16:06:51  snl
# Port to new TCL
# 
# Revision 1.1  91/12/16  20:12:51  snl
# Initial revision
# 
# Revision 1.1  91/12/16  19:42:54  snl
# Initial revision
# 
# Revision 1.1  91/12/16  19:35:14  snl
# Initial revision
# 
#
GraphicalObject refineWith XowCollection

XowCollectionTraits defMethod initialize {parent {width 500} {height 500} args} {
  set w [$self [$self graphicalObjectParent]:initialize $parent]
  eval "collection $w $args"
  resize $w $width $height
  geometry $w $width $height
  return $w
}
XowCollectionTraits defMethod findRoot {} {
  set coll [$self window]
  set rootno 0
  set root ""
  set children [winfo children $coll]
  if {![llength $children]} {return {}}
  foreach c $children {
    set tono [llength [$coll to $c]]
    if {$tono == 0} {
      ++ rootno
      set root [winfo name $c]
    } else {if {$tono > 1} {set rootno 23}}
  }
  if {$rootno != 1} {
    puts stdout "not a tree\n"
    return ""
  }
  return $root
}
XowCollectionTraits defMethod allRoots {} {
  set coll [$self window]
  set roots {}
  set children [winfo children $coll]
  if {![llength $children]} {return {}}
  foreach c $children {
    set tono [llength [$coll to $c]]
    if {$tono == 0} {
      set roots [concat $roots [winfo name $c]]
    }
  }
  return $roots
}
XowCollectionTraits defMethod connect {from to {type simpleLink}} {
  [$self window] from $from $to $type ""
}
XowCollectionTraits defMethod disconnect {from to {type simpleLink}} {
# what link type?
  [$self window] disconnect $from $to $type
}
XowCollectionTraits defMethod outgoing {from} {
  [$self window] from $from
}
XowCollectionTraits defMethod doLayout {{orient horizontal}} {
  tree.layout [$self window] $orient
}
XowCollectionTraits defMethod treeLayout {root} {
  laytree [$self window]
}
XowCollectionTraits defMethod treeLayoutHoriz {root x y {level 0}} {
  treelayoutHoriz [$self window] $root $x $y $level
}
XowCollectionTraits defMethod moveMe {who X Y} {
  set mx [$self winfo rootx]
  set my [$self winfo rooty]
#  set w2 [expr {[$self winfo width]/2}]
#  set h2 [expr {[$self winfo height]/2}]
  move [$who window] [expr {$X - $mx}] [expr {$Y - $my}]
}
