/**
 ** This file added by TSIPP as part of improving portability.
 **
 **  Copyright Mark Diekhans 1994
 **  Copyright Equivalent Software HB  1992
 **
 ** This program is free software; you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation; either version 1, or any later version.
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 ** You can receive a copy of the GNU General Public License from the
 ** Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 **/

/**
 ** sipp_port.h - Portability support.
 **/


#ifndef _SIPP_PORT_H
#define _SIPP_PORT_H

#ifdef HAVE_VALUES_H
#    include <values.h>
#endif

#ifdef HAVE_FLOAT_H
#    include <float.h>
#endif

#ifndef FLT_MAX
#    ifdef MAXFLOAT
#        define FLT_MAX MAXFLOAT
#    else
#        define FLT_MAX ((float)3.40282346638528860e+38)
#    endif
#endif

/*
 * Code suggested by autoconf documentation for including string[s].h and
 * memory.h.
 */
#if STDC_HEADERS || HAVE_STRING_H
#    include <string.h>
     /*
      * An ANSI string.h and pre-ANSI memory.h might conflict.
      */
#    if !STDC_HEADERS && HAVE_MEMORY_H
#        include <memory.h>
#    endif
#else
     /*
      * memory.h and strings.h conflict on some systems.
      */
#    include <strings.h>
#    define memcpy(to, from, n) bcopy((from), (to), (n))
#endif


/*
 * The macro RANDOM() should return a random number
 * in the range [-1, 1].
 */
extern double drand48();
#define RANDOM()  (2.0 * drand48() - 1.0)


#endif /* _SIPP_PORT_H */

