/*
 * xgrab.c --
 *
 * Copyright (c) 1994 Software Research Associates, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Software Research
 * Associates makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 */
 
#include "xlibInt.h" 

int pointerGrabbed = 0;
int keyboardGrabbed = 0;
Window grabbedWindow = None;

int 
XGrabPointer(Display *display, Window grab_window, Bool owner_event,
	     unsigned long event_mask, int pointer_mode, int keybord_mode,
	     Window confine_to, Cursor cursor, Time time)
{
    display->request++;

    pointerGrabbed = 1;
    grabbedWindow = grab_window;
    if (GetCapture()) {
	ReleaseCapture();
    }
    return Success;
}

void
XUngrabPointer(Display *display, Time time)
{
    display->request++;

    pointerGrabbed = 0;
    grabbedWindow = None;
    ReleaseCapture();
}


int
XGrabKeyboard(Display *display, Window grab_window, Bool owner_events,
	      int pointer_mode, int keyboard_mode, Time time)
{
    display->request++;

    keyboardGrabbed = 1;
    return Success;
}

void
XUngrabKeyboard(Display *display, Time time)
{
    display->request++;

    keyboardGrabbed = 0;
}	





