/*
 * xgc.c --
 *
 * Copyright (c) 1994 Software Research Associates, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Software Research
 * Associates makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 */
 
#include "xlibInt.h" 

/* 
 * 	XCreateGC -- 
 *
 */

GC
XCreateGC(Display *display, Window w, unsigned long mask, XGCValues *values)
{
    GC gp;

    display->request++;

    if (( gp = (XGCValues *)malloc(sizeof(XGCValues)) ) == None) 
	return None;

    gp->function = 	(mask & GCFunction) 	?values->function	:GXcopy;
    gp->plane_mask = 	(mask & GCPlaneMask) 	?values->plane_mask 	:~0;
    gp->foreground = 	(mask & GCForeground) 	?values->foreground 	:RGB(0, 0, 0);
    gp->background = 	(mask & GCBackground) 	?values->background 	:RGB(255, 255, 255);
    gp->line_width = 	(mask & GCLineWidth)	?values->line_width	:0;	
    gp->line_style = 	(mask & GCLineStyle)	?values->line_style	:LineSolid;
    gp->cap_style =  	(mask & GCCapStyle)	?values->cap_style	:0;
    gp->join_style = 	(mask & GCJoinStyle)	?values->join_style	:0;
    gp->fill_style =  	(mask & GCFillStyle)	?values->fill_style	:FillSolid;
    gp->fill_rule =  	(mask & GCFillRule)	?values->fill_rule	:WindingRule;
    gp->arc_mode = 	(mask & GCArcMode)	?values->arc_mode	:ArcPieSlice;
    gp->tile = 		(mask & GCTile)		?values->tile		:None;
    gp->stipple = 	(mask & GCStipple)	?values->stipple	:None;
    gp->ts_x_origin = 	(mask & GCTileStipXOrigin)	?values->ts_x_origin:0;
    gp->ts_y_origin = 	(mask & GCTileStipYOrigin)	?values->ts_y_origin:0;
    gp->font = 		(mask & GCFont)		?values->font		:None;
    gp->subwindow_mode = (mask & GCSubwindowMode)?values->subwindow_mode:ClipByChildren;
    gp->graphics_exposures = (mask & GCGraphicsExposures)?values->graphics_exposures:True;
    gp->clip_x_origin = (mask & GCClipXOrigin)	?values->clip_x_origin	:0;
    gp->clip_y_origin = (mask & GCClipYOrigin)	?values->clip_y_origin	:0;
    gp->clip_mask = 	(mask & GCClipMask)	?values->clip_mask	:None;
    gp->dash_offset = 	(mask & GCDashOffset)	?values->dash_offset	:0;
    gp->dashes = 	(mask & GCDashList)	?values->dashes		:4;

    return gp;
}  

/*
 * XFreeGC --
 *
 */

void
XFreeGC(Display *display, GC gc)
{
    display->request++;

    if (gc != None) free(gc);
}   


void
XSetForeground(Display *display, GC gc, unsigned long foreground)
{
    display->request++;

    gc->foreground = foreground;
}

void 
XSetBackground(Display *display, GC gc, unsigned long background)
{
    display->request++;

   gc->background = background;
}

void
XSetFunction(Display *display, GC gc, int function)
{
    display->request++;

    gc->function = function;
}

void
XSetFillRule(Display *display, GC gc, int fill_rule)
{
    display->request++;

    gc->fill_rule = fill_rule;
}

void
XSetFillStyle(Display *display, GC gc, int fill_style)
{
    display->request++;

    gc->fill_style = fill_style;
}


void
XSetFont(Display *display, GC gc, HFONT font)
{
    display->request++;

    gc->font = font;
}

void
XSetTSOrigin(Display *display, GC gc, int x, int y)
{
    display->request++;

    gc->ts_x_origin = x;
    gc->ts_y_origin = y;
}

void
XSetArcMode(Display *display, GC gc, int arc_mode)
{
    display->request++;

    gc->arc_mode = arc_mode;
}

void
XSetStipple(Display *display, GC gc, Pixmap stipple)
{
    display->request++;

    gc->stipple = stipple;
}


void
XSetLineAttributes(Display *display, GC gc, unsigned int line_width,
		   int line_style, int cap_style, int join_style)
{
    display->request++;

    gc->line_style = line_style;
    gc->cap_style = cap_style;
    gc->join_style = join_style;
}
