/*
 * xdisplay.c --
 *
 * Copyright (c) 1994 Software Research Associates, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Software Research
 * Associates makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 */
 
#include "xlibInt.h" 

static Display *displayList = NULL;

static Screen *mkScreen(Display *);
static Visual *mkVisual(Display *);

/*
 *	XOpenDisplay --
 *
 */

Display *
XOpenDisplay(const char *screenName)
{
    Display *dPtr;
    Screen *sPtr;

    if (displayList != NULL) {
	return displayList;
    }
    
    dPtr = (Display *) malloc(sizeof(Display));
    if (dPtr == NULL) {
	return NULL;
    }
    sPtr = mkScreen(dPtr);
    if (sPtr == NULL) {
    	free(dPtr);
        return NULL;
    }

    dPtr->head = (_XQEvent *) malloc(sizeof(_XQEvent));
    dPtr->filehead = (_XQEvent *) malloc(sizeof(_XQEvent));
    dPtr->timerhead = (_XQEvent *) malloc(sizeof(_XQEvent));

    if (dPtr->head == NULL || dPtr->filehead == NULL || dPtr->timerhead == NULL) {
    error:
	free(sPtr);
	free(dPtr);
	return NULL;
    }

    dPtr->request = 0;
    dPtr->last_request_read = 0;

    dPtr->head->next = dPtr->head;
    dPtr->head->prev = dPtr->head;
    dPtr->qlen = 0;   

    dPtr->filehead->next = dPtr->filehead;
    dPtr->filehead->prev = dPtr->filehead;
    dPtr->fileqlen = 0;   

    dPtr->timerhead->next = dPtr->timerhead;
    dPtr->timerhead->prev = dPtr->timerhead;
    dPtr->timerqlen = 0;   

    if (screenName != NULL && *screenName != '\0') {
    	dPtr->display_name = (char *)malloc(strlen(screenName) + 1);
	if (dPtr->display_name == NULL) {    
	    goto error;
	}
	strcpy(dPtr->display_name, screenName);		
    } else {
    	dPtr->display_name = "";
    }

    dPtr->fd = (int) GetCurrentThread();

    dPtr->default_screen = 0;     	/* default screen for operations */
    dPtr->nscreens = 1;           	/* number of screens on this server*/
    dPtr->screens = sPtr;        	/* pointer to list of screens */
    dPtr->pixmapList = NULL;

    dPtr->next = displayList;
    displayList = dPtr;
    return dPtr;
}

static Screen *
mkScreen(Display *display)
{
    Screen *sPtr;
    HDC hdc;

    if ((sPtr = malloc(sizeof(Screen))) == NULL)
	return NULL;

    sPtr->display = display;				/* back pointer to display structure */
    sPtr->root = HWND_DESKTOP;           		/* Root window id. */
    sPtr->width = GetSystemMetrics(SM_CXSCREEN);	/* width and height of screen */
    sPtr->height = GetSystemMetrics(SM_CYSCREEN);      

    hdc = GetDC(HWND_DESKTOP);
    sPtr->root_depth = GetDeviceCaps(hdc, BITSPIXEL);        
    sPtr->mwidth = GetDeviceCaps(hdc, HORZSIZE); 	/* width and height of  in millimeters */
    sPtr->mheight = GetDeviceCaps(hdc, VERTSIZE);    
    ReleaseDC(HWND_DESKTOP, hdc);	  
    sPtr->cmap = 1;          				/* default color map */
    sPtr->white_pixel = RGB(255, 255, 255);		/* White and Black pixel values */
    sPtr->black_pixel = RGB(0, 0, 0);			
    sPtr->backing_store = False;			/* Never, WhenMapped, Always */
    sPtr->save_unders = False;
    sPtr->root_visual = mkVisual(display);


    return sPtr;
}

static Visual *
mkVisual(Display *display)
{
    static int visualid = 0;
    static Visual *visual = NULL;

    if (visual != NULL) {
	return visual;
    }
    visual = (Visual *) malloc(sizeof(Visual));
    if (visual == NULL) {
	return NULL;
    }
    visual->ext_data = NULL;
    visual->class = PseudoColor;
    visual->red_mask = visual->green_mask = visual->blue_mask = 0xffffffff;
    visual->bits_per_rgb = 2;
    visual->map_entries = 256 * 256 * 256;

    return visual;
}

/*
 *	XCloseDisplay --
 *
 *	
 */

void 
XCloseDisplay(Display *display)
{
    if (displayList != NULL && displayList == display) {
        free(display->screens);
	free(display);
	displayList = NULL;
    }
}

/*
 * 	XRootWindow, XFlush, XSync
 */

Window
XRootWindow(Display *display, int screen_number)
{
    if (displayList != NULL && displayList == display 
    	    && screen_number <= display->nscreens) {
	return (display->screens[screen_number]).root;
    }
    return None;
}

void
XFlush(Display *display)
{
}

int (*
XSynchronize(Display *display, Bool onoff)
)()
{
    return NULL;
}

void
XSync(Display *display, Bool dummy2)
{
}


