/*
 * xconfwin.c --
 *
 * Copyright (c) 1994 Software Research Associates, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Software Research
 * Associates makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 */
 
#include "xlibInt.h" 

/*
 * XConfigureWindow --
 *
 */

void
XConfigureWindow(Display *display, Window w, unsigned mask, 
	XWindowChanges *values)
{  
    unsigned char result;
    
    display->request++;

    result = _SetWindowChanges(w, mask, values); 
    if (result != Success) 
    	postError(result, (HWND) w);
}

/*
 * XMoveWindow --
 *
 */

void
XMoveWindow(Display *display, Window w, int x, int y)
{
    XWindowChanges changes;
    unsigned char result;
     
    display->request++;

    changes.x = x;
    changes.y = y;
    result = _SetWindowChanges(w, CWX|CWY,  &changes);
    if (result != Success) 
    	postError(result, (HWND) w);
}

void
XResizeWindow(Display *display, Window w, unsigned width, unsigned height)
{
    XWindowChanges changes;
    unsigned char result;

    display->request++;

    changes.width = width;
    changes.height = height;
    result = _SetWindowChanges(w, CWWidth|CWHeight, &changes);
    if (result != Success) 
    	postError(result, (HWND) w);
}

void
XMoveResizeWindow(Display *display, Window w, int x, int y, 
	unsigned width, unsigned height)
{
    XWindowChanges changes;
    unsigned char result;

    display->request++;

    changes.x = x;
    changes.y = y;
    changes.width = width;
    changes.height = height;
    result = _SetWindowChanges(w, CWX|CWY|CWWidth|CWHeight, &changes);
    if (result != Success) 
    	postError(result, (HWND) w);
}

void 
XSetWindowBorderWidth(Display *display, Window w, unsigned int width)
{
    XWindowChanges changes;
    unsigned char result;

    display->request++;

    changes.border_width = width;
    result = _SetWindowChanges(w, CWBorderWidth, &changes);
    if (result != Success) 
    	postError(result, (HWND) w);
}

void
XRaiseWindow(Display *display, Window w)
{
    XWindowChanges changes;
    unsigned char result;

    display->request++;

    changes.sibling = None;
    changes.stack_mode = Above;
    result = _SetWindowChanges(w, CWSibling|CWStackMode, &changes);
    if (result != Success) 
    	postError(result, (HWND) w);
}

void
XLowerWindow(Display *display, Window w)
{
    XWindowChanges changes;
    unsigned char result;

    display->request++;

    changes.sibling = None;
    changes.stack_mode = Below;
    result = _SetWindowChanges(w, CWSibling|CWStackMode, &changes);
    if (result != Success) 
    	postError(result, (HWND) w);
}
