/*
 * xatom.c --
 *
 * Copyright (c) 1994 Software Research Associates, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Software Research
 * Associates makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 */
 
#include "xlibInt.h" 

Atom
XInternAtom(Display *display, const char *atom_name, Bool exists)
{
    Atom atom;

    display->request++;
    if (exists == True) {
	return  GlobalFindAtom(atom_name);
    } else {
	if ((atom = GlobalFindAtom(atom_name)) != 0) {
	    return atom;
	} else {
	    return GlobalAddAtom(atom_name);
	}
    }
}

char *
XGetAtomName(Display *display, Atom atom)
{
    char buffer[256];
    char *p;
    int len;

    display->request++;
    /* All Windows generated atoms are in the range of 0xC000 - 0xFFFF */
    if (atom < 0xC000) {
	switch (atom) {
	case XA_PRIMARY:
	    return strdup("PRIMARY");

	case XA_SECONDARY:
	    return strdup("SECONDARY");

	case XA_ARC:
	    return strdup("ARC");

	case XA_ATOM:
	    return strdup("ATOM");

	case XA_BITMAP:
	    return strdup("BITMAP");

	case XA_CARDINAL:
	    return strdup("CARDINAL");

	case XA_COLORMAP:
	    return strdup("COLORMAP");

	case XA_CURSOR:
	    return strdup("CURSOR");

	case XA_CUT_BUFFER0:
	    return strdup("CUT_BUFFER0");

	case XA_CUT_BUFFER1:
	    return strdup("CUT_BUFFER1");

	case XA_CUT_BUFFER2:
	    return strdup("CUT_BUFFER2");

	case XA_CUT_BUFFER3:
	    return strdup("CUT_BUFFER3");

	case XA_CUT_BUFFER4:
	    return strdup("CUT_BUFFER4");

	case XA_CUT_BUFFER5:
	    return strdup("CUT_BUFFER5");

	case XA_CUT_BUFFER6:
	    return strdup("CUT_BUFFER6");

	case XA_CUT_BUFFER7:
	    return strdup("CUT_BUFFER7");

	case XA_DRAWABLE:
	    return strdup("DRAWABLE");

	case XA_FONT:
	    return strdup("FONT");

	case XA_INTEGER:
	    return strdup("INTEGER");

	case XA_PIXMAP:
	    return strdup("PIXMAP");

	case XA_POINT:
	    return strdup("POINT");

	case XA_RECTANGLE:
	    return strdup("RECTANGLE");

	case XA_RESOURCE_MANAGER:
	    return strdup("RESOURCE_MANAGER");

	case XA_RGB_COLOR_MAP:
	    return strdup("RGB_COLOR_MAP");

	case XA_RGB_BEST_MAP:
	    return strdup("RGB_BEST_MAP");

	case XA_RGB_BLUE_MAP:
	    return strdup("RGB_BLUE_MAP");

	case XA_RGB_DEFAULT_MAP:
	    return strdup("RGB_DEFAULT_MAP");

	case XA_RGB_GRAY_MAP:
	    return strdup("RGB_GRAY_MAP");

	case XA_RGB_GREEN_MAP:
	    return strdup("RGB_GREEN_MAP");

	case XA_RGB_RED_MAP:
	    return strdup("RGB_RED_MAP");

	case XA_STRING:
	    return strdup("STRING");

	case XA_VISUALID:
	    return strdup("VISUALID");

	case XA_WINDOW:
	    return strdup("WINDOW");

	case XA_WM_COMMAND:
	    return strdup("WM_COMMAND");

	case XA_WM_HINTS:
	    return strdup("WM_HINTS");

	case XA_WM_CLIENT_MACHINE:
	    return strdup("WM_CLIENT_MACHINE");

	case XA_WM_ICON_NAME:
	    return strdup("WM_ICON_NAME");

	case XA_WM_ICON_SIZE:
	    return strdup("WM_ICON_SIZE");

	case XA_WM_NAME:
	    return strdup("WM_NAME");

	case XA_WM_NORMAL_HINTS:
	    return strdup("WM_NORMAL_HINTS");

	case XA_WM_SIZE_HINTS:
	    return strdup("WM_SIZE_HINTS");

	case XA_WM_ZOOM_HINTS:
	    return strdup("WM_ZOOM_HINTS");

	case XA_MIN_SPACE:
	    return strdup("MIN_SPACE");

	case XA_NORM_SPACE:
	    return strdup("NORM_SPACE");

	case XA_MAX_SPACE:
	    return strdup("MAX_SPACE");

	case XA_END_SPACE:
	    return strdup("END_SPACE");

	case XA_SUPERSCRIPT_X:
	    return strdup("SUPERSCRIPT_X");

	case XA_SUPERSCRIPT_Y:
	    return strdup("SUPERSCRIPT_Y");

	case XA_SUBSCRIPT_X:
	    return strdup("SUBSCRIPT_X");

	case XA_SUBSCRIPT_Y:
	    return strdup("SUBSCRIPT_Y");

	case XA_UNDERLINE_POSITION:
	    return strdup("UNDERLINE_POSITION");

	case XA_UNDERLINE_THICKNESS:
	    return strdup("UNDERLINE_THICKNESS");

	case XA_STRIKEOUT_ASCENT:
	    return strdup("STRIKEOUT_ASCENT");

	case XA_STRIKEOUT_DESCENT:
	    return strdup("STRIKEOUT_DESCENT");

	case XA_ITALIC_ANGLE:
	    return strdup("ITALIC_ANGLE");

	case XA_X_HEIGHT:
	    return strdup("X_HEIGHT");

	case XA_QUAD_WIDTH:
	    return strdup("QUAD_WIDTH");

	case XA_WEIGHT:
	    return strdup("WEIGHT");

	case XA_POINT_SIZE:
	    return strdup("POINT_SIZE");

	case XA_RESOLUTION:
	    return strdup("RESOLUTION");

	case XA_COPYRIGHT:
	    return strdup("COPYRIGHT");

	case XA_NOTICE:
	    return strdup("NOTICE");

	case XA_FONT_NAME:
	    return strdup("FONT_NAME");

	case XA_FAMILY_NAME:
	    return strdup("FAMILY_NAME");

	case XA_FULL_NAME:
	    return strdup("FULL_NAME");

	case XA_CAP_HEIGHT:
	    return strdup("CAP_HEIGHT");

	case XA_WM_CLASS:
	    return strdup("WM_CLASS");

	case XA_WM_TRANSIENT_FOR:
	    return strdup("WM_TRANSIENT_FOR");

	default:
	    return NULL;
	}
    }

    len = (int) GlobalGetAtomName(atom, buffer, sizeof(buffer));
    if ((p = malloc(len + 1)) == NULL) {
    	return NULL;
    } else {
    	strcpy(p, buffer);
    }
    return p;
}
