/*
 * wineasy.h
 *
 * Copyright (c) 1994 Software Research Associates, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Software Research
 * Associates makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 */

#ifndef DECLARE_HANDLE 
#ifdef STRICT
typedef const void *        HANDLE;
#define DECLARE_HANDLE(name)    struct name##__ { int unused; }; \
                                typedef const struct name##__ * name
#else   /* STRICT */
typedef unsigned int                    HANDLE;
#define DECLARE_HANDLE(name)    typedef unsigned int  name
#endif  /* !STRICT */
#endif /* DECLARE_HANDLE */

DECLARE_HANDLE(HBITMAP);
DECLARE_HANDLE(HPEN);
DECLARE_HANDLE(HBRUSH);
DECLARE_HANDLE(HRGN);
DECLARE_HANDLE(HPALETTE);
DECLARE_HANDLE(HFONT);

DECLARE_HANDLE(HWND);
DECLARE_HANDLE(HICON);
typedef HICON HCURSOR;      /* HICONs & HCURSORs are polymorphic */
