/*
 * wait.h
 */
#include <signal.h>

typedef int pid_t;

#define WNOHANG 1

#define WIFEXITED(status) (((status) & 0x0f) != 3)
#define WIFSIGNALED(status) (((status) & 0x0f) == 3)
#define WIFSTOPPED(status) 0
#define WEXITSTATUS(status) (((status) & 0xff00) >> 8)
#define WSTOPSIG(status) 0
#define WTERMSIG(status) (((status) & 0x0f == 3) ? SIGTERM : 0)

extern pid_t waitpid (pid_t pid, int *stat_loc, int options);
