'\"
'\" Copyright (c) 1990 The Regents of the University of California.
'\" All rights reserved.
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" documentation for any purpose, provided that the above copyright
'\" notice and the following two paragraphs appear in all copies.
'\"
'\" IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
'\" FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
'\" ARISING OUT OF THE USE OF THIS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
'\" CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'\"
'\" THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
'\" AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
'\" ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
'\" 
.so man.macros
.HS dp_SocketOption tcldp
.BS
.SH NAME
dp_socketOption \- Change the options on a socket
.BE
.TP
\fBdp_socketOption \fIsockId option ?arg?\fR

The dp_socketOption command provides access to the setsockopt(2)
and getsockopt(2) system calls.  If the optional \fIarg\fP is provided,
the \fIoption\fP is set on the socket \fIsockId\fP.  Otherwise, the
current value of \fIoption\fP associated with \fIsockId\fP is returned.
Currently, 3 socket options can be adjusted:
.RS
.TP
\fBdp_socketOption \fIsockId sendBuffer ?bytes?\fR
Sets/gets the size of the send buffer
for \fIsockId\fP.  The send buffer is the number of bytes that can be buffered
in the system before a send/recv or read/write call will block.
The default value is machine dependent.

.TP
\fBdp_socketOption \fIsockId recvBuffer ?bytes?\fR
Sets/gets the size of the receive buffer
for \fIsockId\fP.  The receive buffer is the number of bytes that can be
buffered in the system before data will cease to flow on a tcp socket, or be
dropped on a udp socket.
The default value is machine dependent.

.TP
\fBdp_socketOption \fIsockId noblock ?yes|no? \fR
Sets/gets the non blocking i/o
mode for the connection associated with \fIsockId\fP.  This option
will change the behavior of various transmission routines as described
in dp_connect(n).
The default value is "no."

.TP
\fBdp_socketOption \fIsockId autoClose ?yes|no? \fR
Sets/gets the autoClose
flag for the connection associated with \fIsockId\fP.  If
the autoClose flag is "yes", then any errors detected in
transmission will automatically close the file.  This case
typically arrives when the connection is closed unexpectedly.
Users can attach callbacks to the closing of the file using
the dp_atclose facility.  The default value is "yes."

.TP
\fBdp_socketOption \fIsockId keepAlive ?yes|no? \fR
Sets/gets the "Keep Alive" flag for
the tcp connection associated with \fIsockId\fP.  If the "Keep Alive" flag
is on, the system sends periodic transmission of messages on a tcp
socket.  Should  the connected  party fail to respond to these messages,
the connection is considered broken and will be closed automatically.
The default value is "no."

.SH "SEE ALSO"
setsockopt(2), getsockopt(2),  dp_connect(n)

.SH AUTHOR
Brian Smith (bsmith@cs.berkeley.edu)
.br
Steve Yen (syen@cs.berkeley.edu)
.br
Stephen Tu (tus@roger-rabbit.cs.berkeley.edu)
