'\"
'\" Copyright (c) 1990 The Regents of the University of California.
'\" All rights reserved.
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" documentation for any purpose, provided that the above copyright
'\" notice and the following two paragraphs appear in all copies.
'\"
'\" IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
'\" FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
'\" ARISING OUT OF THE USE OF THIS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
'\" CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'\"
'\" THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
'\" AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
'\" ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
'\" 
.so man.macros
.HS dp_atclose tcldp


.SH NAME
.BS
dp_atclose \- arrange for commands to be evaluated when a file or socket
is closed
.BE
.TP
\fBdp_atclose \fIsockId\fR option ?\fIcmd\fR?

The dp_atclose command manages the \fIdp_atclose list\fP, a list of
callback routines that are evaluated just before \fIsockId\fP is actually
closed.  This is useful for networking applications, where filehandlers
associated with a socket must be deleted when a socket is closed.
The argument \fIoption\fP specifies the operation to be performed
on the dp_atclose list.  The valid options are:

.RS
.TP
\fBdp_atclose \fIsockId\fR list

Returns the current dp_atclose list associated with \fIsockId\fR.

.TP
\fBdp_atclose \fIsockId\fR set \fInewList\fP

Sets the dp_atclose list associated with \fIsockId\fR to \fInewList\fP.

.TP
\fBdp_atclose \fIsockId\fR append \fIcallback\fP

Append \fIcallback\fP to the end of the dp_atclose list associated with
\fIsockId\fR.

.TP
\fBdp_atclose \fIsockId\fR appendUnique \fIcallback\fP

Appends \fIcallback\fP to the end of the dp_atclose list associated with
\fIsockId\fR if it's not already a member of the list.

.TP
\fBdp_atclose \fIsockId\fR prepend \fIcallback\fP

Inserts \fIcallback\fP at the front of the dp_atclose list associated
with \fIsockId\fR.

.TP
\fBdp_atclose \fIsockId\fR insert \fIbeforeCallback\fP \fIcallback\fP

Inserts \fIcallback\fP before \fIbeforeCallback\fP in the dp_atclose
list associated with \fIsockId\fR.  If \fIbeforeCallback\fP is not in
the dp_atclose list associated with \fIsockId\fR, no action is taken.

.TP
\fBdp_atclose \fIsockId\fR delete \fIcallback\fP

Delete \fIcallback\fP from the dp_atclose list associated with
\fIsockId\fR. If \fIcallback\fP is not in the dp_atclose list associated
with \fIsockId\fR, no action is taken.

.TP
\fBdp_atclose \fIsockId\fR clear

Clears the dp_atclose list associated with \fIsockId\fR.

.SH AUTHOR
Brian Smith (bsmith@cs.berkeley.edu)
.br
Steve Yen (syen@cs.berkeley.edu)
