'\"
'\" Copyright (c) 1990 The Regents of the University of California.
'\" All rights reserved.
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" documentation for any purpose, provided that the above copyright
'\" notice and the following two paragraphs appear in all copies.
'\"
'\" IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
'\" FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
'\" ARISING OUT OF THE USE OF THIS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
'\" CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'\"
'\" THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
'\" AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
'\" ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
'\" 
.so man.macros
.HS dp_address tcldp
.BS
.SH NAME
dp_address \- internet address record manipulation
.BE
.TP
\fBdp_address \fIoption ?arg arg ...?\fR

The dp_address command provides access to an internal array of
internet address records.  These address records are appropriate
for use as arguments to the dp_sendTo and receiveFrom
network communication commands of Tcl-DP (Tcl Distributed
Programming).  The argument \fIoption\fP specifies the operation
to be performed.  The valid options are:
.RS
.TP
\fBdp_address create \fIhost port\fR

Creates an internal address record that represents the given
\fIhost\fR address and \fIport\fR internet information.
Returns an \fIaddr\fR handle that is appropriate for use as an
argument to the dp_sendTo and dp_receiveFrom commands and
as the \fIaddr\fP argument in the commands below.
\fIPort\fP can be specified by number or
by service name (see services(5) for more information).
If specified by service name, it must be a UDP service.
.TP
\fBdp_address delete \fIaddr\fR

Delete the previously created internal address record that has
the given \fIaddr\fP handle.
.TP
\fBdp_address info \fIaddr\fR

Return a list of the form \fI{host port}\fP, which is the
internet information stored with the given \fIaddr\fR handle.
.SH AUTHOR
Brian Smith (bsmith@cs.berkeley.edu)
.br
Steve Yen (syen@cs.berkeley.edu)
.br
Stephen Tu (tus@roger-rabbit.cs.berkeley.edu)
