#
# TCL Library for tkcvs
#

#
# workdir.tcl,v 1.14 1995/03/22 08:19:24 del Exp
#
# Current working directory display.  Handles all of the functions
# concerned with navigating about the current directory on the main
# window.
#

proc workdir_setup {} {
  global cwd
  global module_dir
  global cvscfg

  frame .left
  frame .right
  frame .down -relief groove -border 2

  pack .down -side bottom -fill x
  pack .left -side left -fill both
  pack .right -side left -fill both -expand 1

  label .lcwd -text "Current Directory" -anchor w
  label .lmodule -text "Module Location" -anchor w
  label .lfiles -text "Files" -anchor w

  entry .tcwd -relief sunken -textvariable cwd
  bind_motifentry .tcwd
  label .tmodule -textvariable module_dir -anchor w
  scrollbar .scroll -command {.list yview} -relief sunken
  listbox .list -yscroll {.scroll set} -relief sunken \
    -geometry 40x20 -setgrid yes

  bind .tcwd <Return> {setup_dir}
  bind .list <Double-Button-1> {
    eval "workdir_act_on_file [workdir_list_files]"
  }

  pack .lcwd .lmodule .lfiles -in .left \
    -side top -fill x -pady 3
  pack .tcwd .tmodule -in .right \
    -side top -fill x -pady 3

  pack .scroll -in .right -side right -fill y -padx 2 -pady 2
  pack .list -in .right -side left -fill both -expand 1

  button .bcheck -relief raised -text "Check" \
    -command cvs_check
  button .badd_files -relief raised -text "Add Files" \
    -command { 
      eval "cvs_add [workdir_list_files]"
    }
  button .bdelete_files -relief raised -text "Delete Files" \
    -command {
      eval "cvs_remove [workdir_list_files]"
    }
  button .bcheckin -relief raised -text "Check In" \
    -command commit_run
  button .bcheckout -relief raised -text "Browse & Check Out" \
    -command checkout_run
  button .btag -relief raised -text "Tag Files" \
    -command tag_run
  button .bimport -relief raised -text "Import" \
    -command import_run
  button .bquit -relief raised -text "Quit" \
    -command exit

  pack .bcheck .badd_files .bdelete_files \
    .bcheckin .bcheckout .bimport .bquit \
    -ipadx 2 -ipady 2 -padx 4 -pady 4 \
    -in .down -side left -fill both -expand 1

  setup_dir
}

proc workdir_list_files {} {

  foreach item [.list curselection] {
    if [info exists getlist] {
      lappend getlist [.list get $item]
    } else {
      set getlist [.list get $item]
    }
  }

  if [info exists getlist] {
    return $getlist
  } else {
    return {}
  }
}

proc workdir_act_on_file {filename} {
  global cvscfg

  if [file isdirectory $filename] {
    change_dir $filename
  } else {
    if {$cvscfg(editorargs) == {}} {
      exec $cvscfg(editor) $filename &
    } else {
      exec $cvscfg(editor) $cvscfg(editorargs) $filename &
    }
  }
}

proc change_dir {new_dir} {
  global cwd

  set cwd $new_dir
  setup_dir
}

proc setup_dir {} {
#
# Call this when entering a directory.  It puts all of the file names
# in the listbox, and reads the CVS or CVS.adm directory.
#
  global cwd
  global module_dir
  global incvs
  global cvscfg

  .list delete 0 end
  set module_dir "Not in the repository"
  set incvs 0

  if [file isdirectory $cwd] {
    cd $cwd
    set cwd [pwd]
    if {$cvscfg(allfiles)} {
      set filelist [exec ls -a]
    } else {
      set filelist [concat ".." [exec ls]]
    }
    foreach i $filelist {
      if {$i == "CVS"} {
        # New format CVS directory
        read_cvs_dir $cwd/$i
      } elseif {$i == "CVS.adm"} {
        # Old format CVS.adm directory
        read_cvs_adm_dir $cwd/$i
      } else {
        .list insert end $i
      }
    }
  } else {
    set module_dir "No Such Directory!"
  }

}

proc read_cvs_adm_dir {dirname} {
#
# Reads an old format CVS.adm directory
#
  global module_dir
  global incvs

  if [file isdirectory $dirname] {
    if [file isfile $dirname/Repository] {
      set module_dir [exec cat $dirname/Repository]
      set incvs 1
    } else {
      cvserror "Repository file not found in $dirname"
    }
  } else {
    cvserror "$dirname is not a directory"
  }
}

proc read_cvs_dir {dirname} {
#
# Reads a new format CVS directory
#
  global module_dir
  global incvs

  if [file isdirectory $dirname] {
    if [file isfile $dirname/Repository] {
      set module_dir [exec cat $dirname/Repository]
      set incvs 1
    } else {
      cvserror "Repository file not found in $dirname"
    }
  } else {
    cvserror "$dirname is not a directory"
  }
}

