#
# Tcl Library for tkCVS
#

#
# import.tcl,v 1.6 1995/03/05 00:04:10 del Exp
#
# Adds a new document to the repository.
#

proc import_setup {} {
  global cvsglb

  toplevel .import
  frame .import.left
  frame .import.right
  frame .import.down -relief groove -border 2

  # When packing, I only want the right hand side and the buttons
  # to be interactively strechable (in case the user wants more space
  # to enter long document names).

  pack .import.down -side bottom -fill x -expand 1
  pack .import.left -side left -fill y
  pack .import.right -side left -fill both -expand 1

  label .import.lnewdir  -text "Module Directory" -anchor w
  label .import.lnewname -text "Module Name" -anchor w
  label .import.lnewvers  -text "Version Number" -anchor w
  label .import.lnewcode -text "Module Code" -anchor w

  entry .import.tnewdir -relief sunken -textvariable cvsglb(newdir) -width 40
  entry .import.tnewname -relief sunken -textvariable cvsglb(newname) -width 40
  entry .import.tnewvers -relief sunken -textvariable cvsglb(newvers) -width 40
  entry .import.tnewcode -relief sunken -textvariable cvsglb(newcode) -width 40

  bind_motifentry .import.tnewdir
  bind_motifentry .import.tnewname
  bind_motifentry .import.tnewvers
  bind_motifentry .import.tnewcode

  pack .import.lnewdir .import.lnewname \
    .import.lnewvers .import.lnewcode -in .import.left \
    -side top -fill x -pady 3

  pack .import.tnewdir .import.tnewname \
    .import.tnewvers .import.tnewcode -in .import.right \
    -side top -fill both -expand 1 -pady 3

  button .import.ok -text "OK" \
    -command do_import
  button .import.newdir -text "New Directory" \
    -command inewdir_run
  button .import.quit -text "Quit" \
    -command { wm withdraw .import }

  pack .import.ok .import.newdir .import.quit -in .import.down -side left \
    -ipadx 2 -ipady 2 -padx 4 -pady 4 -fill both -expand 1

  wm withdraw .import
  wm title .import "Import a New Module"
  wm minsize .import 1 1

  toplevel .inewdir
  frame .inewdir.left
  frame .inewdir.right
  frame .inewdir.down -relief groove -border 2

  # When packing, I only want the right hand side and the buttons
  # to be interactively strechable (in case the user wants more space
  # to enter long document names).

  pack .inewdir.down -side bottom -fill x -expand 1
  pack .inewdir.left -side left -fill y
  pack .inewdir.right -side left -fill both -expand 1

  label .inewdir.lnewdir  -text "New Directory Location" -anchor w
  label .inewdir.lnewname -text "New Directory Name" -anchor w

  entry .inewdir.tnewdir -relief sunken -textvariable cvsglb(dnewdir) -width 40
  entry .inewdir.tnewname -relief sunken -textvariable cvsglb(dnewname) -width 40

  bind_motifentry .inewdir.tnewdir
  bind_motifentry .inewdir.tnewname

  pack .inewdir.lnewdir .inewdir.lnewname \
    -in .inewdir.left \
    -side top -fill x -pady 3

  pack .inewdir.tnewdir .inewdir.tnewname \
    -in .inewdir.right \
    -side top -fill both -expand 1 -pady 3

  button .inewdir.ok -text "OK" \
    -command do_inewdir
  button .inewdir.quit -text "Quit" \
    -command { wm withdraw .inewdir }

  pack .inewdir.ok .inewdir.quit -in .inewdir.down -side left \
    -ipadx 2 -ipady 2 -padx 4 -pady 4 -fill both -expand 1

  wm withdraw .inewdir
  wm title .inewdir "Import a New Directory"
  wm minsize .inewdir 1 1
}

proc import_run {} {
  global cvsglb
  global cvscfg
  global cwd

  if {$cvscfg(cvsver) < 1.3} {
    cvserror "This function is not available in CVS version $cvscfg(cvsver).

Please upgrade your CVS to version 1.3 or later or use Add instead."
    return 1
  }

  set cvsglb(newcode) [file tail $cwd]
  wm deiconify .import
}

proc inewdir_run {} {
  wm deiconify .inewdir
}

proc do_import {} {
  global cvsglb
  global cvs
  global cwd
  global incvs

  # Error checks

  if {$incvs} {
    cvserror "This directory is already in CVS.\nCant import here!"
    return 1
  }

  if { $cvsglb(newdir) == "" } {
    cvserror "You must type in a directory!"
    return 1
  }
  if { $cvsglb(newname) == "" } {
    cvserror "You must type in a module name!"
    return 1
  }
  if { $cvsglb(newvers) == "" } {
    cvserror "You must type in a version number!"
    return 1
  }
  if { $cvsglb(newcode) == "" } {
    cvserror "You must type in a module code!"
    return 1
  }

  # Get the version number into the correct format.

  set versions [split $cvsglb(newvers) ".,/ "]
  while {[llength $versions] < 3} {
    lappend versions 0
  }
  set cvsglb(newvers) [join $versions "."]

  # Make a baseline tag

  set baseline "baseline-[lindex $versions 0]"

  # Make a date tag

  set datetag "date-[exec date +%d%h%y]"

  catch \
    {exec $cvs import -b $cvsglb(newvers) -m "Imported using tkCVS" \
               $cvsglb(newdir) $baseline $datetag} \
    view_this

  view_output "CVS IMPORT" $view_this

  # Update the modules file.

  cd
  catch {exec $cvs co modules}
  cd modules
  set modfile [open modules a]
    puts $modfile ""
    puts $modfile "#M	$cvsglb(newcode)	$cvsglb(newname)"
    puts $modfile "$cvsglb(newcode)	$cvsglb(newdir)"
  close $modfile
  catch {exec $cvs ci -m "added $cvsglb(newcode)" modules}
  cd $cwd

  read_modules_setup
  checkout_fill_listbox
  wm withdraw .import
}

proc do_inewdir {} {
  global cvsglb
  global cvs
  global cwd

  # Error checks

  if { $cvsglb(dnewdir) == "" } {
    cvserror "You must type in a directory!"
    return 1
  }
  if { $cvsglb(dnewname) == "" } {
    cvserror "You must type in a directory name!"
    return 1
  }

  cd
  catch {exec $cvs co modules}
  cd modules
  set modfile [open modules a]
    puts $modfile ""
    puts $modfile "#D	$cvsglb(dnewdir)	$cvsglb(dnewname)"
  close $modfile
  catch {exec $cvs ci -m "added $cvsglb(dnewdir)" modules}
  cd $cwd

  read_modules_setup
  checkout_fill_listbox
}
