#
# Tcl library for TkCVS
#

#
# filebrowse.tcl,v 1.1 1995/03/22 08:20:04 del Exp
#
# Sets up a dialog to browse the contents of a module.
#

proc browse_files {mcode} {
  global filenames
  global mtitle

  static {browser 0}

  if {! [info exists mtitle($mcode)]} {
    cvserror "Sorry, this function only works on modules, not directories!"
    return
  }

  # Find the list of file names.
  find_filenames $mcode

  if {! [info exists filenames($mcode)]} {
    cvserror "There are no files in this module!"
    return
  }

  #
  # Create the browser window.
  #

  incr browser
  set filebrowse ".filebrowse$browser"
  toplevel $filebrowse
  frame $filebrowse.down -relief groove -border 2

  pack $filebrowse.down -side bottom -fill x

  #
  # Create buttons
  #

  button $filebrowse.view -text "View" \
    -command "fileview $filebrowse.list $mcode"
  button $filebrowse.log -text "Log" \
    -command "filelog $filebrowse.list $mcode"
  button $filebrowse.quit -text "Quit" \
    -command "destroy $filebrowse"
  pack $filebrowse.view $filebrowse.log $filebrowse.quit \
    -in $filebrowse.down -side left \
    -ipadx 2 -ipady 2 -padx 4 -pady 4 -fill both -expand 1

  #
  # Create a scrollbar and a list box.
  #

  scrollbar $filebrowse.scroll -relief sunken \
    -command "$filebrowse.list yview"
  listbox $filebrowse.list \
    -yscroll "$filebrowse.scroll set" -relief sunken \
    -geometry 40x15 -setgrid yes
  pack $filebrowse.scroll -side right -fill y -padx 2 -pady 2
  pack $filebrowse.list -side left -fill both -expand 1

  #
  # Window manager stuff.
  #

  wm title $filebrowse "Files in $mcode"
  wm minsize $filebrowse 1 1

  #
  # Fill the list.
  #
  foreach file $filenames($mcode) {
    $filebrowse.list insert end $file
  }
}

proc filelog {listname mcode} {

  foreach item [$listname curselection] {
    cvs_filelog $mcode [$listname get $item]
  }

}

proc fileview {listname mcode} {
  global checkout_version

  foreach item [$listname curselection] {
    cvs_fileview $mcode [$listname get $item] $checkout_version
  }

}
