#
# TCL Library for tkCVS
#

#
# cvs.tcl,v 1.20 1995/03/22 08:19:23 del Exp
# 
# Contains procedures used in interaction with CVS.
#

proc cvs_notincvs {} {
  cvserror "This directory is not in CVS.\nPlease import it first."
}

proc cvs_incvs {} {
  cvserror "You cant do that here because this directory is already in CVS."
}

proc cvs_remove args {
#
# This deletes a file from the directory and the repository,
# asking for confirmation first.
#
  global cvs
  global incvs

  if {$args == "{}"} {
    cvserror "Please select some files to delete first!"
    return
  }

  set mess "This will delete these files:\n\n"

  foreach file $args {
    set mess "$mess   $file\n"
  }

  set mess "$mess\nAre you sure?"
  set confirm [tk_dialog .message {Confirm!} $mess warning 1 OK Quit]

  if {$confirm == 0} {
    foreach file $args {
      exec rm -rf $file
      if {$incvs} {
        catch {eval "exec $cvs delete $file"}
      }
    }
    setup_dir
  }
}

proc cvs_add args {
#
# This adds a file to the repository.
#
  global cvs
  global incvs

  if {! $incvs} {
    cvs_notincvs
    return 1
  }

  if {$args == "{}"} {
    set mess "This will add all new files!"
  } else {
    set mess "This will add these files:\n\n"
    foreach file $args {
      set mess "$mess   $file\n"
    }  
  }

  set mess "$mess\nAre you sure?"
  set confirm [tk_dialog .message {Confirm!} $mess warning 0 OK Quit]

  if {$confirm == 0} {
    if {$args == "{}"} {
      foreach file [glob -nocomplain *] {
        catch {eval "exec $cvs add $file"} view_this
        # Probably don't need to see the output, but you can uncomment this
        # line if you like.
        # view_output "CVS Add" $view_this
      }
    } else {
      foreach file $args {
        catch {eval "exec $cvs add $file"} view_this
        # view_output "CVS Add" $view_this
      }
    }
  }
}

proc cvs_diff args {
#
# This diffs a file with the repository.
#
  global cvs
  global incvs

  if {! $incvs} {
    cvs_notincvs
    return 1
  }

  if {$args == "{}"} {
    set filelist "."
  } else {
    set filelist $args
  }
  catch {eval "exec $cvs diff $filelist"} view_this
  view_output "CVS Diff" $view_this
}

proc cvs_log args {
#
# This looks at a log from the repository.
#
  global cvs
  global incvs

  if {! $incvs} {
    cvs_notincvs
    return 1
  }

  if {$args == "{}"} {
    set filelist "."
  } else {
    set filelist $args
  }
  catch {eval "exec $cvs log $filelist"} view_this
  view_output "CVS Log" $view_this
}

proc cvs_commit {version comment args} {
#
# This commits changes to the repository.
#
# The parameters work differently here -- args is a list.  The first
# element of args is a list of file names.  This is because I can't
# use eval on the parameters, because comment contains spaces.
#
  global cvs
  global cvscfg
  global incvs
  global filelist

  # puts stderr "Version = $version"
  # puts stderr "Comment = $comment"

  if {! $incvs} {
    cvs_notincvs
    return 1
  }

  if {$comment == ""} {
    cvserror "You must enter a comment!"
    return 1
  }

  if {$args == "{}"} {
    set filelist "."
    if {$cvscfg(cvsver) < 1.3} {
      cvserror "You must select files to be committed with CVS version $cvscfg(cvsver).

Either select a list of files or upgrade your CVS to version 1.3"
      return
    }
  } else {
    set filelist [lindex $args 0]
  }

  set mess "This will commit your changes.\nAre you sure?"
  set confirm [tk_dialog .message {Confirm!} $mess warning 0 OK Quit]

  set commit_output ""
  if {$confirm == 0} {
    if {$version != ""} {
      if {$cvscfg(cvsver) < 1.3} {
        foreach file $filelist {
          # puts stderr "1 Committing $file"
          catch {exec $cvs commit -f -r $version -m "$comment" $file} \
            commit_tmp
          set commit_output "$commit_output\n$commit_tmp"
        }
      } else {
        foreach file $filelist {
          # puts stderr "2 Committing $file"
          catch {exec $cvs commit -r $version -m "$comment" $file} \
            commit_tmp
          set commit_output "$commit_output\n$commit_tmp"
        }
      }
    } else {
      if {$cvscfg(cvsver) < 1.3} {
        foreach file $filelist {
          # puts stderr "3 Committing $file"
          catch {exec $cvs commit -f -m "$comment" $file} \
            commit_tmp
          set commit_output "$commit_output\n$commit_tmp"
        }
      } else {
        foreach file $filelist {
          # puts stderr "4 Committing $file"
          catch {exec $cvs commit -m "$comment" $file} \
            commit_tmp
          set commit_output "$commit_output\n$commit_tmp"
        }
      }
    }
    view_output "CVS Commit" $commit_output
  }
}

proc cvs_tag {tagname branch args} {
#
# This tags a file in a directory.
#
  global cvs
  global cvscfg
  global incvs
  global filelist

  if {$cvscfg(cvsver) < 1.3} {
    cvserror "This function is not supported in CVS version $cvscfg(cvsver).

Please upgrade your CVS to version 1.3"
    return
  }

  if {! $incvs} {
    cvs_notincvs
    return 1
  }

  if {$tagname == ""} {
    cvserror "You must enter a tag name!"
    return 1
  }

  if {$args == "{}"} {
    set filelist "."
  } else {
    set filelist $args
  }

  if {$branch == "yes"} {
    catch {eval "exec $cvs tag -b $tagname $filelist"} tag_output
    catch {eval "exec $cvs update -r $tagname $filelist"} tag_output2
    set tag_output "$tag_output\n\n$tag_output2"
  } else {
    catch {eval "exec $cvs tag $tagname $filelist"} tag_output
  }
  view_output "CVS Tag" $tag_output
}

proc cvs_update {tagname args} {
#
# This updates the files in the current directory.
#
  global cvs
  global incvs

  if {! $incvs} {
    cvs_notincvs
    return 1
  }

  if {$args == "{}"} {
    set filelist "."
  } else {
    set filelist $args
  }

  set mess "This will update this directory from CVS.\nAre you sure?"
  set confirm [tk_dialog .message {Confirm!} $mess warning 0 OK Quit]

  if {$confirm == 0} {
    if {$tagname == ""} {
      catch {eval "exec $cvs update $filelist"} view_this
    } else {
      catch {eval "exec $cvs update -r $tagname $filelist"} view_this
    }
    view_output "CVS Update" $view_this
    setup_dir
  }
}

proc cvs_status args {
#
# This does a status report on the files in the current directory.
#
  global cvs
  global incvs
  global cvscfg

  if {! $incvs} {
    cvs_notincvs
    return 1
  }

  if {$args == "{}"} {
    set filelist "."
  } else {
    set filelist $args
  }

  if {$cvscfg(cvsver) < 1.3} {
    catch {eval "exec $cvs status $filelist"} view_this
  } else {
    catch {eval "exec $cvs -Q status $filelist"} view_this
  }
  view_output "CVS Status" $view_this
}

proc cvs_check {} {
#
# This does a cvscheck on the files in the current directory.
#
  global cvs
  global incvs
  global cvscfg

  if {! $incvs} {
    cvs_notincvs
    return 1
  }

  catch {exec cvscheck $cvscfg(checkrecursive)} view_this
  view_output "CVS Check" $view_this
}

proc cvs_checkout {mcode version} {
#
# This checks out a new module into the current directory.
#
  global cvs
  global incvs

  if {$incvs} {
    cvs_incvs
    return 1
  }

  set mess "This will check out $mcode from CVS.\nAre you sure?"
  set confirm [tk_dialog .message {Confirm!} $mess warning 0 OK Quit]

  if {$confirm == 0} {
    if {$version == {}} {
      catch {exec $cvs co $mcode} view_this
    } else {
      catch {exec $cvs co -r $version $mcode} view_this
    }
    view_output "CVS Checkout" $view_this
    setup_dir
  }
}

proc cvs_fileview {mcode filename version} {
#
# This looks at a version of a file from the repository without
# checking it out.
#
  global cvs
  global cvsroot
  global location

  if {$version == {}} {
    catch {exec co -p $cvsroot/$location($mcode)/$filename} view_this
  } else {
    catch {exec co -p$version $cvsroot/$location($mcode)/$filename} view_this
  }
  view_output "CVS File View" $view_this
}

proc cvs_filelog {mcode filename} {
#
# This looks at a revision log of a file from the repository without
# checking it out.
#
  global cvs
  global cvsroot
  global location

  catch {exec rlog $cvsroot/$location($mcode)/$filename} view_this
  view_output "CVS File Log" $view_this
}

proc cvs_export {mcode version} {
#
# This exports a new module (see man cvs and read about export) into
# the current directory.
#
  global cvs
  global incvs
  global cvscfg

  if {$incvs} {
    cvs_incvs
    return 1
  }

  if {$cvscfg(cvsver) < 1.3} {
    cvserror "This function is not supported in CVS version $cvscfg(cvsver).

Please upgrade your CVS to version 1.3"
    return
  }

  if {$version == {}} {
    cvserror "You must enter a tag name for this function."
    return
  }

  set mess "This will export $mcode from CVS.\nAre you sure?"
  set confirm [tk_dialog .message {Confirm!} $mess warning 0 OK Quit]

  if {$confirm == 0} {
    catch {exec $cvs export -r $version $mcode} view_this
    view_output "CVS Export" $view_this
    setup_dir
  }
}

proc cvs_patch {mcode version1 version2} {
#
# This creates a patch file between two versions of a module.  If the
# second version is null, it creates a patch to the head version.
#
  global cvs
  global cvscfg
 
  if {$version1 == {}} {
    cvserror "You must enter a tag name for this function."
    return
  }
 
  set mess "This will make a patch file for $mcode from CVS.\nAre you sure?"
  set confirm [tk_dialog .message {Confirm!} $mess warning 0 OK Quit]
 
  if {$confirm == 0} {
    if {$version2 == {}} {
      catch {exec $cvs patch -r $version1 $mcode > $mcode.pat} view_this
    } else {
      catch {exec $cvs patch -r $version1 -r $version2 $mcode > $mcode.pat} \
        view_this
    }
    set view_this "$view_this\n\nPatch file $mcode.pat created."
    view_output "CVS Patch" $view_this
    setup_dir
  }
}

proc cvs_patch_summary {mcode version1 version2} {
#
# This creates a patch summary of a module between 2 versions.
#
  global cvs
  global cvscfg
 
  if {$version1 == {}} {
    cvserror "You must enter a tag name for this function."
    return
  }
 
  if {$version2 == {}} {
    catch {exec $cvs patch -s -r $version1 $mcode} view_this
  } else {
    catch {exec $cvs patch -s -r $version1 -r $version2 $mcode} view_this
  }
  view_output "CVS Patch Summary" $view_this
}

proc cvs_version {} {
#
# This shows the current CVS version number.
#
  global cvs

  catch {exec $cvs -v} view_this
  view_output "CVS Version" $view_this
}

proc cvs_rtag {mcode branch tagname} {
#
# This tags a module in the repository.
#
  global cvs
  global cvscfg

  if {$cvscfg(cvsver) < 1.3} {
    set command "tag"
  } else {
    set command "rtag"
  }

  if {$branch == "yes"} {
    if {$cvscfg(cvsver) < 1.3} {
      cvserror "This function is not supported in CVS version $cvscfg(cvsver).

Please upgrade your CVS to version 1.3"
      return
    }
  }

  if {$tagname == ""} {
    cvserror "You must enter a tag name!"
    return 1
  }

  set mess "This will tag $mcode in CVS.\nAre you sure?"
  set confirm [tk_dialog .message {Confirm!} $mess warning 0 OK Quit]

  if {$confirm == 0} {
    if {$branch == "yes"} {
      catch {exec $cvs $command -b $tagname $mcode} view_this
    } else {
      catch {exec $cvs $command $tagname $mcode} view_this
    }
    view_output "CVS Rtag" $view_this
  }
}

proc cvs_usercmd {args} {
#
# Allows the user to run a user-specified cvs command.
#
  global cvs

  catch {eval "exec $cvs $args"} view_this
  view_output "CVS [lindex $args 0]" $view_this
}

proc cvs_anycmd {args} {
#
# Allows the user to run any user-specified command.
#
  catch {eval "exec $args"} view_this
  view_output [lindex $args 0] $view_this
}

proc view_output {title output_string} {
#
# Set up a dialog containing a text box that can be used to view
# the report on the screen.
#
  static {viewer 0}

  incr viewer
  set cvsview ".cvsview$viewer"
  toplevel $cvsview
  text $cvsview.text -setgrid yes -relief sunken -border 2 \
    -yscroll "$cvsview.scroll set"
  scrollbar $cvsview.scroll -relief sunken \
    -command "$cvsview.text yview"
  button $cvsview.ok -text "OK" \
    -command "destroy $cvsview"

  pack $cvsview.ok -side bottom -fill x
  pack $cvsview.scroll -side right -fill y -padx 2 -pady 2
  pack $cvsview.text -fill both -expand 1

  wm title $cvsview "$title Output"

  $cvsview.text insert end $output_string
  $cvsview.text configure -state disabled
}
