#
# Tcl Library for tkCVS
#
 
# 
# commit.tcl,v 1.5 1995/02/10 07:10:38 del Exp
#
# Set up a small commit dialog.
#

proc commit_setup {} {

  toplevel .commit
  frame .commit.left
  frame .commit.right
  frame .commit.down -relief groove -border 2

  pack .commit.down -side bottom -fill x
  pack .commit.left -side left -fill y
  pack .commit.right -side left -fill both -expand 1

  label .commit.lvers -text "Version Number" -anchor w
  label .commit.lcomment -text "Comment" -anchor w

  entry .commit.tvers -relief sunken -textvariable version
  text  .commit.tcomment -relief sunken -width 40 -height 10 \
    -wrap word -border 2 -setgrid yes

  bind_motifentry .commit.tvers
  bind_motiftext  .commit.tcomment

  pack .commit.lvers .commit.lcomment -in .commit.left \
    -side top -fill x -pady 3
 
  pack .commit.tvers -in .commit.right \
    -side top -fill x -pady 3
 
  pack .commit.tcomment -in .commit.right \
    -side top -fill both -expand 1 -pady 3
 
  button .commit.ok -text "OK" \
    -command {
      cvs_commit $version [.commit.tcomment get 1.0 end] [workdir_list_files]
      wm withdraw .commit
    }
  button .commit.quit -text "Quit" -command { wm withdraw .commit }
 
  pack .commit.ok .commit.quit -in .commit.down -side left \
    -ipadx 2 -ipady 2 -padx 4 -pady 4 -fill both -expand 1
 
  wm withdraw .commit
  wm title .commit "Commit Changes to a Document"
  wm minsize .commit 1 1
}

proc commit_run {} {
  global incvs

  if {! $incvs} {
    cvserror "This directory is not in CVS.\nPlease import it first."
    return 1
  }

  wm deiconify .commit
}
