/*
 *  -----------------------------------------------------------------
 *    Copyright 1993 D.I.S. - Universita` di Pavia - Italy
 *  -----------------------------------------------------------------
 *
 *  Permission to  use,  copy,   modify,   distribute  this  software
 *  and  its  documentation for any purpose is hereby granted without
 *  fee, provided that the above copyright  notice   appear   in  all
 *  copies   and  that both that copyright notice and this permission
 *  notice appear in supporting documentation, and that the  name  of
 *  D.I.S.   not  be  used  in advertising or publicity pertaining to
 *  distribution of the software without specific, written prior per-
 *  mission.   D.I.S.  makes no representations about the suitability
 *  of this software for any purpose.  It is provided "as is" without
 *  express or implied warranty.
 *
 *  D.I.S. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, IN-
 *  CLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 *  NO EVENT SHALL D.I.S.  BE LIABLE FOR  ANY  SPECIAL,  INDIRECT  OR
 *  CONSEQUENTIAL  DAMAGES  OR  ANY DAMAGES WHATSOEVER RESULTING FROM
 *  LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION  OF  CONTRACT,
 *  NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNEC-
 *  TION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <tcl.h>


Tcl_CmdProc Demo_FactCmd;


int Demo_FactCmd(notUsed, interp, argc, argv)
	ClientData notUsed;
	Tcl_Interp *interp;
	int argc;
	char **argv;
{
	long n, f;

	if (argc != 2 ) {
		Tcl_AppendResult(interp, "usage : ", argv[0], " <n>", NULL);
		return TCL_ERROR;
	}

	if ( (n=atol(argv[1])) < 0 ) {
		Tcl_AppendResult(interp, argv[0], " : negative argument", NULL);
		return TCL_ERROR;
	}

	f=( n == 0 )? 1 : n;
	while ( --n > 1 ) f*=n;

	sprintf(interp->result, "%ld", f);
	return TCL_OK;
}

