#  Copyright (c) 1994 A & A Custom Software.
#  All rights reserved.
# 
#  Redistribution and use in source and binary forms, with or without
#  modification, are permitted provided that the following conditions
#  are met:
#  1. Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in the
#     documentation and/or other materials provided with the distribution.
#  3. All advertising materials mentioning features or use of this software
#     must display the following acknowledgement:
#       This product includes software developed by A & A Custom Software 
#       and its contributors.
#  4. Neither the name of A & A Custom Software nor the names of its 
#     contributors may be used to endorse or promote products derived from this 
#     software without specific prior written permission.
# 
#  THIS SOFTWARE IS PROVIDED BY A & A CUSTOM SOFTWARE AND CONTRIBUTORS ``AS IS''
#  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
#  ARE DISCLAIMED.  IN NO EVENT SHALL A & A CUSTOM SOFTWARE OR CONTRIBUTORS BE 
#  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
#  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
#  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
#  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
#  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
#  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
#  POSSIBILITY OF SUCH DAMAGE.
# 
# $Id: ut_searchEntries.t,v 1.3 1994/11/06 20:43:20 andy Exp $
#
set searchDialog(title) {User Search Dialog}
set searchDialog(msgFont) {*helvetica*bold-r*14*}

proc searchToplevel { w } {

    global searchDialog
    toplevel $w

    #
    # Message and Input area
    #
    frame $w.top -relief flat -border 8
    entry $w.top.input -relief $searchDialog(entryRelief) -border 1
    message $w.top.msg -justify left -anchor w -aspect 2000 \
	-text $searchDialog(message) -font $searchDialog(msgFont)

    #
    # Button area
    #
    frame $w.bot -relief groove -border 2

    pack $w.top.msg -side top -fill x -expand 1
    pack $w.top.input -side top -fill x -expand 1
    pack $w.top -side top -fill both -expand 1
    pack $w.bot -side top -fill both -expand 1

    #
    # Previous button
    #
    button $w.bot.0 -text "PREVIOUS" -command "searchPrevious $w.top.input"
    pack $w.bot.0 -side left -expand 1

    #
    # Next button
    #
    button $w.bot.1 -text "NEXT" -command "searchNext $w.top.input"
    pack $w.bot.1 -side left -expand 1

    #
    # Done button
    #
    button $w.bot.2 -text "DONE" -command "searchDone $w"
    pack $w.bot.2 -side left -expand 1

    #
    # Bindings
    #
    bind $w.top.input <Return> "searchNext $w.top.input"
    bind $w <Return> "searchNext $w.top.input"
    bind $w.top.input <Shift-Tab> "searchPrevious $w.top.input"
    bind $w <Shift-Tab> "searchPrevious $w.top.input"
    focus $w.top.input

    wm title $w $searchDialog(title)
    wm minsize $w 300 150
    wm geometry $w 300x150

}

proc searchNext { w } {
    global searchDialog

    if {![winfo exists $searchDialog(listbox)]} {
	return
    }
    set entries [$searchDialog(listbox) size]
    set curEntry [$searchDialog(listbox) curselection]
    if {$curEntry == ""} {
	set curEntry 0
    } else {
	incr curEntry
    }
    set searchDialog(findpat) [$w get] 
    for {set i $curEntry} {$i < $entries} {incr i} {
	if {[regexp $searchDialog(findpat) [$searchDialog(listbox) get $i]]} {
	    $searchDialog(listbox) yview $i
	    $searchDialog(listbox) select from $i
	    break
	}
    }
}

proc searchPrevious { w } {
    global searchDialog

    if {![winfo exists $searchDialog(listbox)]} {
	return
    }
    set entries [$searchDialog(listbox) size]
    set curEntry [$searchDialog(listbox) curselection]
    if {$curEntry == ""} {
	set curEntry [expr $entries - 1]
    } else {
	incr curEntry -1
    }
    set searchDialog(findpat) [$w get] 
    for {set i $curEntry} {$i >= 0} {incr i -1} {
	if {[regexp $searchDialog(findpat) [$searchDialog(listbox) get $i]]} {
	    $searchDialog(listbox) yview $i
	    $searchDialog(listbox) select from $i
	    break
	}
    }
}

proc searchDone { w } {
    destroy [winfo toplevel $w]
}

proc searchGetOption { name } {

    global searchDialog 
    
    set largs [llength $searchDialog(args)]
    for {set x 0} {$x < $largs} {incr x} {
	set opt [lindex $searchDialog(args) $x]
	if {$opt == "-$name"} {
	    incr x
	    return [lindex $searchDialog(args) $x]
	}
    }

    # If here, we didn't find anything
    switch $name {
	message {return {Enter regular expression}} 
	listbox {return {}}
	entryRelief {return {sunken}}
	default {}
    }
}

proc ut_searchEntries { args } {
    global searchDialog
    set searchDialog(args) $args
    set searchDialog(listbox) [searchGetOption listbox] 
    set searchDialog(message) [searchGetOption message]
    set searchDialog(entryRelief) [searchGetOption entryRelief]
    searchToplevel .searchDialog
    wm protocol .searchDialog WM_DELETE_WINDOW "destroy .searchDialog"
}
