#  Copyright (c) 1994 A & A Custom Software.
#  All rights reserved.
# 
#  Redistribution and use in source and binary forms, with or without
#  modification, are permitted provided that the following conditions
#  are met:
#  1. Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in the
#     documentation and/or other materials provided with the distribution.
#  3. All advertising materials mentioning features or use of this software
#     must display the following acknowledgement:
#       This product includes software developed by A & A Custom Software 
#       and its contributors.
#  4. Neither the name of A & A Custom Software nor the names of its 
#     contributors may be used to endorse or promote products derived from this 
#     software without specific prior written permission.
# 
#  THIS SOFTWARE IS PROVIDED BY A & A CUSTOM SOFTWARE AND CONTRIBUTORS ``AS IS''
#  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
#  ARE DISCLAIMED.  IN NO EVENT SHALL A & A CUSTOM SOFTWARE OR CONTRIBUTORS BE 
#  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
#  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
#  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
#  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
#  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
#  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
#  POSSIBILITY OF SUCH DAMAGE.
# 
# $Id: ff_viewBatch.t,v 1.8 1994/11/03 05:23:33 andy Exp $
#
# Make a listbox to view the batch entries.
#

proc ff_viewBatch { t } {

    global batch_destinations 

    catch {destroy $t}
    toplevel $t

    set fn {*courier*bold-r*12*}

    wm title $t "Batch Recipients"
    wm minsize $t 100 100
    wm geometry $t 695x280

    global clen
    global plen
    global nlen

    ut_mkFrame $t {f {} {} oper {-relief flat} {-side bottom -fill x}}
    set style "%-${nlen}.${nlen}s  %-${clen}.${clen}s  %${plen}.${plen}s"
    set hdr [format "$style" "Name" "Company" "Phone"]
    set hdr_attr [list $hdr -font $fn -padx 20] 
    ut_mkLabel $t.f [list l_batch $hdr_attr {-side top -fill x}]

    scrollbar $t.f.scr -relief sunken -command "$t.f.bx yview"
    listbox $t.f.bx -yscroll "$t.f.scr set" -relief sunken -font $fn
    ut_mkButton $t.oper [list \
	    b_remove "REMOVE -command \{remove_recipient $t.f.bx\}" {} \
	    b_alias "ALIAS -command \{alias_batch $t.f.bx\}" {} \
	    b_clear "CLEAR -command \{clear_batch $t.f.bx\}" {} \
	    b_cancel "DISMISS -command \{destroy $t\}" {}]
    pack $t.f.scr -side left -fill y 
    pack $t.f.bx -side right -fill both -expand 1
    tk_listboxSingleSelect $t.f.bx

    foreach i $batch_destinations {
	$t.f.bx insert end $i
    }

}

proc clear_batch { w } {

    global batch_destinations

    set batch_destinations {}

    # Clear the batch listbox. Check
    # for window, since this procedure
    # may be called from main panel.
    if {[winfo exists $w]} {
        $w delete 0 end
    }
}

proc alias_batch { w } {

    global nlen
    global batchAliaslist
    global batchAliasdb
        
    # If the cache was not initialized, initialize it.
    if {[ff_checkCacheDB $batchAliasdb batchAliaslist]} {
        return
    }

    set alias [dialog_main -entryRelief [entryRelief] \
	-message "Enter alias name for this batch"]
    if {$alias == ""} {
    	return
    }

    # If batch alias already exists, replace it with the new
    # recipient list.
    if {[lsearch -exact [array name batchAliaslist] $alias] >= 0} {
	set "batchAliaslist($alias)" {}
    }

    set batchSize [$w size]
    for {set idx 0} {$idx < $batchSize} {incr idx} {
	set entry [$w get $idx]
	# Extract the name.
	set name [string trim [string range $entry 0 $nlen]]
    	lappend "batchAliaslist([string trim $alias])" $name 
    }

    # Update database on disk
    ff_updateDB $batchAliasdb batchAliaslist
}

proc remove_recipient { w } {

    global batch_destinations

    set idx [$w curselection]
    if {$idx == ""} {
	return
    }
    $w delete $idx 
    set batch_destinations {}
    set size [$w size]
    for {set i 0} {$i < $size} {incr i} {
	lappend batch_destinations [$w get $i]
    }
}
