#  Copyright (c) 1994 A & A Custom Software.
#  All rights reserved.
# 
#  Redistribution and use in source and binary forms, with or without
#  modification, are permitted provided that the following conditions
#  are met:
#  1. Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in the
#     documentation and/or other materials provided with the distribution.
#  3. All advertising materials mentioning features or use of this software
#     must display the following acknowledgement:
#       This product includes software developed by A & A Custom Software 
#       and its contributors.
#  4. Neither the name of A & A Custom Software nor the names of its 
#     contributors may be used to endorse or promote products derived from this 
#     software without specific prior written permission.
# 
#  THIS SOFTWARE IS PROVIDED BY A & A CUSTOM SOFTWARE AND CONTRIBUTORS ``AS IS''
#  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
#  ARE DISCLAIMED.  IN NO EVENT SHALL A & A CUSTOM SOFTWARE OR CONTRIBUTORS BE 
#  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
#  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
#  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
#  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
#  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
#  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
#  POSSIBILITY OF SUCH DAMAGE.
# 
# $Id: ff_listBatches.t,v 1.2 1994/10/22 22:27:54 andy Exp $
#
# Make a listbox to view the batch aliases.
#

proc ff_listBatches { t } {

    global batchAliaslist
    global batchAliasdb
    global phonedb
    global phonelist

    # If the cache was not initialized, initialize it.
    if {[ff_checkCacheDB $phonedb phonelist]} {
	return
    }

    # If the cache was not initialized, initialize it.
    if {[ff_checkCacheDB $batchAliasdb batchAliaslist]} {
        return
    }

    catch {destroy $t}
    toplevel $t

    wm title $t "Batch Alias List"
    wm minsize $t 100 100
    wm geometry $t 300x200

    ut_mkFrame $t {f {} {} oper {-relief sunken} {-side bottom -fill x}}
    scrollbar $t.f.scr -relief sunken -command "$t.f.bx yview"
    listbox $t.f.bx -yscroll "$t.f.scr set" -relief sunken
    ut_mkButton $t.oper [list \
	    b_remove "REMOVE -command \{remove_alias $t.f.bx\}" {} \
	    b_select "SELECT -command \{select_alias $t.f.bx\}" {} \
	    b_cancel "DISMISS -command \{destroy $t\}" {}]
    pack $t.f.scr -side left -fill y 
    pack $t.f.bx -side right -fill both -expand 1
    tk_listboxSingleSelect $t.f.bx

    foreach i [array name batchAliaslist] {
	$t.f.bx insert end $i
    }
}

proc remove_alias { w } {

    global batchAliaslist
    global batchAliasdb
    global nlen
        
    set idx [$w curselection]
    if {$idx == ""} {
	return
    }
    set name [$w get $idx]

    unset "batchAliaslist($name)"

    # Update database on disk
    ff_updateDB $batchAliasdb batchAliaslist

    # Show updated fax aliases
    $w delete $idx
}

proc select_alias { w } {

    global batch_destinations
    global phonelist
    global batchAliaslist
    global clen
    global plen
    global nlen

    set idx [$w curselection]
    if {$idx == ""} {
	return
    }
    set name [$w get $idx]

    # For each name associated with this alias, load the batch
    # destination list.
    foreach n $batchAliaslist($name) {
	if {![info exists phonelist($n)]} {
	    contiue
	}
	set company [lindex $phonelist($n) 0]
	set phone [lindex $phonelist($n) 1]
	set style "%-${nlen}.${nlen}s  %-${clen}.${clen}s  %${plen}.${plen}s"
	set entry [format "$style" $n $company $phone]
	lappend batch_destinations $entry
    }

    # Update the batch listbox
    if {[winfo exists .viewbatch]} {
	.viewbatch.f.bx delete 0 end
	foreach d $batch_destinations {
	    .viewbatch.f.bx insert end $d
	}
    }

    # Clear selection
    $w select clear
}
