#
#  Copyright (c) 1994 A & A Custom Software.
#  All rights reserved.
# 
#  Redistribution and use in source and binary forms, with or without
#  modification, are permitted provided that the following conditions
#  are met:
#  1. Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in the
#     documentation and/or other materials provided with the distribution.
#  3. All advertising materials mentioning features or use of this software
#     must display the following acknowledgement:
#       This product includes software developed by A & A Custom Software 
#       and its contributors.
#  4. Neither the name of A & A Custom Software nor the names of its 
#     contributors may be used to endorse or promote products derived from this 
#     software without specific prior written permission.
# 
#  THIS SOFTWARE IS PROVIDED BY A & A CUSTOM SOFTWARE AND CONTRIBUTORS ``AS IS''
#  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
#  ARE DISCLAIMED.  IN NO EVENT SHALL A & A CUSTOM SOFTWARE OR CONTRIBUTORS BE 
#  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
#  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
#  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
#  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
#  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
#  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
#  POSSIBILITY OF SUCH DAMAGE.
# 
# $Id: faxit.t,v 1.12 1994/12/31 18:22:00 andy Exp $
#
# Fax a file(s). The "Ooops_only" argument indicates whether or not to
# report all errors and successes (default) or to report only errors.
#


proc faxit { w {Ooops_only false}} {

    global resolution
    global noCoverPage
    global initiatePoll
    global notifyOnCompletion
    global notifyOnRetry

    # Get cover sheet information
    foreach c [winfo children $w.cover.e] {
	# Get child name
	set cname [winfo name $c]
	# Remove "e_" to get variable name 
	set f [string range $cname 2 end]
	switch -glob -- $f comments* {
	    append comments "[$c get] "
	} default {
	    set $f [string trim [$c get]]
	}
    }

    # If no phone number then abort the request	
    if {[string length $phone] == 0} {
	tk_dialog .err "Ooops!" "There's no fax phone number." warning 0 OK
	return
    }

    # Now get scheduling information
    set tries [ut_getValue $w.schedule.retries.l_tries]
    set delay_hrs [ut_getValue $w.schedule.time.l_hour] 
    set delay_min [ut_getValue $w.schedule.time.l_min] 

    # Determine whether this is a cover-sheet-only request. 
    set sz [$w.docs.bx size] 
    if {$sz == 0} {
	set res \
	    [tk_dialog .err "Ooops!" "No files have been specified. \
	    Shall just the cover sheet be sent?" questhead 0 OK Cancel] 
	switch -exact -- $res 1 {
	    return
	} default {
	    append faxcmd "[ff_mkCover $w.cover.e] | sendfax -n" 

	    set delay [expr ($delay_hrs*60) + $delay_min]
	    if {$delay > 0} {
		append faxcmd " -a \"now+$delay minutes\""
	    }

	    if {[string length $name]} {
		# This MUST appear.
		append faxcmd " -d \"$name@$phone\""

		# Make an ID string for later usage
		append faxcmd " -i \"$name@$company\"" 
	    } else {
		# This MUST appear.
		append faxcmd " -d $phone"
	    }

	    if {$tries > 0} {
		append faxcmd " -t $tries"
	    }

	    append faxcmd $resolution $initiatePoll $notifyOnCompletion \
		$notifyOnRetry
	}
    } elseif {$sz > 0} {
	# Make command. I currently ignore the following options: -k -s -h -v 
	append faxcmd "sendfax "
	set delay [expr ($delay_hrs*60) + $delay_min]
	if {$delay > 0} {
	    append faxcmd " -a \"now+$delay minutes\""
	}

	set comments [string trim $comments]
	if {[string length $comments]} {
	    append faxcmd " -c \"$comments\""
	}

	if {[string length $regard]} {
	    append faxcmd " -r \"$regard\""
	}

	if {[string length $company]} {
	    append faxcmd " -x \"$company\""
	}

	if {[string length $location]} {
	    append faxcmd " -y \"$location\""
	}

	if {[string length $name]} {
	    # This MUST appear.
	    append faxcmd " -d \"$name@$phone\""

	    # Make an ID string for later usage
	    append faxcmd " -i \"$name@$company\"" 
	} else {
	    # This MUST appear.
	    append faxcmd " -d $phone"
	}

	if {$tries > 0} {
	    append faxcmd " -t $tries"
	}

	append faxcmd $resolution $initiatePoll $notifyOnCompletion \
	    $notifyOnRetry $noCoverPage

	# Append all the files.
	for {set i 0} {$i < $sz} {incr i} {
	    append faxcmd " [glob [$w.docs.bx get $i]]"
	}
    }

    # Exec it
    if {[catch {eval exec $faxcmd} err]} {
	tk_dialog .err "Ooops!" "$err" questhead 0 OK
    } else {
	if {$Ooops_only == "false"} {
	    tk_dialog .err "Send FAX Status" "Fax job queued ok" info 0 OK
	}
    }
}
