' $Id$
.TH oop tcl
.BS
.SH NAME
Object Oriented Programming in Tcl
.SH DESCRIPTION
.PP
Simple techniques are used. Only the \fBnew\fR and \fBdelete\fR operators are available and are implemented as Tcl procedures. Some responsibility is left to the programmer which must be familiar with object oriented techniques and an object oriented language (C++ is recommended).
.SH MEMBER DATA ACCESS
.PP
The object members can be accessed using the object identifier and the global class array, as in:
.PP
\fBglobal className\fR
.in
\fBputs $className(\fIobjectId\fB,memberName)\fR
.PP
The class member data array is at the global level, so the \fBglobal\fR command needs be used within procedures.
.SH MEMBER FUNCTION ACCESS
.PP
The member functions are called using the object identifier, as in:
.PP
\fBclassName::functionName \fIobjectId parameter ...\fR
.SH INHERITANCE
.PP
It is the programmer's responsibility to implement inheritance, as in:
.sp
.RS
.nf
\fBbase::base\fR {id parameter} {
    global base
    \fI# base members initialization ...\fR
}
\fBbase::~base\fR {id} {
    global base
    \fI# use base members data for some cleanup ...\fR
}
\fBderived::derived\fR {id parameter} {
    \fI# initialize object base part by directly calling the base constructor
    \fBbase::base\fR $id
    global derived
    \fI# derived members initialization ...\fR
    global base
    \fI# more initialization using base members ...\fR
}
\fBderived::~derived\fR {id} {
    global derived
    \fI# use derived members data for some cleanup ...\fR
    global base
    \fI# and eventually base members data for some cleanup ...\fR
    \fI# now delete base part\fR
    \fBdelete base\fR $id
}
.fi
.RE
.PP
The derived class constructor calls the base constructor, and the derived class destructor takes care of deleting the base part of the object by calling \fBdelete\fR directly for the base part.
.SH MULTIPLE INHERITANCE
.PP
The simple inheritance technique is simply extended.
.PP
The derived class constructor calls the base constructors, and the derived class destructor takes care of deleting the base parts of the object by calling \fBdelete\fR directly as many times as there are base parts.
.SH LIMITATIONS
There is no member access control, but this is simple and as it is implemented in Tcl requires no extension.
.PP
In the inheritance scheme, when deleting objects, the base part member data is deallocated before the derived part member data, which may shock some C++ purists, but seems without any serious consequence.
.SH KEYWORDS
.PP
oop, new, delete, object
