#
# executes a command and mails back the output
#
# usage: swish -nointerface -messaging -messagebody - -file mailback.tcl 
#	     logident logfile entity command
#
# e.g., 
#
#    /usr/local/bin/swish ... -file /var/mail/scripts/mailback.tcl \
#			      faxstat /var/tmp/mailinfo.log \
#			      postmaster 'faxstat -a'
#

if {$argc != 4} {
    puts    stdout	"usage: ... logident logfile entity command"
    return
}
set	logident	[format "%-8s" [lindex $argv 0]]
set	logfile		[lindex $argv 1]
set	entity		[lindex $argv 2]
set	command		[lindex $argv 3]


set	logfd	""
set	logpid	""
set	loguser	""
set logmonth(Jan) 1
set logmonth(Feb) 2
set logmonth(Mar) 3
set logmonth(Apr) 4
set logmonth(May) 5
set logmonth(Jun) 6
set logmonth(Jul) 7
set logmonth(Aug) 8
set logmonth(Sep) 9
set logmonth(Oct) 10
set logmonth(Nov) 11
set logmonth(Dec) 12

proc	logwrite {string} {
    global    env logfd logfile logident logmonth logpid loguser

    set now [SafeTcl_getdateprop "" proper]

    if {$logfd == ""} {
	if {[catch { set logfd [open $logfile "a"] }]} {
	    return
	}

	set	logpid	[format "%05d" [pid]]
	if {[catch { set loguser [format "%-8s" $env(USER)] }]} {
	    set	loguser	[format "%-8s" [concat "#" [id userid]]]
	}
    } else {
	seek	$logfd	0 end
    }

    set date [format "%s/%s %s" $logmonth([string range $now 8 10]) \
                     [string range $now 5 6] [string range $now 17 24]]
    puts $logfd "$date $logident $logpid $loguser $string"
}

proc	logclose {} {
    global    logfd

    if {$logfd != ""} {
	catch { close $logfd }
	set	logfd	""
    }
}


if {([set from [SafeTcl_getheader "Reply-To"]] == "")
	&& ([set from [SafeTcl_getheader "From"]] == "")
	&& ([set from [SafeTcl_getheader "Sender"]] == "")
	&& ([set from [SafeTcl_getheader "Return-Path"]] == "")} {
    catch { set from $SafeTcl_Originator }
    if {$from == ""} {
	logwrite    "ERR  unable to determine return address"
	logclose
	return
    }
}

if {[set subject [SafeTcl_getheader "Subject"]] == ""} {
    set subject "Your message to $logident"
} else {
    set	subject	"Re: $subject"
}

if {[set id [SafeTcl_getheader "Resent-Message-ID"]] == ""} {
    set	id	[SafeTcl_getheader "Message-ID"]
}
logwrite    "INIT $from $id ($subject)"


if {[set type [SafeTcl_getbodyprop "1" "type"]] != "text/plain"} {
    logwrite    "ERR  not a plain text content ($type)"

    if {[catch { MIME_sendmessage -to $from -subject $subject \
		     -auxheader "From" $entity \
		     -body [SafeTcl_makebody "text/plain" \
			        -parameter "charset=us-ascii" \
			        "not a plain text content ($type)"] } \
	     result]} {
	logwrite    "ERR  unable to send reply: $result"
    }

    logclose
    return
}


if {[catch { set input [SafeTcl_decode \
			    [SafeTcl_getbodyprop "1" "encoding"] \
			    [SafeTcl_getbodyprop "1" "value"]] } result]} {
    logwrite	"ERR  decoding failed: $result"
    append	subject	" (failed)"
} elseif {[catch { set result [exec sh -c $command << $input] } result]} {
    logwrite    "ERR  command failed: $result"
    append	subject	" (failed)"
} else {
    append	subject	" (success)"
}
catch	{ unset input }

if {[catch { MIME_sendmessage -to $from -subject $subject \
		 -auxheader "From" $entity \
	         -body [SafeTcl_makebody "text/plain" \
			    -parameter "charset=us-ascii" \
			    $result] } result]} {
    logwrite    "ERR  unable to send reply: $result"
}

logwrite    "DONE $command"
logclose


return
