#
# $Header: /home/rockware/cvs-main/operator/tcl/opStartup.tcl,v 1.27 1995/03/05 22:28:18 erez Exp $
# Written by: Erez Strauss (C) All Rights Reserved 1994, 1995.
#
# 16. Initialize the operator
proc opOperatorInit {} {
    # Global Variables, the first part - those that doesn't need any function
    #  for initialization. The second part is defined at the end of the file
    #  before calling the start up function.
    # *** Seperate to different subjects.
    # *** Change all the global variable into one array variable OPerator()
    # *** Set all the WM information.
    #   client <== [host name]
    #   command <== "Operator ..."
    wm withdraw .
    wm title . Operator
    wm iconname . Operator
    wm minsize . 1 1
    wm geometry . -100+10
    wm command . Operator

    global OPInfo
    global OPSelf argv0
    global OPVersion
    global OPTextEditor OPCompileCommand OPHomeDir OPUserName
    global OPPath OPPathBitmap OPPathTcl OPPathData
    global env
    global OPBalloonsFlag OPHelpStack OPHelpMessage
    set OPVersion [exec cat [file dirname $OPSelf]/Version | tail -1]
    set OPBalloonsFlag 1
    set OPHelpStack {}
    set OPHelpMessage {}

    opLanguageLoad
    opHelpCreateIndexMenu

    # Speed run information: Text(Name) cd Command Bitmap ActiveHelpMessage
    # *** Add entries from the Freedom package.
    #
    if [info exists env(OP_EDITOR)] {set OPTextEditor $env(OP_EDITOR)} {
        set OPTextEditor to-emacs
    }
    if [info exists env(OP_COMPILE_COMMAND)] {
        set OPCompileCommand $env(OP_COMPILE_COMMAND)
    } {
        set OPCompileCommand make
    }
    if [info exists env(HOME)] {set OPHomeDir $env(HOME)} {set OPHomeDir {}}
    if [info exists env(USER)] {set OPUserName $env(USER)} {set OPUserName {}}
    if ![file isdirectory [file dirname $OPSelf]/bin] {
        puts "Installation problems: can't find Operator bin directory."
        exit 1
    }
    set OPPath [file dirname $OPSelf]/bin
    if [info exists env(PATH)] {
        set OPPath "$OPPath [split $env(PATH) :]"
    }
    if ![file isdirectory [file dirname $OPSelf]/icons] {
        puts "Installation problems: can't find Operator bitmaps directory."
        exit 1
    }
    set OPPathTcl    [file dirname $OPSelf]/tcl
    set OPPathBitmap [file dirname $OPSelf]/icons
    set OPPathData   "[glob ~]/operator [glob ~]/.operator [file dirname $OPSelf]/data [file dirname $OPSelf]/etc"
    # General Bindings
    # *** test and improve the Help sub-system.
    # *** add all the needed Action Icon windows, Trash, Print, Edit, Run, ...
    # *** load user init File(s).
    OpTopLevel :: bind_all <F1> {opHelp [winfo containing %X %Y] %X %Y}
    bind all <Help> {opHelp [winfo containing %X %Y] %X %Y}
    bind all <Shift-Button-3> {opHelp %W}
    bind all <F1> {opHelp %W}
    setup_motif
    option add *Listbox.relief sunken
    wm iconbitmap . @[opNameToFile rocket bitmap]
    source [opNameToFile opDialogs.tcl tcl]
    # User optional init files.
    opUserSetup
    if {[glob -nocomplain $OPInfo(user_init_file)] != {}} {
        source $OPInfo(user_init_file)
    }
}
# ---------------------------------------------------------------------------
# The opUserSetup check what directory to create (if needed).
# also Create a copy of the app-list (applications list).
# user directories ( ~/operator ~/operator/trash ) || ( ~/.operator ... )
# user files ( ~/operator/init.tcl ~/operator/app-list ) || ( ~/.operator ... )
# ---------------------------------------------------------------------------
proc opUserSetup {} {
    global OPSelf OPInfo
    foreach odir {~/operator ~/.operator} {
        set odir [glob -nocomplain $odir]
        if {$odir != {}} {
            break
        }
    }
    if {$odir == {}} {
        # Create New set.
        set errCode [catch {
            exec mkdir -p [glob ~]/operator [glob ~]/operator/trash
        } errString]
        if $errCode {
            puts stderr "Can create ~/operator directory !" 
            exit 1
        }
        set odir [glob ~/operator]
    }
    set OPInfo(user_oper_dir) $odir
    if ![file isdirectory $OPInfo(user_oper_dir)/trash] {
        exec mkdir -p $OPInfo(user_oper_dir)/trash
    }
    set OPInfo(user_trash_dir) $OPInfo(user_oper_dir)/trash

    if ![file readable $odir/init.tcl] {
        exec cp [file dirname $OPSelf]/etc/init.tcl $odir/init.tcl
    }
    set OPInfo(user_init_file) $OPInfo(user_oper_dir)/init.tcl

    if ![file readable $odir/app-list] {
        exec cp [file dirname $OPSelf]/etc/app-list $odir/app-list
    }
    set OPInfo(user_app_list) $odir/app-list
}
proc opACtionIconsCreate {} {
    # *** Create all Stand alone Icons.
    # *** Trash/Garbage Open/Run, Printer, Fax, Disk-Save, Edit, ...
    # toplevel .trash
    # wm title .trash Trash
    # wm iconname .trash Trash
    # wm name .trash Trash
    # toplevel .trash-icon
    # frame .trash-icon
    # wm withdraw .trash-icon
    # label .trash-icon.l -bitmap @[opNameToFile xterm bitmap]
    # pack .trash-icon.l
    # wm iconwindow .trash .trash-icon
    # wm iconify .trash
    # pack .trash-icon
    # wm deiconify .trash-icon
}
proc opOptionalPkgsInit {} {
    # Initialize optional packages that the Operator make use of.

    # tix - optional package
    # The Tix 3.6 did not need a special compiled version of wish.
    if [info exists env(TIX_LIBRARY)] {
        if [file isdirectory $env(TIX_LIBRARY)] {
            global auto_path TIX_LIBRARY
            set TIX_LIBRARY $env(TIX_LIBRARY)
            lappend auto_path $TIX_LIBRARY
            if [auto_load tixInit] {
                tixInit \
                    -beta false \
                    -binding Motif \
                    -debug false \
                    -fontset TK \
                    -libdir $TIX_LIBRARY \
                    -scheme Gray
            }
        }
    }
    # Other opetions for the tix init.
    # -scheme Blue | Gray | TK
    # -fontset 12Point | 14Point | TK
    # The tixInit flags
    #  -beta boolean        - false
    #  -binding  bName      - Motif
    #  -debug  boolean      - false
    #  -fontset fName       - 12Point / 14Point / TK
    #  -libdir path         - installation depend.
    #  -scheme sName        - Gray / SGIGray / Blue / TK
}
